/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.model;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.gephi.data.attributes.type.BigDecimalList;
import org.gephi.data.attributes.type.BigIntegerList;
import org.gephi.data.attributes.type.BooleanList;
import org.gephi.data.attributes.type.ByteList;
import org.gephi.data.attributes.type.CharacterList;
import org.gephi.data.attributes.type.DoubleList;
import org.gephi.data.attributes.type.FloatList;
import org.gephi.data.attributes.type.IntegerList;
import org.gephi.data.attributes.type.LongList;
import org.gephi.data.attributes.type.ShortList;
import org.gephi.data.attributes.type.StringList;
import org.gephi.data.attributes.type.TimeInterval;

public class DataIndex {
    private static final Class[] SUPPORTED_TYPES = new Class[]{String.class, BigInteger.class, BigDecimal.class, TimeInterval.class, ByteList.class, ShortList.class, IntegerList.class, LongList.class, FloatList.class, DoubleList.class, BooleanList.class, CharacterList.class, StringList.class, BigIntegerList.class, BigDecimalList.class};
    private static Map<Class<?>, WeakHashMap> centralHashMap;

    public DataIndex() {
        centralHashMap = new HashMap();
        for (Class supportedType : SUPPORTED_TYPES) {
            DataIndex.putInCentralMap(supportedType);
        }
    }

    private static <T> void putInCentralMap(Class<T> supportedType) {
        centralHashMap.put(supportedType, new WeakHashMap());
    }

    public int countEntries() {
        int entries = 0;
        for (WeakHashMap weakHashMap : centralHashMap.values()) {
            entries += weakHashMap.size();
        }
        return entries;
    }

    <T> T pushData(T data) {
        Class<?> classObjectKey = data.getClass();
        WeakHashMap weakHashMap = centralHashMap.get(classObjectKey);
        if (weakHashMap == null) {
            return data;
        }
        WeakReference value = (WeakReference)weakHashMap.get(data);
        if (value == null) {
            WeakReference<T> weakRef = new WeakReference<T>(data);
            weakHashMap.put(data, weakRef);
            return data;
        }
        return value.get();
    }

    public void clear() {
        for (WeakHashMap weakHashMap : centralHashMap.values()) {
            weakHashMap.clear();
        }
    }
}

