/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.serialization;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;

public class AttributeModelSerializer {
    private static final String ELEMENT_MODEL = "attributemodel";
    private static final String ELEMENT_TABLE = "table";
    private static final String ELEMENT_COLUMN = "column";
    private static final String ELEMENT_COLUMN_INDEX = "index";
    private static final String ELEMENT_COLUMN_ID = "id";
    private static final String ELEMENT_COLUMN_TITLE = "title";
    private static final String ELEMENT_COLUMN_TYPE = "type";
    private static final String ELEMENT_COLUMN_ORIGIN = "origin";
    private static final String ELEMENT_COLUMN_DEFAULT = "default";

    public void writeModel(XMLStreamWriter writer, AbstractAttributeModel model) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_MODEL);
        if (model != null) {
            for (AttributeTableImpl table : model.getTables()) {
                this.writeTable(writer, table, model);
            }
        }
        writer.writeEndElement();
    }

    public void readModel(XMLStreamReader reader, AbstractAttributeModel model) throws XMLStreamException {
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_TABLE.equalsIgnoreCase(name)) break;
                    AttributeTableImpl table = Boolean.parseBoolean(reader.getAttributeValue(null, "nodetable")) ? model.getNodeTable() : (Boolean.parseBoolean(reader.getAttributeValue(null, "edgetable")) ? model.getEdgeTable() : (Boolean.parseBoolean(reader.getAttributeValue(null, "graphtable")) ? model.getGraphTable() : new AttributeTableImpl(model, "")));
                    this.readTable(reader, table);
                    if (table == model.getNodeTable() || table == model.getEdgeTable() || table == model.getGraphTable()) continue block4;
                    model.addTable(table);
                    break;
                }
                case 2: {
                    if (!ELEMENT_MODEL.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void writeTable(XMLStreamWriter writer, AttributeTableImpl table, AbstractAttributeModel model) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_TABLE);
        writer.writeAttribute("name", table.getName());
        writer.writeAttribute("version", String.valueOf(table.getVersion()));
        writer.writeAttribute("nodetable", String.valueOf(table == model.getNodeTable()));
        writer.writeAttribute("edgetable", String.valueOf(table == model.getEdgeTable()));
        writer.writeAttribute("graphtable", String.valueOf(table == model.getGraphTable()));
        for (AttributeColumnImpl columnImpl : table.getColumns()) {
            this.writeColumn(writer, columnImpl);
        }
        writer.writeEndElement();
    }

    public void readTable(XMLStreamReader reader, AttributeTableImpl table) throws XMLStreamException {
        table.setName(reader.getAttributeValue(null, "name"));
        int version = Integer.parseInt(reader.getAttributeValue(null, "version"));
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_COLUMN.equalsIgnoreCase(name)) break;
                    this.readColumn(reader, table);
                    break;
                }
                case 2: {
                    if (!ELEMENT_TABLE.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        table.setVersion(version);
    }

    public void writeColumn(XMLStreamWriter writer, AttributeColumnImpl column) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_COLUMN);
        writer.writeStartElement(ELEMENT_COLUMN_INDEX);
        writer.writeCharacters(String.valueOf(column.getIndex()));
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_COLUMN_ID);
        writer.writeCharacters(String.valueOf(column.getId()));
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_COLUMN_TITLE);
        writer.writeCharacters(String.valueOf(column.getTitle()));
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_COLUMN_TYPE);
        writer.writeCharacters(column.getType().getTypeString());
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_COLUMN_ORIGIN);
        writer.writeCharacters(column.getOrigin().name());
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_COLUMN_DEFAULT);
        if (column.getDefaultValue() != null) {
            writer.writeCharacters(column.getDefaultValue().toString());
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readColumn(XMLStreamReader reader, AttributeTableImpl table) throws XMLStreamException {
        Object defaultVal;
        int index = 0;
        String id = "";
        String title = "";
        AttributeType type = AttributeType.STRING;
        AttributeOrigin origin = AttributeOrigin.DATA;
        String defaultValue = "";
        boolean end = false;
        String name = null;
        while (reader.hasNext() && !end) {
            int t = reader.next();
            switch (t) {
                case 1: {
                    name = reader.getLocalName();
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace()) break;
                    if (ELEMENT_COLUMN_INDEX.equalsIgnoreCase(name)) {
                        index = Integer.parseInt(reader.getText());
                        break;
                    }
                    if (ELEMENT_COLUMN_ID.equalsIgnoreCase(name)) {
                        id = id + reader.getText();
                        break;
                    }
                    if (ELEMENT_COLUMN_TITLE.equalsIgnoreCase(name)) {
                        title = title + reader.getText();
                        break;
                    }
                    if (ELEMENT_COLUMN_TYPE.equalsIgnoreCase(name)) {
                        type = AttributeType.valueOf(reader.getText());
                        break;
                    }
                    if (ELEMENT_COLUMN_ORIGIN.equalsIgnoreCase(name)) {
                        origin = AttributeOrigin.valueOf(reader.getText());
                        break;
                    }
                    if (!ELEMENT_COLUMN_DEFAULT.equalsIgnoreCase(name) || reader.getText().isEmpty()) break;
                    defaultValue = defaultValue + reader.getText();
                    break;
                }
                case 2: {
                    if (!ELEMENT_COLUMN.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        Object object = defaultVal = !defaultValue.isEmpty() ? type.parse(defaultValue) : null;
        if (!table.hasColumn(title)) {
            table.addColumn(id, title, type, origin, defaultVal);
        } else {
            table.replaceColumn(table.getColumn(title), id, title, type, origin, defaultVal);
        }
    }
}

