/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.serialization;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeRowImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;

public class AttributeRowSerializer {
    private static final String ELEMENT_ROWS = "attributerows";
    private static final String ELEMENT_NODE_ROW = "noderow";
    private static final String ELEMENT_EDGE_ROW = "edgerow";
    private static final String ELEMENT_VALUE = "attvalue";

    public void writeRows(XMLStreamWriter writer, GraphModel graphModel) throws XMLStreamException {
        AttributeRowImpl row;
        writer.writeStartElement(ELEMENT_ROWS);
        HierarchicalGraph hierarchicalGraph = graphModel.getHierarchicalGraph();
        for (Node node : hierarchicalGraph.getNodesTree()) {
            if (node.getNodeData().getAttributes() == null || !(node.getNodeData().getAttributes() instanceof AttributeRowImpl)) continue;
            row = (AttributeRowImpl)node.getNodeData().getAttributes();
            writer.writeStartElement(ELEMENT_NODE_ROW);
            writer.writeAttribute("for", String.valueOf(node.getId()));
            if (!this.writeRow(writer, row)) continue;
            writer.writeEndElement();
        }
        for (Edge edge : hierarchicalGraph.getEdges()) {
            if (edge.getEdgeData().getAttributes() == null || !(edge.getEdgeData().getAttributes() instanceof AttributeRowImpl)) continue;
            row = (AttributeRowImpl)edge.getEdgeData().getAttributes();
            writer.writeStartElement(ELEMENT_EDGE_ROW);
            writer.writeAttribute("for", String.valueOf(edge.getId()));
            if (!this.writeRow(writer, row)) continue;
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readRows(XMLStreamReader reader, GraphModel graphModel, AbstractAttributeModel attributeModel) throws XMLStreamException {
        HierarchicalGraph hierarchicalGraph = graphModel.getHierarchicalGraph();
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    AttributeRowImpl row;
                    int id;
                    String name = reader.getLocalName();
                    if (ELEMENT_NODE_ROW.equalsIgnoreCase(name)) {
                        id = Integer.parseInt(reader.getAttributeValue(null, "for"));
                        Node node = hierarchicalGraph.getNode(id);
                        if (node.getNodeData().getAttributes() == null || !(node.getNodeData().getAttributes() instanceof AttributeRowImpl)) continue block4;
                        row = (AttributeRowImpl)node.getNodeData().getAttributes();
                        this.readRow(reader, attributeModel, attributeModel.getNodeTable(), row);
                        break;
                    }
                    if (!ELEMENT_EDGE_ROW.equalsIgnoreCase(name)) break;
                    id = Integer.parseInt(reader.getAttributeValue(null, "for"));
                    Edge edge = hierarchicalGraph.getEdge(id);
                    if (edge.getEdgeData().getAttributes() == null || !(edge.getEdgeData().getAttributes() instanceof AttributeRowImpl)) continue block4;
                    row = (AttributeRowImpl)edge.getEdgeData().getAttributes();
                    this.readRow(reader, attributeModel, attributeModel.getEdgeTable(), row);
                    break;
                }
                case 2: {
                    if (!ELEMENT_ROWS.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public boolean writeRow(XMLStreamWriter writer, AttributeRowImpl row) throws XMLStreamException {
        writer.writeAttribute("version", String.valueOf(row.getRowVersion()));
        int writtenRows = 0;
        for (AttributeValue value : row.getValues()) {
            int index = value.getColumn().getIndex();
            Object obj = value.getValue();
            if (obj == null) continue;
            ++writtenRows;
            writer.writeStartElement(ELEMENT_VALUE);
            writer.writeAttribute("index", String.valueOf(index));
            writer.writeCharacters(obj.toString());
            writer.writeEndElement();
        }
        return writtenRows > 0;
    }

    public void readRow(XMLStreamReader reader, AbstractAttributeModel model, AttributeTableImpl table, AttributeRowImpl row) throws XMLStreamException {
        row.setRowVersion(Integer.parseInt(reader.getAttributeValue(null, "version")));
        Integer index = null;
        String value = "";
        boolean end = false;
        while (reader.hasNext() && !end) {
            int t = reader.next();
            switch (t) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_VALUE.equalsIgnoreCase(name)) break;
                    index = Integer.parseInt(reader.getAttributeValue(null, "index"));
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace() || index == null) break;
                    value = value + reader.getText();
                    break;
                }
                case 2: {
                    if (ELEMENT_NODE_ROW.equalsIgnoreCase(reader.getLocalName()) || ELEMENT_EDGE_ROW.equalsIgnoreCase(reader.getLocalName())) {
                        end = true;
                    }
                    if (!value.isEmpty() && index != null) {
                        AttributeType type = table.getColumn(index).getType();
                        Object v = type.parse(value);
                        if (v != null) {
                            v = model.getManagedValue(v, type);
                        } else {
                            Logger.getLogger(AttributeRowSerializer.class.getName()).log(Level.WARNING, "Unable to parse \"{0}\" as type {1}", new Object[]{value, type.toString()});
                        }
                        row.setValue(index, v);
                    }
                    value = "";
                    index = null;
                }
            }
        }
    }
}

