/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicBoolean
extends DynamicType<Boolean> {
    public DynamicBoolean() {
    }

    public DynamicBoolean(Interval<Boolean> in) {
        super(in);
    }

    public DynamicBoolean(List<Interval<Boolean>> in) {
        super(in);
    }

    public DynamicBoolean(DynamicBoolean source) {
        super(source);
    }

    public DynamicBoolean(DynamicBoolean source, Interval<Boolean> in) {
        super(source, in);
    }

    public DynamicBoolean(DynamicBoolean source, Interval<Boolean> in, Interval<Boolean> out) {
        super(source, in, out);
    }

    public DynamicBoolean(DynamicBoolean source, List<Interval<Boolean>> in) {
        super(source, in);
    }

    public DynamicBoolean(DynamicBoolean source, List<Interval<Boolean>> in, List<Interval<Boolean>> out) {
        super(source, in, out);
    }

    @Override
    public Boolean getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Boolean)values.get(values.size() / 2);
                }
                return (Boolean)values.get(values.size() / 2 - 1);
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Boolean)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Boolean)values.get(i)).hashCode());
                    }
                    map.put(((Boolean)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Boolean)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Boolean)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Boolean)values.get(i)).hashCode());
                    index = i;
                }
                return (Boolean)values.get(index);
            }
            case SUM: {
                throw new UnsupportedOperationException("Not supported estimator");
            }
            case MIN: {
                Boolean minimum = (Boolean)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo((Boolean)values.get(i)) <= 0) continue;
                    minimum = (Boolean)values.get(i);
                }
                return minimum;
            }
            case MAX: {
                Boolean maximum = (Boolean)values.get(0);
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo((Boolean)values.get(i)) >= 0) continue;
                    maximum = (Boolean)values.get(i);
                }
                return maximum;
            }
            case FIRST: {
                return (Boolean)values.get(0);
            }
            case LAST: {
                return (Boolean)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Boolean.class;
    }
}

