/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicByte
extends DynamicType<Byte> {
    public DynamicByte() {
    }

    public DynamicByte(Interval<Byte> in) {
        super(in);
    }

    public DynamicByte(List<Interval<Byte>> in) {
        super(in);
    }

    public DynamicByte(DynamicByte source) {
        super(source);
    }

    public DynamicByte(DynamicByte source, Interval<Byte> in) {
        super(source, in);
    }

    public DynamicByte(DynamicByte source, Interval<Byte> in, Interval<Byte> out) {
        super(source, in, out);
    }

    public DynamicByte(DynamicByte source, List<Interval<Byte>> in) {
        super(source, in);
    }

    public DynamicByte(DynamicByte source, List<Interval<Byte>> in, List<Interval<Byte>> out) {
        super(source, in, out);
    }

    @Override
    public Byte getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Byte)values.get(0);
                }
                BigInteger total = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigInteger.valueOf(((Byte)values.get(i)).byteValue()));
                }
                return total.divide(BigInteger.valueOf(values.size())).byteValue();
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Byte)values.get(values.size() / 2);
                }
                BigInteger bi = BigInteger.valueOf(((Byte)values.get(values.size() / 2 - 1)).byteValue());
                bi = bi.add(BigInteger.valueOf(((Byte)values.get(values.size() / 2)).byteValue()));
                return bi.divide(BigInteger.valueOf(2L)).byteValue();
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Byte)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Byte)values.get(i)).hashCode());
                    }
                    map.put(((Byte)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Byte)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Byte)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Byte)values.get(i)).hashCode());
                    index = i;
                }
                return (Byte)values.get(index);
            }
            case SUM: {
                BigInteger sum = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(BigInteger.valueOf(((Byte)values.get(i)).byteValue()));
                }
                return sum.byteValue();
            }
            case MIN: {
                BigInteger minimum = BigInteger.valueOf(((Byte)values.get(0)).byteValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(BigInteger.valueOf(((Byte)values.get(i)).byteValue())) <= 0) continue;
                    minimum = BigInteger.valueOf(((Byte)values.get(i)).byteValue());
                }
                return minimum.byteValue();
            }
            case MAX: {
                BigInteger maximum = BigInteger.valueOf(((Byte)values.get(0)).byteValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(BigInteger.valueOf(((Byte)values.get(i)).byteValue())) >= 0) continue;
                    maximum = BigInteger.valueOf(((Byte)values.get(i)).byteValue());
                }
                return maximum.byteValue();
            }
            case FIRST: {
                return (Byte)values.get(0);
            }
            case LAST: {
                return (Byte)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Byte.class;
    }
}

