/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicFloat
extends DynamicType<Float> {
    public DynamicFloat() {
    }

    public DynamicFloat(Interval<Float> in) {
        super(in);
    }

    public DynamicFloat(List<Interval<Float>> in) {
        super(in);
    }

    public DynamicFloat(DynamicFloat source) {
        super(source);
    }

    public DynamicFloat(DynamicFloat source, Interval<Float> in) {
        super(source, in);
    }

    public DynamicFloat(DynamicFloat source, Interval<Float> in, Interval<Float> out) {
        super(source, in, out);
    }

    public DynamicFloat(DynamicFloat source, List<Interval<Float>> in) {
        super(source, in);
    }

    public DynamicFloat(DynamicFloat source, List<Interval<Float>> in, List<Interval<Float>> out) {
        super(source, in, out);
    }

    @Override
    public Float getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Float)values.get(0);
                }
                BigDecimal total = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigDecimal.valueOf(((Float)values.get(i)).doubleValue()));
                }
                return Float.valueOf(total.divide(BigDecimal.valueOf(values.size()), 10, RoundingMode.HALF_EVEN).floatValue());
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Float)values.get(values.size() / 2);
                }
                BigDecimal bd = new BigDecimal(((Float)values.get(values.size() / 2 - 1)).floatValue());
                bd = bd.add(new BigDecimal(((Float)values.get(values.size() / 2)).floatValue()));
                return Float.valueOf(bd.divide(new BigDecimal(2)).floatValue());
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Float)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Float)values.get(i)).hashCode());
                    }
                    map.put(((Float)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Float)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Float)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Float)values.get(i)).hashCode());
                    index = i;
                }
                return (Float)values.get(index);
            }
            case SUM: {
                BigDecimal sum = new BigDecimal(0);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(new BigDecimal(((Float)values.get(i)).floatValue()));
                }
                return Float.valueOf(sum.floatValue());
            }
            case MIN: {
                BigDecimal minimum = new BigDecimal(((Float)values.get(0)).floatValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(new BigDecimal(((Float)values.get(i)).floatValue())) <= 0) continue;
                    minimum = new BigDecimal(((Float)values.get(i)).floatValue());
                }
                return Float.valueOf(minimum.floatValue());
            }
            case MAX: {
                BigDecimal maximum = new BigDecimal(((Float)values.get(0)).floatValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(new BigDecimal(((Float)values.get(i)).floatValue())) >= 0) continue;
                    maximum = new BigDecimal(((Float)values.get(i)).floatValue());
                }
                return Float.valueOf(maximum.floatValue());
            }
            case FIRST: {
                return (Float)values.get(0);
            }
            case LAST: {
                return (Float)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Float.class;
    }
}

