/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicInteger
extends DynamicType<Integer> {
    public DynamicInteger() {
    }

    public DynamicInteger(Interval<Integer> in) {
        super(in);
    }

    public DynamicInteger(List<Interval<Integer>> in) {
        super(in);
    }

    public DynamicInteger(DynamicInteger source) {
        super(source);
    }

    public DynamicInteger(DynamicInteger source, Interval<Integer> in) {
        super(source, in);
    }

    public DynamicInteger(DynamicInteger source, Interval<Integer> in, Interval<Integer> out) {
        super(source, in, out);
    }

    public DynamicInteger(DynamicInteger source, List<Interval<Integer>> in) {
        super(source, in);
    }

    public DynamicInteger(DynamicInteger source, List<Interval<Integer>> in, List<Interval<Integer>> out) {
        super(source, in, out);
    }

    @Override
    public Integer getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Integer)values.get(0);
                }
                BigInteger total = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigInteger.valueOf(((Integer)values.get(i)).intValue()));
                }
                return total.divide(BigInteger.valueOf(values.size())).intValue();
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Integer)values.get(values.size() / 2);
                }
                BigInteger bi = BigInteger.valueOf(((Integer)values.get(values.size() / 2 - 1)).intValue());
                bi = bi.add(BigInteger.valueOf(((Integer)values.get(values.size() / 2)).intValue()));
                return bi.divide(BigInteger.valueOf(2L)).intValue();
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Integer)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Integer)values.get(i)).hashCode());
                    }
                    map.put(((Integer)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Integer)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Integer)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Integer)values.get(i)).hashCode());
                    index = i;
                }
                return (Integer)values.get(index);
            }
            case SUM: {
                BigInteger sum = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(BigInteger.valueOf(((Integer)values.get(i)).intValue()));
                }
                return sum.intValue();
            }
            case MIN: {
                BigInteger minimum = BigInteger.valueOf(((Integer)values.get(0)).intValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(BigInteger.valueOf(((Integer)values.get(i)).intValue())) <= 0) continue;
                    minimum = BigInteger.valueOf(((Integer)values.get(i)).intValue());
                }
                return minimum.intValue();
            }
            case MAX: {
                BigInteger maximum = BigInteger.valueOf(((Integer)values.get(0)).intValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(BigInteger.valueOf(((Integer)values.get(i)).intValue())) >= 0) continue;
                    maximum = BigInteger.valueOf(((Integer)values.get(i)).intValue());
                }
                return maximum.intValue();
            }
            case FIRST: {
                return (Integer)values.get(0);
            }
            case LAST: {
                return (Integer)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Integer.class;
    }
}

