/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicLong
extends DynamicType<Long> {
    public DynamicLong() {
    }

    public DynamicLong(Interval<Long> in) {
        super(in);
    }

    public DynamicLong(List<Interval<Long>> in) {
        super(in);
    }

    public DynamicLong(DynamicLong source) {
        super(source);
    }

    public DynamicLong(DynamicLong source, Interval<Long> in) {
        super(source, in);
    }

    public DynamicLong(DynamicLong source, Interval<Long> in, Interval<Long> out) {
        super(source, in, out);
    }

    public DynamicLong(DynamicLong source, List<Interval<Long>> in) {
        super(source, in);
    }

    public DynamicLong(DynamicLong source, List<Interval<Long>> in, List<Interval<Long>> out) {
        super(source, in, out);
    }

    @Override
    public Long getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Long)values.get(0);
                }
                BigInteger total = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigInteger.valueOf((Long)values.get(i)));
                }
                return total.divide(BigInteger.valueOf(values.size())).longValue();
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Long)values.get(values.size() / 2);
                }
                BigInteger bi = BigInteger.valueOf((Long)values.get(values.size() / 2 - 1));
                bi = bi.add(BigInteger.valueOf((Long)values.get(values.size() / 2)));
                return bi.divide(BigInteger.valueOf(2L)).longValue();
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Long)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Long)values.get(i)).hashCode());
                    }
                    map.put(((Long)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Long)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Long)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Long)values.get(i)).hashCode());
                    index = i;
                }
                return (Long)values.get(index);
            }
            case SUM: {
                BigInteger sum = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(BigInteger.valueOf((Long)values.get(i)));
                }
                return sum.longValue();
            }
            case MIN: {
                BigInteger minimum = BigInteger.valueOf((Long)values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(BigInteger.valueOf((Long)values.get(i))) <= 0) continue;
                    minimum = BigInteger.valueOf((Long)values.get(i));
                }
                return minimum.longValue();
            }
            case MAX: {
                BigInteger maximum = BigInteger.valueOf((Long)values.get(0));
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(BigInteger.valueOf((Long)values.get(i))) >= 0) continue;
                    maximum = BigInteger.valueOf((Long)values.get(i));
                }
                return maximum.longValue();
            }
            case FIRST: {
                return (Long)values.get(0);
            }
            case LAST: {
                return (Long)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Long.class;
    }
}

