/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicParser {
    private static final char LOPEN = '(';
    private static final char LCLOSE = '[';
    private static final char ROPEN = ')';
    private static final char RCLOSE = ']';
    private static final char COMMA = ',';
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DatatypeFactory dateFactory;

    public static List<Interval> parseIntervals(AttributeType type, String input) throws IOException, ParseException, IllegalArgumentException {
        int r;
        if (!type.isDynamicType()) {
            throw new IllegalArgumentException(String.format("Type %s is not dynamic", type.getTypeString()));
        }
        if (input.equalsIgnoreCase("<empty>")) {
            return null;
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        StringReader reader = new StringReader(input + ' ');
        block3: while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case '(': 
                case '[': {
                    intervals.add(DynamicParser.parseInterval(type, reader, c == '('));
                    continue block3;
                }
            }
        }
        if (intervals.isEmpty()) {
            throw new IllegalArgumentException("No dynamic intervals could be parsed");
        }
        return intervals;
    }

    private static Interval parseInterval(AttributeType type, StringReader reader, boolean lopen) throws IOException, ParseException {
        int r;
        ArrayList<String> values = new ArrayList<String>();
        boolean ropen = true;
        block6: while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case ']': {
                    ropen = false;
                }
                case ')': {
                    return DynamicParser.buildInterval(type, values, lopen, ropen);
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    values.add(DynamicParser.parseLiteral(reader, c));
                    continue block6;
                }
            }
            reader.skip(-1L);
            values.add(DynamicParser.parseValue(reader));
        }
        return DynamicParser.buildInterval(type, values, lopen, ropen);
    }

    private static String parseLiteral(StringReader reader, char quote) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        boolean escapeEnabled = false;
        block3: while ((r = reader.read()) != -1) {
            char c = (char)r;
            if (c == quote) {
                if (escapeEnabled) {
                    sb.append(quote);
                    escapeEnabled = false;
                    continue;
                }
                return sb.toString();
            }
            switch (c) {
                case '\\': {
                    if (escapeEnabled) {
                        sb.append('\\');
                        escapeEnabled = false;
                        continue block3;
                    }
                    escapeEnabled = true;
                    continue block3;
                }
            }
            if (escapeEnabled) {
                escapeEnabled = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String parseValue(StringReader reader) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case ')': 
                case ']': {
                    reader.skip(-1L);
                }
                case ',': {
                    return sb.toString().trim();
                }
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    private static Interval buildInterval(AttributeType type, ArrayList<String> values, boolean lopen, boolean ropen) throws ParseException {
        Object value;
        if (values.size() == 2) {
            value = null;
        } else if (values.size() == 3) {
            switch (type) {
                case DYNAMIC_BYTE: {
                    value = new Byte(AttributeType.removeDecimalDigitsFromString(values.get(2)));
                    break;
                }
                case DYNAMIC_SHORT: {
                    value = new Short(AttributeType.removeDecimalDigitsFromString(values.get(2)));
                    break;
                }
                case DYNAMIC_INT: {
                    value = new Integer(AttributeType.removeDecimalDigitsFromString(values.get(2)));
                    break;
                }
                case DYNAMIC_LONG: {
                    value = new Long(AttributeType.removeDecimalDigitsFromString(values.get(2)));
                    break;
                }
                case DYNAMIC_FLOAT: {
                    value = new Float(DynamicParser.infinityIgnoreCase(values.get(2)));
                    break;
                }
                case DYNAMIC_DOUBLE: {
                    value = new Double(DynamicParser.infinityIgnoreCase(values.get(2)));
                    break;
                }
                case DYNAMIC_BOOLEAN: {
                    value = Boolean.valueOf(values.get(2));
                    break;
                }
                case DYNAMIC_CHAR: {
                    value = new Character(values.get(2).charAt(0));
                    break;
                }
                case DYNAMIC_STRING: {
                    value = values.get(2);
                    break;
                }
                case DYNAMIC_BIGINTEGER: {
                    value = new BigInteger(AttributeType.removeDecimalDigitsFromString(values.get(2)));
                    break;
                }
                case DYNAMIC_BIGDECIMAL: {
                    value = new BigDecimal(values.get(2));
                    break;
                }
                default: {
                    value = null;
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Unrecognized type of interval = " + values);
        }
        double low = DynamicParser.parseTime(values.get(0));
        double high = DynamicParser.parseTime(values.get(1));
        return new Interval<Object>(low, high, lopen, ropen, value);
    }

    public static double getDoubleFromXMLDateString(String str) throws ParseException {
        try {
            return dateFactory.newXMLGregorianCalendar(str.length() > 23 ? str.substring(0, 23) : str).toGregorianCalendar().getTimeInMillis();
        }
        catch (IllegalArgumentException ex) {
            Date date = dateFormat.parse(str);
            return date.getTime();
        }
    }

    public static double parseTime(String time) throws ParseException {
        double value;
        try {
            value = Double.parseDouble(DynamicParser.infinityIgnoreCase(time));
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("NaN is not allowed as an interval bound");
            }
        }
        catch (Exception ex) {
            value = DynamicParser.getDoubleFromXMLDateString(time);
        }
        return value;
    }

    private static String infinityIgnoreCase(String value) {
        if (value.equalsIgnoreCase("Infinity")) {
            return "Infinity";
        }
        if (value.equalsIgnoreCase("-Infinity")) {
            return "-Infinity";
        }
        return value;
    }

    static {
        try {
            dateFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

