/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;

public final class DynamicShort
extends DynamicType<Short> {
    public DynamicShort() {
    }

    public DynamicShort(Interval<Short> in) {
        super(in);
    }

    public DynamicShort(List<Interval<Short>> in) {
        super(in);
    }

    public DynamicShort(DynamicShort source) {
        super(source);
    }

    public DynamicShort(DynamicShort source, Interval<Short> in) {
        super(source, in);
    }

    public DynamicShort(DynamicShort source, Interval<Short> in, Interval<Short> out) {
        super(source, in, out);
    }

    public DynamicShort(DynamicShort source, List<Interval<Short>> in) {
        super(source, in);
    }

    public DynamicShort(DynamicShort source, List<Interval<Short>> in, List<Interval<Short>> out) {
        super(source, in, out);
    }

    @Override
    public Short getValue(Interval interval, Estimator estimator) {
        List values = this.getValues(interval);
        if (values.isEmpty()) {
            return null;
        }
        switch (estimator) {
            case AVERAGE: {
                if (values.size() == 1) {
                    return (Short)values.get(0);
                }
                BigInteger total = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    total = total.add(BigInteger.valueOf(((Short)values.get(i)).shortValue()));
                }
                return total.divide(BigInteger.valueOf(values.size())).shortValue();
            }
            case MEDIAN: {
                if (values.size() % 2 == 1) {
                    return (Short)values.get(values.size() / 2);
                }
                BigInteger bi = BigInteger.valueOf(((Short)values.get(values.size() / 2 - 1)).shortValue());
                bi = bi.add(BigInteger.valueOf(((Short)values.get(values.size() / 2)).shortValue()));
                return bi.divide(BigInteger.valueOf(2L)).shortValue();
            }
            case MODE: {
                Hashtable<Integer, Integer> map = new Hashtable<Integer, Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    int prev = 0;
                    if (map.containsKey(((Short)values.get(i)).hashCode())) {
                        prev = (Integer)map.get(((Short)values.get(i)).hashCode());
                    }
                    map.put(((Short)values.get(i)).hashCode(), prev + 1);
                }
                int max = (Integer)map.get(((Short)values.get(0)).hashCode());
                int index = 0;
                for (int i = 1; i < values.size(); ++i) {
                    if (max >= (Integer)map.get(((Short)values.get(i)).hashCode())) continue;
                    max = (Integer)map.get(((Short)values.get(i)).hashCode());
                    index = i;
                }
                return (Short)values.get(index);
            }
            case SUM: {
                BigInteger sum = BigInteger.valueOf(0L);
                for (int i = 0; i < values.size(); ++i) {
                    sum = sum.add(BigInteger.valueOf(((Short)values.get(i)).shortValue()));
                }
                return sum.shortValue();
            }
            case MIN: {
                BigInteger minimum = BigInteger.valueOf(((Short)values.get(0)).shortValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (minimum.compareTo(BigInteger.valueOf(((Short)values.get(i)).shortValue())) <= 0) continue;
                    minimum = BigInteger.valueOf(((Short)values.get(i)).shortValue());
                }
                return minimum.shortValue();
            }
            case MAX: {
                BigInteger maximum = BigInteger.valueOf(((Short)values.get(0)).shortValue());
                for (int i = 1; i < values.size(); ++i) {
                    if (maximum.compareTo(BigInteger.valueOf(((Short)values.get(i)).shortValue())) >= 0) continue;
                    maximum = BigInteger.valueOf(((Short)values.get(i)).shortValue());
                }
                return maximum.shortValue();
            }
            case FIRST: {
                return (Short)values.get(0);
            }
            case LAST: {
                return (Short)values.get(values.size() - 1);
            }
        }
        throw new IllegalArgumentException("Unknown estimator.");
    }

    @Override
    public Class getUnderlyingType() {
        return Short.class;
    }
}

