/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gephi.data.attributes.type.Interval;

public final class IntervalTree<T> {
    private Node nil;
    private Node root;
    private static final Color RED = Color.RED;
    private static final Color BLACK = Color.BLACK;

    public IntervalTree() {
        this.nil.right = this.nil.p = (this.nil = new Node());
        this.nil.left = this.nil.p;
        this.root = this.nil;
    }

    public IntervalTree(IntervalTree intervalTree) {
        this();
        super.copy(intervalTree.root.left, intervalTree.nil);
    }

    private void copy(Node x, Node nil) {
        if (x != nil) {
            this.copy(x.left, nil);
            this.insert(x.i);
            this.copy(x.right, nil);
        }
    }

    private boolean compareLow(Interval a, Interval b) {
        return a.getLow() < b.getLow() || a.getLow() == b.getLow() && (!a.isLowExcluded() || b.isHighExcluded());
    }

    public void insert(Interval<T> interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        this.insert(new Node(interval));
    }

    private void insert(Node z) {
        z.left = z.right = this.nil;
        Node y = this.root;
        Node x = this.root.left;
        while (x != this.nil) {
            y = x;
            x = this.compareLow(z.i, y.i) ? x.left : x.right;
            y.max = Math.max(z.max, y.max);
            if (y.p != this.root) continue;
            this.root.max = y.max;
        }
        z.p = y;
        if (y == this.root) {
            this.root.max = z.max;
        }
        if (y == this.root || this.compareLow(z.i, y.i)) {
            y.left = z;
        } else {
            y.right = z;
        }
        this.insertFixup(z);
    }

    private void insertFixup(Node z) {
        Node y = this.nil;
        z.color = RED;
        while (z.p.color == RED) {
            if (z.p == z.p.p.left) {
                y = z.p.p.right;
                if (y.color == RED) {
                    z.p.color = BLACK;
                    y.color = BLACK;
                    z.p.p.color = RED;
                    z = z.p.p;
                    continue;
                }
                if (z == z.p.right) {
                    z = z.p;
                    this.leftRotate(z);
                }
                z.p.color = BLACK;
                z.p.p.color = RED;
                this.rightRotate(z.p.p);
                continue;
            }
            y = z.p.p.left;
            if (y.color == RED) {
                z.p.color = BLACK;
                y.color = BLACK;
                z.p.p.color = RED;
                z = z.p.p;
                continue;
            }
            if (z == z.p.left) {
                z = z.p;
                this.rightRotate(z);
            }
            z.p.color = BLACK;
            z.p.p.color = RED;
            this.leftRotate(z.p.p);
        }
        this.root.left.color = BLACK;
    }

    public void delete(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        for (Node n : this.searchNodes(interval)) {
            this.delete(n);
        }
    }

    private void delete(Node z) {
        z.max = Double.NEGATIVE_INFINITY;
        Node i = z.p;
        while (i != this.root) {
            i.max = Math.max(i.left.max, i.right.max);
            if (i.p == this.root) {
                this.root.max = i.max;
            }
            i = i.p;
        }
        Node y = z.left == this.nil || z.right == this.nil ? z : this.succesor(z);
        Node x = y.left == this.nil ? y.right : y.left;
        x.p = y.p;
        if (this.root == x.p) {
            this.root.left = x;
        } else if (y == y.p.left) {
            y.p.left = x;
        } else {
            y.p.right = x;
        }
        if (y != z) {
            if (y.color == BLACK) {
                this.deleteFixup(x);
            }
            y.left = z.left;
            y.right = z.right;
            y.p = z.p;
            y.color = z.color;
            z.left.p = z.right.p = y;
            if (z == z.p.left) {
                z.p.left = y;
            } else {
                z.p.right = y;
            }
        } else if (y.color == BLACK) {
            this.deleteFixup(x);
        }
    }

    private void deleteFixup(Node x) {
        while (x != this.root.left && x.color == BLACK) {
            Node w;
            if (x == x.p.left) {
                w = x.p.right;
                if (w.color == RED) {
                    w.color = BLACK;
                    x.p.color = RED;
                    this.leftRotate(x.p);
                    w = x.p.right;
                }
                if (w.left.color == BLACK && w.right.color == BLACK) {
                    w.color = RED;
                    x = x.p;
                    continue;
                }
                if (w.right.color == BLACK) {
                    w.left.color = BLACK;
                    w.color = RED;
                    this.rightRotate(w);
                    w = x.p.right;
                }
                w.color = x.p.color;
                x.p.color = BLACK;
                w.right.color = BLACK;
                this.leftRotate(x.p);
                x = this.root.left;
                continue;
            }
            w = x.p.left;
            if (w.color == RED) {
                w.color = BLACK;
                x.p.color = RED;
                this.rightRotate(x.p);
                w = x.p.left;
            }
            if (w.right.color == BLACK && w.left.color == BLACK) {
                w.color = RED;
                x = x.p;
                continue;
            }
            if (w.left.color == BLACK) {
                w.right.color = BLACK;
                w.color = RED;
                this.leftRotate(w);
                w = x.p.left;
            }
            w.color = x.p.color;
            x.p.color = BLACK;
            w.left.color = BLACK;
            this.rightRotate(x.p);
            x = this.root.left;
        }
        x.color = BLACK;
    }

    private void leftRotate(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.nil) {
            y.left.p = x;
        }
        y.p = x.p;
        if (x == x.p.left) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.left = x;
        x.p = y;
        if (y.p == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        x.max = Math.max(x.i.getHigh(), Math.max(x.left.max, x.right.max));
    }

    private void rightRotate(Node x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.nil) {
            y.right.p = x;
        }
        y.p = x.p;
        if (x == x.p.left) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.right = x;
        x.p = y;
        if (y.p == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        x.max = Math.max(x.i.getHigh(), Math.max(x.left.max, x.right.max));
    }

    private Node succesor(Node x) {
        Node y = x.right;
        if (y != this.nil) {
            while (y.left != this.nil) {
                y = y.left;
            }
            return y;
        }
        y = x.p;
        while (x == y.right) {
            x = y;
            y = y.p;
        }
        if (y == this.root) {
            return this.nil;
        }
        return y;
    }

    public Interval<T> minimum() {
        if (this.root.left == this.nil) {
            return null;
        }
        return this.treeMinimum((Node)this.root.left).i;
    }

    private Node treeMinimum(Node x) {
        while (x.left != this.nil) {
            x = x.left;
        }
        return x;
    }

    public Interval<T> maximum() {
        if (this.root.left == this.nil) {
            return null;
        }
        return this.treeMaximum((Node)this.root.left).i;
    }

    private Node treeMaximum(Node x) {
        while (x.right != this.nil) {
            x = x.right;
        }
        return x;
    }

    public double getLow() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.minimum().getLow();
    }

    public double getHigh() {
        if (this.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.root.left.max;
    }

    public boolean isLowExcluded() {
        if (this.isEmpty()) {
            return true;
        }
        return this.minimum().isLowExcluded();
    }

    public boolean isHighExcluded() {
        if (this.isEmpty()) {
            return true;
        }
        return this.maximum().isHighExcluded();
    }

    public boolean isEmpty() {
        return this.root.left == this.nil;
    }

    public List<Interval<T>> getIntervals() {
        ArrayList<Interval<T>> list = new ArrayList<Interval<T>>();
        this.inorderTreeWalk(this.root.left, list);
        return list;
    }

    public List<Interval<T>> search(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        ArrayList<Interval<T>> overlaps = new ArrayList<Interval<T>>();
        for (Node n : this.searchNodes(interval)) {
            overlaps.add(n.i);
        }
        return overlaps;
    }

    public List<Interval<T>> search(double low, double high) {
        if (low > high) {
            throw new IllegalArgumentException("The left endpoint of the interval must be less than the right endpoint.");
        }
        ArrayList<Interval<T>> overlaps = new ArrayList<Interval<T>>();
        for (Node n : this.searchNodes(new Interval(low, high))) {
            overlaps.add(n.i);
        }
        return overlaps;
    }

    private List<Node> searchNodes(Interval interval) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.searchNodes(this.root.left, interval, result);
        return result;
    }

    private void searchNodes(Node n, Interval interval, List<Node> result) {
        if (n == this.nil) {
            return;
        }
        if (interval.getLow() > n.max) {
            return;
        }
        if (n.left != this.nil) {
            this.searchNodes(n.left, interval, result);
        }
        if (n.i.compareTo(interval) == 0) {
            result.add(n);
        }
        if (interval.compareTo(n.i) < 0) {
            return;
        }
        if (n.right != this.nil) {
            this.searchNodes(n.right, interval, result);
        }
    }

    public boolean overlapsWith(Interval interval) {
        return this.overlapsWith(this.root.left, interval);
    }

    private boolean overlapsWith(Node n, Interval interval) {
        if (n == this.nil) {
            return false;
        }
        if (interval.getLow() > n.max) {
            return false;
        }
        if (n.left != this.nil && this.overlapsWith(n.left, interval)) {
            return true;
        }
        if (n.i.compareTo(interval) == 0) {
            return true;
        }
        if (interval.compareTo(n.i) < 0) {
            return false;
        }
        return n.right != this.nil && this.overlapsWith(n.right, interval);
    }

    private void inorderTreeWalk(Node x, List<Interval<T>> list) {
        if (x != this.nil) {
            this.inorderTreeWalk(x.left, list);
            list.add(x.i);
            this.inorderTreeWalk(x.right, list);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ArrayList<Interval<T>> thisIntervals = new ArrayList<Interval<T>>();
            ArrayList<Interval<T>> objIntervals = new ArrayList<Interval<T>>();
            this.inorderTreeWalk(this.root.left, thisIntervals);
            ((IntervalTree)obj).inorderTreeWalk(((IntervalTree)obj).root.left, objIntervals);
            if (thisIntervals.size() == objIntervals.size()) {
                for (int i = 0; i < thisIntervals.size(); ++i) {
                    if (((Interval)thisIntervals.get(i)).equals(objIntervals.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        ArrayList<Interval<T>> list = new ArrayList<Interval<T>>();
        this.inorderTreeWalk(this.root.left, list);
        return Arrays.deepHashCode(list.toArray());
    }

    public String toString(boolean timesAsDoubles) {
        ArrayList<Interval<T>> list = new ArrayList<Interval<T>>();
        this.inorderTreeWalk(this.root.left, list);
        if (!list.isEmpty()) {
            StringBuilder sb = new StringBuilder("<");
            sb.append(((Interval)list.get(0)).toString(timesAsDoubles));
            for (int i = 1; i < list.size(); ++i) {
                sb.append("; ").append(((Interval)list.get(i)).toString(timesAsDoubles));
            }
            sb.append(">");
            return sb.toString();
        }
        return "<empty>";
    }

    public String toString() {
        return this.toString(true);
    }

    static /* synthetic */ Color access$000() {
        return BLACK;
    }

    private static enum Color {
        RED,
        BLACK;

    }

    private class Node {
        public Interval<T> i;
        public double max;
        public Color color = IntervalTree.access$000();
        public Node left;
        public Node right;
        public Node p;

        public Node() {
        }

        public Node(Interval<T> i) {
            this();
            this.i = i;
            this.max = i.getHigh();
        }
    }
}

