/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.properties;

import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeType;

public enum PropertiesColumn {
    NODE_ID(0, "id", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    NODE_LABEL(1, "label", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    EDGE_ID(0, "id", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    EDGE_LABEL(1, "label", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    EDGE_WEIGHT(2, "weight", AttributeType.FLOAT, AttributeOrigin.PROPERTY, Float.valueOf(1.0f)),
    GRAPH_NAME(0, "name", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    GRAPH_DESCRIPTION(0, "description", AttributeType.STRING, AttributeOrigin.PROPERTY, null),
    NEO4J_RELATIONSHIP_TYPE(3, "neo4j_rt", AttributeType.STRING, AttributeOrigin.DELEGATE, null){

        @Override
        public String getTitle() {
            return "Neo4j Relationship Type";
        }
    };

    private final int index;
    private final String id;
    private final AttributeType type;
    private final AttributeOrigin origin;
    private final Object defaultValue;

    private PropertiesColumn(int index, String id, AttributeType attributeType, AttributeOrigin origin, Object defaultValue) {
        this.index = index;
        this.id = id;
        this.type = attributeType;
        this.origin = origin;
        this.defaultValue = defaultValue;
    }

    public int getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return Character.toUpperCase(this.id.charAt(0)) + this.id.substring(1, this.id.length());
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public AttributeType getType() {
        return this.type;
    }

    public AttributeOrigin getOrigin() {
        return this.origin;
    }
}

