/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.type.BooleanList;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.NumberList;
import org.gephi.data.attributes.type.StringList;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.utils.StatisticsUtils;
import org.openide.util.Lookup;

public class AttributeColumnsControllerImpl
implements AttributeColumnsController {
    @Override
    public boolean setAttributeValue(Object value, Attributes row, AttributeColumn column) {
        AttributeType targetType = column.getType();
        if (value != null && !value.getClass().equals(targetType.getType())) {
            try {
                value = targetType.parse(value.toString());
            }
            catch (Exception ex) {
                value = null;
            }
        }
        if (value == null && !this.canClearColumnData(column)) {
            return false;
        }
        row.setValue(column.getIndex(), value);
        return true;
    }

    @Override
    public AttributeColumn addAttributeColumn(AttributeTable table, String title, AttributeType type) {
        if (title == null || title.isEmpty()) {
            return null;
        }
        if (table.hasColumn(title)) {
            return null;
        }
        if (type == AttributeType.TIME_INTERVAL && table.getColumn("time_interval") == null) {
            return table.addColumn("time_interval", title, type, AttributeOrigin.PROPERTY, null);
        }
        return table.addColumn(title, title, type, AttributeOrigin.DATA, null);
    }

    @Override
    public void deleteAttributeColumn(AttributeTable table, AttributeColumn column) {
        if (this.canDeleteColumn(column)) {
            table.removeColumn(column);
        }
    }

    @Override
    public AttributeColumn convertAttributeColumnToDynamic(AttributeTable table, AttributeColumn column, double low, double high, boolean lopen, boolean ropen) {
        return this.convertColumnToDynamic(table, column, low, high, lopen, ropen, null);
    }

    @Override
    public AttributeColumn convertAttributeColumnToNewDynamicColumn(AttributeTable table, AttributeColumn column, double low, double high, boolean lopen, boolean ropen, String newColumnTitle) {
        return this.convertColumnToDynamic(table, column, low, high, lopen, ropen, newColumnTitle);
    }

    private AttributeColumn convertColumnToDynamic(AttributeTable table, AttributeColumn column, double low, double high, boolean lopen, boolean ropen, String newColumnTitle) {
        AttributeType oldType = column.getType();
        AttributeType newType = TypeConvertor.getDynamicType(oldType);
        if (newColumnTitle != null && newColumnTitle.equals(column.getTitle())) {
            throw new IllegalArgumentException("Column titles can't be equal");
        }
        int oldColumnIndex = column.getIndex();
        Attributes[] rows = this.getTableAttributeRows(table);
        Object[] oldValues = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            oldValues[i] = rows[i].getValue(oldColumnIndex);
        }
        AttributeColumn newColumn = newColumnTitle == null ? table.replaceColumn(column, column.getId(), column.getTitle(), newType, column.getOrigin(), null) : table.addColumn(newColumnTitle, newColumnTitle, newType, column.getOrigin(), null);
        int newColumnIndex = newColumn.getIndex();
        for (int i = 0; i < rows.length; ++i) {
            DynamicType value;
            if (oldValues[i] != null) {
                Interval<Object> interval = new Interval<Object>(low, high, lopen, ropen, oldValues[i]);
                value = newType.createDynamicObject(Arrays.asList(interval));
            } else {
                value = null;
            }
            rows[i].setValue(newColumnIndex, value);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn duplicateColumn(AttributeTable table, AttributeColumn column, String title, AttributeType type) {
        AttributeColumn newColumn = this.addAttributeColumn(table, title, type);
        if (newColumn == null) {
            return null;
        }
        this.copyColumnDataToOtherColumn(table, column, newColumn);
        return newColumn;
    }

    @Override
    public void copyColumnDataToOtherColumn(AttributeTable table, AttributeColumn sourceColumn, AttributeColumn targetColumn) {
        if (sourceColumn == targetColumn) {
            throw new IllegalArgumentException("Source and target columns can't be equal");
        }
        int sourceColumnIndex = sourceColumn.getIndex();
        int targetColumnIndex = targetColumn.getIndex();
        AttributeType targetType = targetColumn.getType();
        if (targetType != sourceColumn.getType()) {
            for (Attributes row : this.getTableAttributeRows(table)) {
                Object value = row.getValue(sourceColumnIndex);
                this.setAttributeValue(value, row, targetColumn);
            }
        } else {
            for (Attributes row : this.getTableAttributeRows(table)) {
                row.setValue(targetColumnIndex, row.getValue(sourceColumnIndex));
            }
        }
    }

    @Override
    public void fillColumnWithValue(AttributeTable table, AttributeColumn column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Attributes row : this.getTableAttributeRows(table)) {
                this.setAttributeValue(value, row, column);
            }
        }
    }

    @Override
    public void fillNodesColumnWithValue(Node[] nodes, AttributeColumn column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Node node : nodes) {
                this.setAttributeValue(value, node.getNodeData().getAttributes(), column);
            }
        }
    }

    @Override
    public void fillEdgesColumnWithValue(Edge[] edges, AttributeColumn column, String value) {
        if (this.canChangeColumnData(column)) {
            for (Edge edge : edges) {
                this.setAttributeValue(value, edge.getEdgeData().getAttributes(), column);
            }
        }
    }

    @Override
    public void clearColumnData(AttributeTable table, AttributeColumn column) {
        if (this.canClearColumnData(column)) {
            int columnIndex = column.getIndex();
            for (Attributes attributes : this.getTableAttributeRows(table)) {
                attributes.setValue(columnIndex, null);
            }
        }
    }

    @Override
    public Map<Object, Integer> calculateColumnValuesFrequencies(AttributeTable table, AttributeColumn column) {
        HashMap<Object, Integer> valuesFrequencies = new HashMap<Object, Integer>();
        for (Attributes row : this.getTableAttributeRows(table)) {
            Object value = row.getValue(column.getIndex());
            if (valuesFrequencies.containsKey(value)) {
                valuesFrequencies.put(value, new Integer((Integer)valuesFrequencies.get(value) + 1));
                continue;
            }
            valuesFrequencies.put(value, new Integer(1));
        }
        return valuesFrequencies;
    }

    @Override
    public AttributeColumn createBooleanMatchesColumn(AttributeTable table, AttributeColumn column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            AttributeColumn newColumn = this.addAttributeColumn(table, newColumnTitle, AttributeType.BOOLEAN);
            if (newColumn == null) {
                return null;
            }
            for (Attributes row : this.getTableAttributeRows(table)) {
                Object value = row.getValue(column.getIndex());
                Matcher matcher = value != null ? pattern.matcher(value.toString()) : pattern.matcher("");
                row.setValue(newColumn.getIndex(), (Object)matcher.matches());
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void negateBooleanColumn(AttributeTable table, AttributeColumn column) {
        AttributeUtils attributeUtils = AttributeUtils.getDefault();
        if (attributeUtils.isColumnOfType(column, AttributeType.BOOLEAN)) {
            this.negateColumnBooleanType(table, column);
        } else if (attributeUtils.isColumnOfType(column, AttributeType.LIST_BOOLEAN)) {
            this.negateColumnListBooleanType(table, column);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public AttributeColumn createFoundGroupsListColumn(AttributeTable table, AttributeColumn column, String newColumnTitle, Pattern pattern) {
        if (pattern != null) {
            AttributeColumn newColumn = this.addAttributeColumn(table, newColumnTitle, AttributeType.LIST_STRING);
            if (newColumn == null) {
                return null;
            }
            ArrayList<String> foundGroups = new ArrayList<String>();
            for (Attributes attributes : this.getTableAttributeRows(table)) {
                Object value = attributes.getValue(column.getIndex());
                Matcher matcher = value != null ? pattern.matcher(value.toString()) : pattern.matcher("");
                while (matcher.find()) {
                    foundGroups.add(matcher.group());
                }
                if (foundGroups.size() > 0) {
                    attributes.setValue(newColumn.getIndex(), (Object)new StringList(foundGroups.toArray(new String[0])));
                    foundGroups.clear();
                    continue;
                }
                attributes.setValue(newColumn.getIndex(), null);
            }
            return newColumn;
        }
        return null;
    }

    @Override
    public void clearNodeData(Node node, AttributeColumn[] columnsToClear) {
        this.clearRowData(node.getNodeData().getAttributes(), columnsToClear);
    }

    @Override
    public void clearNodesData(Node[] nodes, AttributeColumn[] columnsToClear) {
        for (Node n : nodes) {
            this.clearNodeData(n, columnsToClear);
        }
    }

    @Override
    public void clearEdgeData(Edge edge, AttributeColumn[] columnsToClear) {
        this.clearRowData(edge.getEdgeData().getAttributes(), columnsToClear);
    }

    @Override
    public void clearEdgesData(Edge[] edges, AttributeColumn[] columnsToClear) {
        for (Edge e : edges) {
            this.clearEdgeData(e, columnsToClear);
        }
    }

    @Override
    public void clearRowData(Attributes row, AttributeColumn[] columnsToClear) {
        AttributeRow attributeRow = (AttributeRow)row;
        if (columnsToClear != null) {
            for (AttributeColumn column : columnsToClear) {
                if (!this.canClearColumnData(column)) continue;
                row.setValue(column.getIndex(), null);
            }
        } else {
            AttributeValue[] values = attributeRow.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (!this.canClearColumnData(values[i].getColumn())) continue;
                row.setValue(i, null);
            }
        }
    }

    @Override
    public void copyNodeDataToOtherNodes(Node node, Node[] otherNodes, AttributeColumn[] columnsToCopy) {
        Attributes row = node.getNodeData().getAttributes();
        Attributes[] otherRows = new Attributes[otherNodes.length];
        for (int i = 0; i < otherNodes.length; ++i) {
            otherRows[i] = otherNodes[i].getNodeData().getAttributes();
        }
        this.copyRowDataToOtherRows(row, otherRows, columnsToCopy);
    }

    @Override
    public void copyEdgeDataToOtherEdges(Edge edge, Edge[] otherEdges, AttributeColumn[] columnsToCopy) {
        Attributes row = edge.getEdgeData().getAttributes();
        Attributes[] otherRows = new Attributes[otherEdges.length];
        for (int i = 0; i < otherEdges.length; ++i) {
            otherRows[i] = otherEdges[i].getEdgeData().getAttributes();
        }
        this.copyRowDataToOtherRows(row, otherRows, columnsToCopy);
    }

    @Override
    public void copyRowDataToOtherRows(Attributes row, Attributes[] otherRows, AttributeColumn[] columnsToCopy) {
        AttributeRow attributeRow = (AttributeRow)row;
        if (columnsToCopy != null) {
            for (AttributeColumn column : columnsToCopy) {
                if (!this.canChangeColumnData(column)) continue;
                for (Attributes otherRow : otherRows) {
                    otherRow.setValue(column.getIndex(), row.getValue(column.getIndex()));
                }
            }
        } else {
            AttributeValue[] values = attributeRow.getValues();
            for (int i = 0; i < values.length; ++i) {
                AttributeColumn column = values[i].getColumn();
                if (!this.canChangeColumnData(column)) continue;
                for (Attributes otherRow : otherRows) {
                    otherRow.setValue(column.getIndex(), row.getValue(column.getIndex()));
                }
            }
        }
    }

    @Override
    public Attributes[] getTableAttributeRows(AttributeTable table) {
        Attributes[] attributes;
        if (this.isNodeTable(table)) {
            Node[] nodes = this.getNodesArray();
            attributes = new Attributes[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                attributes[i] = nodes[i].getNodeData().getAttributes();
            }
        } else {
            Edge[] edges = this.getEdgesArray();
            attributes = new Attributes[edges.length];
            for (int i = 0; i < edges.length; ++i) {
                attributes[i] = edges[i].getEdgeData().getAttributes();
            }
        }
        return attributes;
    }

    @Override
    public int getTableRowsCount(AttributeTable table) {
        if (this.isNodeTable(table)) {
            return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodesCount();
        }
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getEdgesCount();
    }

    @Override
    public boolean isNodeTable(AttributeTable table) {
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        return table == ac.getModel().getNodeTable();
    }

    @Override
    public boolean isEdgeTable(AttributeTable table) {
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        return table == ac.getModel().getEdgeTable();
    }

    @Override
    public boolean canDeleteColumn(AttributeColumn column) {
        return column.getOrigin() != AttributeOrigin.PROPERTY;
    }

    @Override
    public boolean canChangeColumnData(AttributeColumn column) {
        AttributeUtils au = (AttributeUtils)Lookup.getDefault().lookup(AttributeUtils.class);
        if (au.isNodeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.NODE_ID.getIndex();
        }
        if (au.isEdgeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.EDGE_ID.getIndex();
        }
        return this.canChangeGenericColumnData(column);
    }

    @Override
    public boolean canClearColumnData(AttributeColumn column) {
        AttributeUtils au = (AttributeUtils)Lookup.getDefault().lookup(AttributeUtils.class);
        if (au.isNodeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.NODE_ID.getIndex();
        }
        if (au.isEdgeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.EDGE_ID.getIndex() && column.getIndex() != PropertiesColumn.EDGE_WEIGHT.getIndex();
        }
        return this.canChangeGenericColumnData(column);
    }

    @Override
    public boolean canConvertColumnToDynamic(AttributeColumn column) {
        if (column.getType().isDynamicType()) {
            return false;
        }
        AttributeUtils au = (AttributeUtils)Lookup.getDefault().lookup(AttributeUtils.class);
        if (au.isNodeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.NODE_ID.getIndex() && column.getIndex() != PropertiesColumn.NODE_LABEL.getIndex();
        }
        if (au.isEdgeColumn(column)) {
            return this.canChangeGenericColumnData(column) && column.getIndex() != PropertiesColumn.EDGE_ID.getIndex() && column.getIndex() != PropertiesColumn.EDGE_LABEL.getIndex();
        }
        return true;
    }

    @Override
    public BigDecimal[] getNumberOrNumberListColumnStatistics(AttributeTable table, AttributeColumn column) {
        return StatisticsUtils.getAllStatistics(this.getColumnNumbers(table, column));
    }

    @Override
    public Number[] getColumnNumbers(AttributeTable table, AttributeColumn column) {
        return this.getRowsColumnNumbers(this.getTableAttributeRows(table), column);
    }

    @Override
    public Number[] getRowsColumnNumbers(Attributes[] rows, AttributeColumn column) {
        AttributeUtils attributeUtils = AttributeUtils.getDefault();
        if (!attributeUtils.isNumberOrNumberListColumn(column)) {
            throw new IllegalArgumentException("The column has to be a number or number list column");
        }
        ArrayList<Number> numbers = new ArrayList<Number>();
        int columnIndex = column.getIndex();
        if (attributeUtils.isNumberColumn(column)) {
            for (Attributes row : rows) {
                Number number = (Number)row.getValue(columnIndex);
                if (number == null) continue;
                numbers.add(number);
            }
        } else {
            for (Attributes row : rows) {
                numbers.addAll(this.getNumberListColumnNumbers(row, column));
            }
        }
        return numbers.toArray(new Number[0]);
    }

    @Override
    public Number[] getRowNumbers(Attributes row, AttributeColumn[] columns) {
        AttributeUtils attributeUtils = AttributeUtils.getDefault();
        this.checkColumnsAreNumberOrNumberList(columns);
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (AttributeColumn column : columns) {
            if (attributeUtils.isNumberColumn(column)) {
                Number number = (Number)row.getValue(column.getIndex());
                if (number == null) continue;
                numbers.add(number);
                continue;
            }
            if (attributeUtils.isNumberListColumn(column)) {
                numbers.addAll(this.getNumberListColumnNumbers(row, column));
                continue;
            }
            if (!attributeUtils.isDynamicNumberColumn(column)) continue;
            numbers.addAll(this.getDynamicNumberColumnNumbers(row, column));
        }
        return numbers.toArray(new Number[0]);
    }

    @Override
    public void importCSVToNodesTable(File file, Character separator, Charset charset, String[] columnNames, AttributeType[] columnTypes, boolean assignNewNodeIds) {
    }

    @Override
    public void importCSVToEdgesTable(File file, Character separator, Charset charset, String[] columnNames, AttributeType[] columnTypes, boolean createNewNodes) {
    }

    @Override
    public void mergeRowsValues(AttributeTable table, AttributeRowsMergeStrategy[] mergeStrategies, Attributes[] rows, Attributes selectedRow, Attributes resultRow) {
        AttributeColumn[] columns = table.getColumns();
        if (columns.length != mergeStrategies.length) {
            throw new IllegalArgumentException("The number of columns must be equal to the number of merge strategies provided");
        }
        if (selectedRow == null) {
            selectedRow = rows[0];
        }
        for (int i = 0; i < columns.length; ++i) {
            Object value;
            AttributeRowsMergeStrategy mergeStrategy = mergeStrategies[i];
            if (mergeStrategy != null) {
                mergeStrategy.setup(rows, selectedRow, columns[i]);
                if (mergeStrategy.canExecute()) {
                    mergeStrategy.execute();
                    value = mergeStrategy.getReducedValue();
                } else {
                    value = selectedRow.getValue(columns[i].getIndex());
                }
            } else {
                value = selectedRow.getValue(columns[i].getIndex());
            }
            this.setAttributeValue(value, resultRow, columns[i]);
        }
    }

    @Override
    public List<List<Node>> detectNodeDuplicatesByColumn(AttributeColumn column, boolean caseSensitive) {
        HashMap valuesMap = new HashMap();
        int columnIndex = column.getIndex();
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getGraph();
        for (Node node : graph.getNodes().toArray()) {
            Object value = node.getNodeData().getAttributes().getValue(columnIndex);
            if (value == null) continue;
            String strValue = value.toString();
            if (!caseSensitive) {
                strValue = strValue.toLowerCase();
            }
            if (valuesMap.containsKey(strValue)) {
                ((List)valuesMap.get(strValue)).add(node);
                continue;
            }
            ArrayList<Node> newGroup = new ArrayList<Node>();
            newGroup.add(node);
            valuesMap.put(strValue, newGroup);
        }
        ArrayList<List<Node>> groupsList = new ArrayList<List<Node>>();
        for (List group : valuesMap.values()) {
            if (group.size() <= 1) continue;
            groupsList.add(group);
        }
        return groupsList;
    }

    private Node[] getNodesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getHierarchicalGraph().getNodesTree().toArray();
    }

    private Edge[] getEdgesArray() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getHierarchicalGraph().getEdges().toArray();
    }

    private boolean canChangeGenericColumnData(AttributeColumn column) {
        return column.getOrigin() != AttributeOrigin.COMPUTED && column.getOrigin() != AttributeOrigin.DELEGATE;
    }

    private void negateColumnBooleanType(AttributeTable table, AttributeColumn column) {
        int columnIndex = column.getIndex();
        for (Attributes row : this.getTableAttributeRows(table)) {
            Object value = row.getValue(columnIndex);
            if (value == null) continue;
            Boolean newValue = (Boolean)value == false;
            row.setValue(columnIndex, (Object)newValue);
        }
    }

    private void negateColumnListBooleanType(AttributeTable table, AttributeColumn column) {
        int columnIndex = column.getIndex();
        for (Attributes row : this.getTableAttributeRows(table)) {
            Object value = row.getValue(columnIndex);
            if (value == null) continue;
            BooleanList list = (BooleanList)value;
            Boolean[] newValues = new Boolean[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                newValues[i] = (Boolean)list.getItem(i) == false;
            }
            row.setValue(columnIndex, (Object)new BooleanList(newValues));
        }
    }

    private ArrayList<Number> getNumberListColumnNumbers(Attributes row, AttributeColumn column) {
        if (!AttributeUtils.getDefault().isNumberListColumn(column)) {
            throw new IllegalArgumentException("Column must be a number list column");
        }
        ArrayList<Number> numbers = new ArrayList<Number>();
        NumberList list = (NumberList)row.getValue(column.getIndex());
        if (list == null) {
            return numbers;
        }
        for (int i = 0; i < list.size(); ++i) {
            Number n = (Number)list.getItem(i);
            if (n == null) continue;
            numbers.add(n);
        }
        return numbers;
    }

    private ArrayList<Number> getDynamicNumberColumnNumbers(Attributes row, AttributeColumn column) {
        if (!AttributeUtils.getDefault().isDynamicNumberColumn(column)) {
            throw new IllegalArgumentException("Column must be a dynamic number column");
        }
        ArrayList<Number> numbers = new ArrayList<Number>();
        DynamicType dynamicList = (DynamicType)row.getValue(column.getIndex());
        if (dynamicList == null) {
            return numbers;
        }
        Number[] dynamicNumbers = dynamicList.getValues().toArray(new Number[0]);
        for (int i = 0; i < dynamicNumbers.length; ++i) {
            Number n = dynamicNumbers[i];
            if (n == null) continue;
            numbers.add(n);
        }
        return numbers;
    }

    private void checkColumnsAreNumberOrNumberList(AttributeColumn[] columns) {
        if (columns == null || !AttributeUtils.getDefault().areAllNumberOrNumberListColumns(columns) && !AttributeUtils.getDefault().areAllDynamicNumberColumns(columns)) {
            throw new IllegalArgumentException("All columns have to be number or number list columns and can't be null");
        }
    }
}

