/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Attributes;
import org.gephi.utils.StatisticsUtils;
import org.openide.util.Lookup;

public class AttributeColumnsMergeStrategiesControllerImpl
implements AttributeColumnsMergeStrategiesController {
    @Override
    public AttributeColumn joinWithSeparatorMerge(AttributeTable table, AttributeColumn[] columnsToMerge, AttributeType newColumnType, String newColumnTitle, String separator) {
        if (table == null || columnsToMerge == null) {
            throw new IllegalArgumentException("Table or columns can't be null");
        }
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, newColumnType != null ? newColumnType : AttributeType.STRING);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        if (separator == null) {
            separator = "";
        }
        int columnsCount = columnsToMerge.length;
        for (Attributes row : ac.getTableAttributeRows(table)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columnsCount; ++i) {
                Object value = row.getValue(columnsToMerge[i].getIndex());
                if (value == null) continue;
                sb.append(value.toString());
                if (i >= columnsCount - 1) continue;
                sb.append(separator);
            }
            row.setValue(newColumnIndex, (Object)sb.toString());
        }
        return newColumn;
    }

    @Override
    public AttributeColumn booleanLogicOperationsMerge(AttributeTable table, AttributeColumn[] columnsToMerge, AttributeColumnsMergeStrategiesController.BooleanOperations[] booleanOperations, String newColumnTitle) {
        AttributeUtils attributeUtils = AttributeUtils.getDefault();
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        if (table == null || columnsToMerge == null || !attributeUtils.areAllColumnsOfType(columnsToMerge, AttributeType.BOOLEAN) || booleanOperations == null || booleanOperations.length != columnsToMerge.length - 1) {
            throw new IllegalArgumentException("All columns have to be boolean columns, table, columns or operations can't be null and operations length must be columns length -1");
        }
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BOOLEAN);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            Boolean value = (Boolean)row.getValue(columnsToMerge[0].getIndex());
            value = value != null ? value : false;
            block8: for (int i = 0; i < booleanOperations.length; ++i) {
                Boolean secondValue = (Boolean)row.getValue(columnsToMerge[i + 1].getIndex());
                secondValue = secondValue != null ? secondValue : false;
                switch (booleanOperations[i]) {
                    case AND: {
                        value = value != false && secondValue != false;
                        continue block8;
                    }
                    case OR: {
                        value = value != false || secondValue != false;
                        continue block8;
                    }
                    case XOR: {
                        value = value ^ secondValue;
                        continue block8;
                    }
                    case NAND: {
                        value = value == false || secondValue == false;
                        continue block8;
                    }
                    case NOR: {
                        value = value == false && secondValue == false;
                    }
                }
            }
            row.setValue(newColumnIndex, (Object)value);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn mergeNumericColumnsToTimeInterval(AttributeTable table, AttributeColumn startColumn, AttributeColumn endColumn, double defaultStart, double defaultEnd) {
        this.checkTableAndOneColumn(table, startColumn, endColumn);
        AttributeColumn timeIntervalColumn = this.getTimeIntervalColumn(table);
        int timeIntervalColumnIndex = timeIntervalColumn.getIndex();
        int startColumnIndex = startColumn != null ? startColumn.getIndex() : -1;
        int endColumnIndex = endColumn != null ? endColumn.getIndex() : -1;
        boolean isStartColumnNumeric = startColumn != null ? AttributeUtils.getDefault().isNumberColumn(startColumn) : false;
        boolean isEndColumnNumeric = endColumn != null ? AttributeUtils.getDefault().isNumberColumn(endColumn) : false;
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        for (Attributes row : ac.getTableAttributeRows(table)) {
            Object value;
            double start = startColumnIndex != -1 ? ((value = row.getValue(startColumnIndex)) != null ? (isStartColumnNumeric ? ((Number)value).doubleValue() : this.parseDouble(value.toString(), defaultStart)) : defaultStart) : defaultStart;
            double end = endColumnIndex != -1 ? ((value = row.getValue(endColumnIndex)) != null ? (isEndColumnNumeric ? ((Number)value).doubleValue() : this.parseDouble(value.toString(), defaultEnd)) : defaultEnd) : defaultEnd;
            if (!Double.isInfinite(start) && !Double.isInfinite(end) && start > end) {
                if (startColumnIndex == -1) {
                    start = Double.NEGATIVE_INFINITY;
                } else if (endColumnIndex == -1) {
                    end = Double.POSITIVE_INFINITY;
                } else {
                    start = Double.NEGATIVE_INFINITY;
                    end = Double.POSITIVE_INFINITY;
                }
            }
            TimeInterval timeInterval = new TimeInterval(start, end);
            row.setValue(timeIntervalColumnIndex, (Object)timeInterval);
        }
        ((DynamicController)Lookup.getDefault().lookup(DynamicController.class)).setTimeFormat(DynamicModel.TimeFormat.DOUBLE);
        return timeIntervalColumn;
    }

    @Override
    public AttributeColumn mergeDateColumnsToTimeInterval(AttributeTable table, AttributeColumn startColumn, AttributeColumn endColumn, SimpleDateFormat dateFormat, String defaultStartDate, String defaultEndDate) {
        this.checkTableAndOneColumn(table, startColumn, endColumn);
        if (dateFormat == null) {
            throw new IllegalArgumentException("Date format can't be null can't be null");
        }
        AttributeColumn timeIntervalColumn = this.getTimeIntervalColumn(table);
        int timeIntervalColumnIndex = timeIntervalColumn.getIndex();
        int startColumnIndex = startColumn != null ? startColumn.getIndex() : -1;
        int endColumnIndex = endColumn != null ? endColumn.getIndex() : -1;
        double defaultStart = this.parseDateToDouble(dateFormat, defaultStartDate, Double.NEGATIVE_INFINITY);
        double defaultEnd = this.parseDateToDouble(dateFormat, defaultEndDate, Double.POSITIVE_INFINITY);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        for (Attributes row : ac.getTableAttributeRows(table)) {
            Object value;
            double start = startColumnIndex != -1 ? this.parseDateToDouble(dateFormat, (value = row.getValue(startColumnIndex)) != null ? value.toString() : null, defaultStart) : defaultStart;
            double end = endColumnIndex != -1 ? this.parseDateToDouble(dateFormat, (value = row.getValue(endColumnIndex)) != null ? value.toString() : null, defaultEnd) : defaultEnd;
            if (!Double.isInfinite(start) && !Double.isInfinite(end) && start > end) {
                if (startColumnIndex == -1) {
                    start = Double.NEGATIVE_INFINITY;
                } else if (endColumnIndex == -1) {
                    end = Double.POSITIVE_INFINITY;
                } else {
                    start = Double.NEGATIVE_INFINITY;
                    end = Double.POSITIVE_INFINITY;
                }
            }
            TimeInterval timeInterval = new TimeInterval(start, end);
            row.setValue(timeIntervalColumnIndex, (Object)timeInterval);
        }
        ((DynamicController)Lookup.getDefault().lookup(DynamicController.class)).setTimeFormat(DynamicModel.TimeFormat.DATE);
        return timeIntervalColumn;
    }

    @Override
    public AttributeColumn averageNumberMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal average = StatisticsUtils.average(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)average);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn firstQuartileNumberMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal Q1 = StatisticsUtils.quartile1(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)Q1);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn medianNumberMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal median = StatisticsUtils.median(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)median);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn thirdQuartileNumberMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal Q3 = StatisticsUtils.quartile3(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)Q3);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn interQuartileRangeNumberMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            Number[] rowNumbers = ac.getRowNumbers(row, columnsToMerge);
            BigDecimal Q3 = StatisticsUtils.quartile3(rowNumbers);
            BigDecimal Q1 = StatisticsUtils.quartile1(rowNumbers);
            BigDecimal IQR = Q3 != null && Q1 != null ? Q3.subtract(Q1) : null;
            row.setValue(newColumnIndex, (Object)IQR);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn sumNumbersMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal sum = StatisticsUtils.sum(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)sum);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn minValueNumbersMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal min = StatisticsUtils.minValue(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)min);
        }
        return newColumn;
    }

    @Override
    public AttributeColumn maxValueNumbersMerge(AttributeTable table, AttributeColumn[] columnsToMerge, String newColumnTitle) {
        this.checkTableAndColumnsAreNumberOrNumberList(table, columnsToMerge);
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        AttributeColumn newColumn = ac.addAttributeColumn(table, newColumnTitle, AttributeType.BIGDECIMAL);
        if (newColumn == null) {
            return null;
        }
        int newColumnIndex = newColumn.getIndex();
        for (Attributes row : ac.getTableAttributeRows(table)) {
            BigDecimal max = StatisticsUtils.maxValue(ac.getRowNumbers(row, columnsToMerge));
            row.setValue(newColumnIndex, (Object)max);
        }
        return newColumn;
    }

    private AttributeColumn getTimeIntervalColumn(AttributeTable table) {
        AttributeColumn column = table.getColumn("time_interval");
        if (column == null) {
            column = table.addColumn("time_interval", "Time Interval", AttributeType.TIME_INTERVAL, AttributeOrigin.PROPERTY, null);
        }
        return column;
    }

    private double parseDouble(String number, double defaultValue) {
        if (number == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private double parseDateToDouble(SimpleDateFormat dateFormat, String date, double defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        try {
            Date d = dateFormat.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return cal.getTimeInMillis();
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private void checkTableAndOneColumn(AttributeTable table, AttributeColumn startColumn, AttributeColumn endColumn) {
        if (table == null) {
            throw new IllegalArgumentException("Table can't be null");
        }
        if (startColumn == null && endColumn == null) {
            throw new IllegalArgumentException("Only one column could be null");
        }
    }

    private void checkTableAndColumnsAreNumberOrNumberList(AttributeTable table, AttributeColumn[] columns) {
        if (table == null) {
            throw new IllegalArgumentException("Table can't be null");
        }
        this.checkColumnsAreNumberOrNumberList(columns);
    }

    private void checkColumnsAreNumberOrNumberList(AttributeColumn[] columns) {
        if (columns == null || !AttributeUtils.getDefault().areAllNumberOrNumberListColumns(columns)) {
            throw new IllegalArgumentException("All columns have to be number or number list columns and can't be null");
        }
    }
}

