/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.UndirectedGraph;
import org.openide.util.Lookup;

public class GraphElementsControllerImpl
implements GraphElementsController {
    private static final float DEFAULT_NODE_SIZE = 10.0f;
    private static final float DEFAULT_EDGE_WEIGHT = 1.0f;

    @Override
    public Node createNode(String label) {
        Node newNode = this.buildNode(label);
        this.getGraph().addNode(newNode);
        return newNode;
    }

    @Override
    public Node createNode(String label, String id) {
        Graph graph = this.getGraph();
        if (graph.getNode(id) == null) {
            Node newNode = this.buildNode(label, id);
            graph.addNode(newNode);
            return newNode;
        }
        return null;
    }

    @Override
    public Node duplicateNode(Node node) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        Node copy = this.copyNodeRecursively(node, hg.getParent(node), hg);
        return copy;
    }

    @Override
    public void duplicateNodes(Node[] nodes) {
        for (Node n : nodes) {
            this.duplicateNode(n);
        }
    }

    @Override
    public Edge createEdge(Node source, Node target, boolean directed) {
        if (directed) {
            Edge newEdge = this.buildEdge(source, target, true);
            if (this.getDirectedGraph().addEdge(newEdge)) {
                return newEdge;
            }
            return null;
        }
        Edge newEdge = this.buildEdge(source, target, false);
        if (this.getUndirectedGraph().addEdge(newEdge)) {
            return newEdge;
        }
        return null;
    }

    @Override
    public Edge createEdge(String id, Node source, Node target, boolean directed) {
        if (source != target) {
            if (directed) {
                Edge newEdge = this.buildEdge(id, source, target, true);
                if (this.getDirectedGraph().addEdge(newEdge)) {
                    return newEdge;
                }
                return null;
            }
            Edge newEdge = this.buildEdge(id, source, target, false);
            if (this.getUndirectedGraph().addEdge(newEdge)) {
                return newEdge;
            }
            return null;
        }
        return null;
    }

    @Override
    public void createEdges(Node source, Node[] allNodes, boolean directed) {
        for (Node n : allNodes) {
            if (n == source) continue;
            this.createEdge(source, n, directed);
        }
    }

    @Override
    public void deleteNode(Node node) {
        this.removeNode(node, this.getGraph());
    }

    @Override
    public void deleteNodes(Node[] nodes) {
        Graph graph = this.getGraph();
        for (Node node : nodes) {
            this.removeNode(node, graph);
        }
    }

    @Override
    public void deleteEdge(Edge edge) {
        this.removeEdge(edge, this.getGraph());
    }

    @Override
    public void deleteEdges(Edge[] edges) {
        Graph graph = this.getGraph();
        for (Edge edge : edges) {
            this.removeEdge(edge, graph);
        }
    }

    @Override
    public void deleteEdgeWithNodes(Edge edge, boolean deleteSource, boolean deleteTarget) {
        if (deleteSource) {
            this.deleteNode(edge.getSource());
        }
        if (deleteTarget) {
            this.deleteNode(edge.getTarget());
        }
        this.removeEdge(edge, this.getGraph());
    }

    @Override
    public void deleteEdgesWithNodes(Edge[] edges, boolean deleteSource, boolean deleteTarget) {
        for (Edge edge : edges) {
            this.deleteEdgeWithNodes(edge, deleteSource, deleteTarget);
        }
    }

    @Override
    public boolean groupNodes(Node[] nodes) {
        throw new IllegalStateException();
    }

    @Override
    public boolean canGroupNodes(Node[] nodes) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        Node parent = hg.getParent(nodes[0]);
        for (Node n : nodes) {
            if (hg.getParent(n) == parent) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean ungroupNode(Node node) {
        if (this.canUngroupNode(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            hg.ungroupNodes(node);
            return true;
        }
        return false;
    }

    @Override
    public void ungroupNodes(Node[] nodes) {
        for (Node n : nodes) {
            this.ungroupNode(n);
        }
    }

    @Override
    public boolean ungroupNodeRecursively(Node node) {
        if (this.canUngroupNode(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            this.ungroupNodes(hg.getDescendant(node).toArray());
            this.ungroupNode(node);
            return true;
        }
        return false;
    }

    @Override
    public void ungroupNodesRecursively(Node[] nodes) {
        for (Node n : nodes) {
            this.ungroupNodeRecursively(n);
        }
    }

    @Override
    public boolean canUngroupNode(Node node) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        boolean canUngroup = this.getNodeChildrenCount(hg, node) > 0;
        return canUngroup;
    }

    @Override
    public Node mergeNodes(Node[] nodes, Node selectedNode, AttributeRowsMergeStrategy[] mergeStrategies, boolean deleteMergedNodes) {
        AttributeTable nodesTable = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel().getNodeTable();
        if (selectedNode == null) {
            selectedNode = nodes[0];
        }
        Node newNode = this.createNode("");
        NodeData newNodeData = newNode.getNodeData();
        NodeData selectedNodeData = selectedNode.getNodeData();
        newNodeData.setX(selectedNodeData.x());
        newNodeData.setY(selectedNodeData.y());
        newNodeData.setZ(selectedNodeData.z());
        newNodeData.setSize(selectedNodeData.getSize());
        newNodeData.setColor(selectedNodeData.r(), selectedNodeData.g(), selectedNodeData.b());
        newNodeData.setAlpha(selectedNodeData.alpha());
        Attributes[] rows = new Attributes[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            rows[i] = nodes[i].getAttributes();
        }
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ac.mergeRowsValues(nodesTable, mergeStrategies, rows, selectedNode.getAttributes(), newNode.getAttributes());
        HashSet<Node> nodesSet = new HashSet<Node>();
        nodesSet.addAll(Arrays.asList(nodes));
        for (Node node : nodes) {
            for (Edge edge : this.getNodeEdges(node)) {
                Edge newEdge = edge.getSource() == node ? (nodesSet.contains(edge.getTarget()) ? this.createEdge(newNode, newNode, edge.isDirected()) : this.createEdge(newNode, edge.getTarget(), edge.isDirected())) : (nodesSet.contains(edge.getSource()) ? this.createEdge(newNode, newNode, edge.isDirected()) : this.createEdge(edge.getSource(), newNode, edge.isDirected()));
                if (newEdge == null) continue;
                AttributeRow row = (AttributeRow)edge.getAttributes();
                for (int i = 0; i < row.countValues(); ++i) {
                    if (row.getAttributeValueAt(i).getColumn().getIndex() == PropertiesColumn.EDGE_ID.getIndex()) continue;
                    newEdge.getAttributes().setValue(i, row.getValue(i));
                }
            }
        }
        if (deleteMergedNodes) {
            this.deleteNodes(nodes);
        }
        return newNode;
    }

    @Override
    public boolean moveNodeToGroup(Node node, Node group) {
        if (this.canMoveNodeToGroup(node, group)) {
            this.getHierarchicalGraph().moveToGroup(node, group);
            return true;
        }
        return false;
    }

    @Override
    public void moveNodesToGroup(Node[] nodes, Node group) {
        for (Node n : nodes) {
            this.moveNodeToGroup(n, group);
        }
    }

    @Override
    public Node[] getAvailableGroupsToMoveNodes(Node[] nodes) {
        if (this.canGroupNodes(nodes)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            HashSet<Node> nodesSet = new HashSet<Node>();
            nodesSet.addAll(Arrays.asList(nodes));
            Node parent = hg.getParent(nodes[0]);
            Node[] possibleGroups = parent != null ? hg.getChildren(parent).toArray() : hg.getNodes(0).toArray();
            ArrayList<Node> availableGroups = new ArrayList<Node>();
            for (Node n : possibleGroups) {
                if (nodesSet.contains(n) || this.getNodeChildrenCount(hg, n) <= 0) continue;
                availableGroups.add(n);
            }
            return availableGroups.toArray(new Node[0]);
        }
        return null;
    }

    @Override
    public boolean canMoveNodeToGroup(Node node, Node group) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        return node != group && hg.getParent(node) == hg.getParent(group) && this.canUngroupNode(group);
    }

    @Override
    public boolean removeNodeFromGroup(Node node) {
        if (this.isNodeInGroup(node)) {
            HierarchicalGraph hg = this.getHierarchicalGraph();
            Node parent = hg.getParent(node);
            hg.readLock();
            int childrenCount = hg.getChildrenCount(parent);
            hg.readUnlock();
            if (childrenCount == 1) {
                hg.ungroupNodes(parent);
            } else {
                hg.removeFromGroup(node);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeNodesFromGroup(Node[] nodes) {
        for (Node n : nodes) {
            this.removeNodeFromGroup(n);
        }
    }

    @Override
    public boolean isNodeInGroup(Node node) {
        HierarchicalGraph hg = this.getHierarchicalGraph();
        return hg.getParent(node) != null;
    }

    @Override
    public void setNodeFixed(Node node, boolean fixed) {
        node.getNodeData().setFixed(fixed);
    }

    @Override
    public void setNodesFixed(Node[] nodes, boolean fixed) {
        for (Node n : nodes) {
            this.setNodeFixed(n, fixed);
        }
    }

    @Override
    public boolean isNodeFixed(Node node) {
        return node.getNodeData().isFixed();
    }

    @Override
    public Node[] getNodeNeighbours(Node node) {
        return this.getGraph().getNeighbors(node).toArray();
    }

    @Override
    public Edge[] getNodeEdges(Node node) {
        return this.getGraph().getEdges(node).toArray();
    }

    @Override
    public int getNodesCount() {
        Graph graph = this.getGraph();
        graph.readLock();
        int nodesCount = graph.getNodeCount();
        graph.readUnlock();
        return nodesCount;
    }

    @Override
    public int getEdgesCount() {
        Graph graph = this.getGraph();
        graph.readLock();
        int edgesCount = graph.getEdgeCount();
        graph.readUnlock();
        return edgesCount;
    }

    @Override
    public boolean isNodeInGraph(Node node) {
        return this.getGraph().contains(node);
    }

    @Override
    public boolean areNodesInGraph(Node[] nodes) {
        Graph graph = this.getGraph();
        for (Node n : nodes) {
            if (graph.contains(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEdgeInGraph(Edge edge) {
        return this.getGraph().contains(edge);
    }

    @Override
    public boolean areEdgesInGraph(Edge[] edges) {
        Graph graph = this.getGraph();
        for (Edge e : edges) {
            if (graph.contains(e)) continue;
            return false;
        }
        return true;
    }

    private Graph getGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getGraph();
    }

    private DirectedGraph getDirectedGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getDirectedGraph();
    }

    private UndirectedGraph getUndirectedGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getUndirectedGraph();
    }

    private HierarchicalGraph getHierarchicalGraph() {
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getHierarchicalGraph();
    }

    private Node buildNode(String label) {
        Node newNode = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newNode();
        newNode.getNodeData().setSize(10.0f);
        newNode.getNodeData().setLabel(label);
        return newNode;
    }

    private Node buildNode(String label, String id) {
        Node newNode = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newNode(id);
        newNode.getNodeData().setSize(10.0f);
        newNode.getNodeData().setLabel(label);
        return newNode;
    }

    private Edge buildEdge(Node source, Node target, boolean directed) {
        Edge newEdge = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newEdge(source, target, 1.0f, directed);
        return newEdge;
    }

    private Edge buildEdge(String id, Node source, Node target, boolean directed) {
        Edge newEdge = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().factory().newEdge(id, source, target, 1.0f, directed);
        return newEdge;
    }

    private Node copyNodeRecursively(Node node, Node parent, HierarchicalGraph hg) {
        NodeData nodeData = node.getNodeData();
        Node copy = this.buildNode(nodeData.getLabel());
        NodeData copyData = copy.getNodeData();
        copyData.setX(nodeData.x());
        copyData.setY(nodeData.y());
        copyData.setZ(nodeData.z());
        copyData.setSize(nodeData.getSize());
        copyData.setColor(nodeData.r(), nodeData.g(), nodeData.b());
        copyData.setAlpha(nodeData.alpha());
        AttributeRow row = (AttributeRow)nodeData.getAttributes();
        for (int i = 0; i < row.countValues(); ++i) {
            if (row.getAttributeValueAt(i).getColumn().getIndex() == PropertiesColumn.NODE_ID.getIndex()) continue;
            copyData.getAttributes().setValue(i, row.getValue(i));
        }
        if (parent != null) {
            hg.addNode(copy, parent);
        } else {
            hg.addNode(copy);
        }
        Node[] children = hg.getChildren(node).toArray();
        if (children != null) {
            for (Node child : children) {
                this.copyNodeRecursively(child, copy, hg);
            }
        }
        return copy;
    }

    private void removeNode(Node node, Graph graph) {
        graph.removeNode(node);
    }

    private void removeEdge(Edge edge, Graph graph) {
        graph.removeEdge(edge);
    }

    private int getNodeChildrenCount(HierarchicalGraph hg, Node n) {
        hg.readLock();
        int childrenCount = hg.getChildrenCount(n);
        hg.readUnlock();
        return childrenCount;
    }
}

