/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.util.Set;
import java.util.regex.Matcher;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.api.SearchReplaceController;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;

public class SearchReplaceControllerImpl
implements SearchReplaceController {
    @Override
    public SearchReplaceController.SearchResult findNext(SearchReplaceController.SearchOptions searchOptions) {
        int row = 0;
        int column = 0;
        if (searchOptions.getStartingRow() != null) {
            row = searchOptions.getStartingRow();
        }
        if (searchOptions.getStartingColumn() != null) {
            column = searchOptions.getStartingColumn();
        }
        SearchReplaceController.SearchResult result = null;
        if (searchOptions.isSearchNodes()) {
            result = this.findOnNodes(searchOptions, row, column);
            if (result == null && searchOptions.isLoopToBeginning()) {
                searchOptions.resetStatus();
                return this.findOnNodes(searchOptions, 0, 0);
            }
            return result;
        }
        result = this.findOnEdges(searchOptions, row, column);
        if (result == null && searchOptions.isLoopToBeginning()) {
            searchOptions.resetStatus();
            return this.findOnEdges(searchOptions, 0, 0);
        }
        return result;
    }

    @Override
    public SearchReplaceController.SearchResult findNext(SearchReplaceController.SearchResult result) {
        return this.findNext(result.getSearchOptions());
    }

    @Override
    public boolean canReplace(SearchReplaceController.SearchResult result) {
        AttributeColumn column;
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        if (result.getFoundNode() != null) {
            AttributeTable table = ac.getModel().getNodeTable();
            column = table.getColumn(result.getFoundColumnIndex());
        } else {
            AttributeTable table = ac.getModel().getEdgeTable();
            column = table.getColumn(result.getFoundColumnIndex());
        }
        return ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).canChangeColumnData(column);
    }

    @Override
    public SearchReplaceController.SearchResult replace(SearchReplaceController.SearchResult result, String replacement) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        if (!this.canReplace(result)) {
            return this.findNext(result);
        }
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        if (!result.getSearchOptions().isUseRegexReplaceMode()) {
            replacement = Matcher.quoteReplacement(replacement);
        }
        try {
            AttributeColumn column;
            Attributes attributes;
            if (result.getFoundNode() != null) {
                attributes = result.getFoundNode().getNodeData().getAttributes();
                column = ac.getModel().getNodeTable().getColumn(result.getFoundColumnIndex());
            } else {
                attributes = result.getFoundEdge().getEdgeData().getAttributes();
                column = ac.getModel().getEdgeTable().getColumn(result.getFoundColumnIndex());
            }
            Object value = attributes.getValue(result.getFoundColumnIndex());
            String str = value != null ? value.toString() : "";
            StringBuffer sb = new StringBuffer();
            Matcher matcher = result.getSearchOptions().getRegexPattern().matcher(str.substring(result.getStart()));
            if (matcher.find()) {
                matcher.appendReplacement(sb, replacement);
                int replaceLong = sb.length();
                matcher.appendTail(sb);
                str = str.substring(0, result.getStart()) + sb.toString();
                result.getSearchOptions().setRegionStart(result.getStart() + replaceLong);
                ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).setAttributeValue(str, attributes, column);
                return this.findNext(result);
            }
            return this.findNext(result);
        }
        catch (Exception ex) {
            if (ex instanceof IndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
            return this.findNext(result);
        }
    }

    @Override
    public int replaceAll(SearchReplaceController.SearchOptions searchOptions, String replacement) {
        int replacementsCount = 0;
        searchOptions.resetStatus();
        searchOptions.setLoopToBeginning(false);
        SearchReplaceController.SearchResult result = this.findNext(searchOptions);
        while (result != null) {
            if (this.canReplace(result)) {
                result = this.replace(result, replacement);
                ++replacementsCount;
                continue;
            }
            result = this.findNext(searchOptions);
        }
        searchOptions.setLoopToBeginning(true);
        return replacementsCount;
    }

    private SearchReplaceController.SearchResult findOnNodes(SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex) {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        SearchReplaceController.SearchResult result = null;
        Set<Integer> columnsToSearch = searchOptions.getColumnsToSearch();
        boolean searchAllColumns = columnsToSearch.isEmpty();
        Node[] nodes = searchOptions.getNodesToSearch();
        while (rowIndex < nodes.length) {
            if (gec.isNodeInGraph(nodes[rowIndex])) {
                AttributeRow row = (AttributeRow)nodes[rowIndex].getNodeData().getAttributes();
                while (columnIndex < row.countValues()) {
                    Object value;
                    if ((searchAllColumns || columnsToSearch.contains(columnIndex)) && (result = this.matchRegex(value = row.getValue(columnIndex), searchOptions, rowIndex, columnIndex)) != null) {
                        result.setFoundNode(nodes[rowIndex]);
                        return result;
                    }
                    searchOptions.setRegionStart(0);
                    ++columnIndex;
                }
                searchOptions.setRegionStart(0);
                columnIndex = 0;
            }
            ++rowIndex;
        }
        return result;
    }

    private SearchReplaceController.SearchResult findOnEdges(SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex) {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        SearchReplaceController.SearchResult result = null;
        Set<Integer> columnsToSearch = searchOptions.getColumnsToSearch();
        boolean searchAllColumns = columnsToSearch.isEmpty();
        Edge[] edges = searchOptions.getEdgesToSearch();
        while (rowIndex < edges.length) {
            if (gec.isEdgeInGraph(edges[rowIndex])) {
                AttributeRow row = (AttributeRow)edges[rowIndex].getEdgeData().getAttributes();
                while (columnIndex < row.countValues()) {
                    Object value;
                    if ((searchAllColumns || columnsToSearch.contains(columnIndex)) && (result = this.matchRegex(value = row.getValue(columnIndex), searchOptions, rowIndex, columnIndex)) != null) {
                        result.setFoundEdge(edges[rowIndex]);
                        return result;
                    }
                    searchOptions.setRegionStart(0);
                    ++columnIndex;
                }
                searchOptions.setRegionStart(0);
                columnIndex = 0;
            }
            ++rowIndex;
        }
        return result;
    }

    private SearchReplaceController.SearchResult matchRegex(Object value, SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex) {
        boolean found;
        String str = value != null ? value.toString() : "";
        Matcher matcher = searchOptions.getRegexPattern().matcher(str);
        if (str.isEmpty() ? searchOptions.getRegionStart() > 0 : searchOptions.getRegionStart() >= str.length()) {
            return null;
        }
        if (searchOptions.isOnlyMatchWholeAttributeValue()) {
            found = matcher.matches();
        } else {
            matcher.region(searchOptions.getRegionStart(), str.length());
            found = matcher.find();
        }
        if (found) {
            searchOptions.setStartingRow(rowIndex);
            searchOptions.setStartingColumn(columnIndex);
            int end = matcher.end();
            if (matcher.start() == end && !str.isEmpty()) {
                return null;
            }
            if (str.isEmpty()) {
                ++end;
            }
            searchOptions.setRegionStart(end);
            return new SearchReplaceController.SearchResult(searchOptions, null, null, rowIndex, columnIndex, matcher.start(), matcher.end());
        }
        return null;
    }
}

