/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeRowFactory;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphSettings;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalMixedGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.graph.dhns.DhnsGraphController;
import org.gephi.graph.dhns.core.DuplicateManager;
import org.gephi.graph.dhns.core.EventManager;
import org.gephi.graph.dhns.core.GraphFactoryImpl;
import org.gephi.graph.dhns.core.GraphStructure;
import org.gephi.graph.dhns.core.GraphVersion;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.IDGen;
import org.gephi.graph.dhns.core.SettingsManager;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.graph.HierarchicalDirectedGraphImpl;
import org.gephi.graph.dhns.graph.HierarchicalGraphImpl;
import org.gephi.graph.dhns.graph.HierarchicalMixedGraphImpl;
import org.gephi.graph.dhns.graph.HierarchicalUndirectedGraphImpl;
import org.gephi.graph.dhns.graph.iterators.EdgeIterableImpl;
import org.gephi.graph.dhns.graph.iterators.NodeIterableImpl;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dhns
implements GraphModel {
    private final Workspace workspace;
    private final DhnsGraphController controller;
    private GraphStructure graphStructure;
    private GraphVersion graphVersion;
    private final EventManager eventManager;
    private final SettingsManager settingsManager;
    private final GraphFactoryImpl factory;
    private final DuplicateManager duplicateManager;
    private boolean directed = false;
    private boolean undirected = false;
    private boolean mixed = false;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public Dhns(DhnsGraphController controller, Workspace workspace) {
        AttributeModel attributeModel;
        this.controller = controller;
        this.workspace = workspace;
        this.graphVersion = new GraphVersion();
        this.eventManager = new EventManager(this);
        this.settingsManager = new SettingsManager(this);
        this.duplicateManager = new DuplicateManager(this);
        this.eventManager.start();
        AttributeRowFactory attributeRowFactory = null;
        if (workspace != null && (attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel(workspace)) != null) {
            attributeRowFactory = attributeModel.rowFactory();
        }
        this.factory = new GraphFactoryImpl(controller.getIDGen(), attributeRowFactory);
        this.graphStructure = new GraphStructure(this);
        this.init();
    }

    public void init() {
    }

    public DhnsGraphController getController() {
        return this.controller;
    }

    public GraphStructure getGraphStructure() {
        return this.graphStructure;
    }

    public GraphVersion getGraphVersion() {
        return this.graphVersion;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public IDGen getIdGen() {
        return this.controller.getIDGen();
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public DuplicateManager getDuplicateManager() {
        return this.duplicateManager;
    }

    public NodeIterable newNodeIterable(AbstractNodeIterator iterator) {
        return new NodeIterableImpl(iterator, this.readWriteLock.readLock());
    }

    public EdgeIterable newEdgeIterable(AbstractEdgeIterator iterator) {
        return new EdgeIterableImpl(iterator, this.readWriteLock.readLock());
    }

    public NodeIterable newNodeIterable(AbstractNodeIterator iterator, Predicate<Node> predicate) {
        return new NodeIterableImpl(iterator, this.readWriteLock.readLock());
    }

    public EdgeIterable newEdgeIterable(AbstractEdgeIterator iterator, Predicate<AbstractEdge> predicate) {
        return new EdgeIterableImpl(iterator, this.readWriteLock.readLock(), predicate);
    }

    public void readLock() {
        this.readWriteLock.readLock().lock();
    }

    public void readUnlock() {
        this.readWriteLock.readLock().unlock();
    }

    public void readUnlockAll() {
        ReentrantReadWriteLock lock = this.readWriteLock;
        int nReadLocks = lock.getReadHoldCount();
        for (int n = 0; n < nReadLocks; ++n) {
            lock.readLock().unlock();
        }
    }

    public boolean conditionalWriteLock() {
        if (this.readWriteLock.getReadHoldCount() > 0) {
            throw new IllegalMonitorStateException("Impossible to acquire a write lock when currently holding a read lock. Use toArray() methods on NodeIterable and EdgeIterable to avoid holding a readLock.");
        }
        if (!this.readWriteLock.isWriteLockedByCurrentThread()) {
            this.readWriteLock.writeLock().lock();
            return true;
        }
        return false;
    }

    public void conditionalWriteUnlock(boolean locked) {
        if (locked) {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void writeLock() {
        if (this.readWriteLock.getReadHoldCount() > 0) {
            throw new IllegalMonitorStateException("Impossible to acquire a write lock when currently holding a read lock. Use toArray() methods on NodeIterable and EdgeIterable to avoid holding a readLock.");
        }
        this.readWriteLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.readWriteLock.writeLock().unlock();
    }

    public ReentrantReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void touchDirected() {
        if (this.undirected || this.mixed) {
            this.touchMixed();
        } else {
            this.directed = true;
        }
    }

    public void touchUndirected() {
        if (this.directed || this.mixed) {
            this.touchMixed();
        } else {
            this.undirected = true;
        }
    }

    public void touchMixed() {
        this.directed = false;
        this.undirected = false;
        this.mixed = true;
    }

    @Override
    public GraphFactoryImpl factory() {
        return this.factory;
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public boolean isMixed() {
        return this.mixed;
    }

    @Override
    public boolean isUndirected() {
        return this.undirected;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public void setUndirected(boolean undirected) {
        this.undirected = undirected;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    @Override
    public boolean isHierarchical() {
        return this.graphStructure.getMainView().getStructure().getTreeHeight() - 1 > 0;
    }

    @Override
    public void addGraphListener(GraphListener graphListener) {
        this.eventManager.addGraphListener(graphListener);
    }

    @Override
    public void removeGraphListener(GraphListener graphListener) {
        this.eventManager.removeGraphListener(graphListener);
    }

    @Override
    public Graph getGraph() {
        if (this.directed) {
            return this.getDirectedGraph();
        }
        if (this.undirected) {
            return this.getUndirectedGraph();
        }
        if (this.mixed) {
            return this.getMixedGraph();
        }
        return this.getDirectedGraph();
    }

    @Override
    public DirectedGraph getDirectedGraph() {
        return new HierarchicalDirectedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public UndirectedGraph getUndirectedGraph() {
        return new HierarchicalUndirectedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public MixedGraph getMixedGraph() {
        return new HierarchicalMixedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public HierarchicalGraph getHierarchicalGraph() {
        if (this.directed) {
            return this.getHierarchicalDirectedGraph();
        }
        if (this.undirected) {
            return this.getHierarchicalUndirectedGraph();
        }
        if (this.mixed) {
            return this.getHierarchicalMixedGraph();
        }
        return this.getHierarchicalDirectedGraph();
    }

    @Override
    public HierarchicalDirectedGraph getHierarchicalDirectedGraph() {
        return new HierarchicalDirectedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public HierarchicalMixedGraph getHierarchicalMixedGraph() {
        return new HierarchicalMixedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public HierarchicalUndirectedGraph getHierarchicalUndirectedGraph() {
        return new HierarchicalUndirectedGraphImpl(this, this.graphStructure.getMainView());
    }

    @Override
    public DirectedGraph getDirectedGraph(GraphView view) {
        return new HierarchicalDirectedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public Graph getGraph(GraphView view) {
        if (this.directed) {
            return this.getDirectedGraph(view);
        }
        if (this.undirected) {
            return this.getUndirectedGraph(view);
        }
        if (this.mixed) {
            return this.getMixedGraph(view);
        }
        return this.getDirectedGraph(view);
    }

    @Override
    public HierarchicalDirectedGraph getHierarchicalDirectedGraph(GraphView view) {
        return new HierarchicalDirectedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public HierarchicalGraph getHierarchicalGraph(GraphView view) {
        if (this.directed) {
            return this.getHierarchicalDirectedGraph(view);
        }
        if (this.undirected) {
            return this.getHierarchicalUndirectedGraph(view);
        }
        if (this.mixed) {
            return this.getHierarchicalMixedGraph(view);
        }
        return this.getHierarchicalDirectedGraph(view);
    }

    @Override
    public HierarchicalMixedGraph getHierarchicalMixedGraph(GraphView view) {
        return new HierarchicalMixedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public HierarchicalUndirectedGraph getHierarchicalUndirectedGraph(GraphView view) {
        return new HierarchicalUndirectedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public MixedGraph getMixedGraph(GraphView view) {
        return new HierarchicalMixedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public UndirectedGraph getUndirectedGraph(GraphView view) {
        return new HierarchicalUndirectedGraphImpl(this, (GraphViewImpl)view);
    }

    @Override
    public Graph getGraphVisible() {
        if (this.directed) {
            return this.getDirectedGraph(this.graphStructure.getVisibleView());
        }
        if (this.undirected) {
            return this.getUndirectedGraph(this.graphStructure.getVisibleView());
        }
        if (this.mixed) {
            return this.getMixedGraph(this.graphStructure.getVisibleView());
        }
        return this.getDirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public DirectedGraph getDirectedGraphVisible() {
        return this.getDirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public UndirectedGraph getUndirectedGraphVisible() {
        return this.getUndirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public MixedGraph getMixedGraphVisible() {
        return this.getMixedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public HierarchicalGraph getHierarchicalGraphVisible() {
        if (this.directed) {
            return this.getHierarchicalDirectedGraph(this.graphStructure.getVisibleView());
        }
        if (this.undirected) {
            return this.getHierarchicalUndirectedGraph(this.graphStructure.getVisibleView());
        }
        if (this.mixed) {
            return this.getHierarchicalMixedGraph(this.graphStructure.getVisibleView());
        }
        return this.getHierarchicalDirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public HierarchicalDirectedGraph getHierarchicalDirectedGraphVisible() {
        return this.getHierarchicalDirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public HierarchicalMixedGraph getHierarchicalMixedGraphVisible() {
        return this.getHierarchicalMixedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public HierarchicalUndirectedGraph getHierarchicalUndirectedGraphVisible() {
        return this.getHierarchicalUndirectedGraph(this.graphStructure.getVisibleView());
    }

    @Override
    public GraphSettings settings() {
        return this.settingsManager;
    }

    @Override
    public void pushFrom(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        HierarchicalGraphImpl graphImpl = (HierarchicalGraphImpl)graph;
        if (graphImpl.getGraphModel() == this) {
            throw new IllegalArgumentException("The graph must be from a different Workspace");
        }
        Dhns source = (Dhns)graphImpl.getGraphModel();
        source.getDuplicateManager().duplicate(this, (GraphViewImpl)graphImpl.getView());
        this.graphVersion.incNodeAndEdgeVersion();
    }

    @Override
    public void pushNodes(Graph graph, Node[] nodes) {
        if (graph == null) {
            throw new NullPointerException();
        }
        HierarchicalGraphImpl graphImpl = (HierarchicalGraphImpl)graph;
        if (graphImpl.getGraphModel() == this) {
            throw new IllegalArgumentException("The graph must be from a different Workspace");
        }
        Dhns source = (Dhns)graphImpl.getGraphModel();
        source.getDuplicateManager().duplicateNodes(this, nodes);
        this.graphVersion.incNodeAndEdgeVersion();
    }

    @Override
    public void clear() {
        this.graphVersion = new GraphVersion();
        this.graphStructure = new GraphStructure(this);
    }

    public void readXML(Element element) {
    }

    public Element writeXML(Document document) {
        return null;
    }

    @Override
    public GraphModel copy() {
        return null;
    }

    @Override
    public GraphView newView() {
        return this.graphStructure.getNewView();
    }

    @Override
    public GraphView copyView(GraphView view) {
        return this.graphStructure.copyView((GraphViewImpl)view);
    }

    @Override
    public void destroyView(GraphView view) {
        this.graphStructure.destroyView((GraphViewImpl)view);
    }

    @Override
    public void setVisibleView(GraphView view) {
        this.graphStructure.setVisibleView(view != null ? (GraphViewImpl)view : null);
    }

    @Override
    public GraphView getVisibleView() {
        return this.graphStructure.getVisibleView();
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }
}

