/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.HashMap;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphFactoryImpl;
import org.gephi.graph.dhns.core.GraphStructure;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.EdgeDataImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.NodeDataImpl;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class DuplicateManager {
    private final Dhns dhns;

    public DuplicateManager(Dhns dhns) {
        this.dhns = dhns;
    }

    public void duplicate(Dhns destination) {
        this.duplicate(destination, this.dhns.getGraphStructure().getMainView());
    }

    public void duplicate(Dhns destination, GraphViewImpl view) {
        GraphFactoryImpl factory = destination.factory();
        this.dhns.readLock();
        destination.writeLock();
        TreeStructure treeStructure = view.getStructure();
        GraphStructure newGraphStructure = destination.getGraphStructure();
        TreeStructure newStructure = newGraphStructure.getMainView().getStructure();
        TreeListIterator itr = new TreeListIterator(treeStructure.getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            AbstractNode nodeCopy = factory.newNode();
            this.duplicateNodeData(node.getNodeData(), nodeCopy.getNodeData());
            nodeCopy.setEnabled(node.isEnabled());
            nodeCopy.setEnabledInDegree(node.getEnabledInDegree());
            nodeCopy.setEnabledOutDegree(node.getEnabledOutDegree());
            nodeCopy.setEnabledMutualDegree(node.getEnabledMutualDegree());
            AbstractNode parentCopy = node.parent != null ? newStructure.getNodeAt(node.parent.getPre()) : null;
            newStructure.insertAsChild(nodeCopy, parentCopy);
            newGraphStructure.addToDictionnary(nodeCopy);
        }
        ParamAVLIterator edgeIterator = new ParamAVLIterator();
        TreeListIterator itr2 = new TreeListIterator(treeStructure.getTree(), 1);
        while (itr2.hasNext()) {
            AbstractNode node = itr2.next();
            if (node.getEdgesOutTree().isEmpty()) continue;
            edgeIterator.setNode(node.getEdgesOutTree());
            while (edgeIterator.hasNext()) {
                AbstractEdge edgeCopy;
                AbstractEdge edge = (AbstractEdge)edgeIterator.next();
                AbstractNode sourceCopy = newStructure.getNodeAt(edge.getSource(view.getViewId()).getPre());
                AbstractNode targetCopy = newStructure.getNodeAt(edge.getTarget(view.getViewId()).getPre());
                if (edge.isMixed()) {
                    edgeCopy = factory.newEdge(edge.getEdgeData().getId(), sourceCopy, targetCopy, edge.getWeight(), edge.isDirected());
                    if (edge.isDirected()) {
                        destination.touchDirected();
                    } else {
                        destination.touchUndirected();
                    }
                } else {
                    edgeCopy = factory.newEdge(sourceCopy, targetCopy);
                    edgeCopy.setWeight(edge.getWeight());
                    destination.touchDirected();
                }
                this.duplicateEdgeData(edge.getEdgeData(), edgeCopy.getEdgeData());
                sourceCopy.getEdgesOutTree().add(edgeCopy);
                targetCopy.getEdgesInTree().add(edgeCopy);
                newGraphStructure.addToDictionnary(edgeCopy);
            }
        }
        newGraphStructure.getMainView().setNodesEnabled(view.getNodesEnabled());
        newGraphStructure.getMainView().setEdgesCountTotal(view.getEdgesCountTotal());
        newGraphStructure.getMainView().setEdgesCountEnabled(view.getEdgesCountEnabled());
        newGraphStructure.getMainView().setMutualEdgesTotal(view.getMutualEdgesTotal());
        newGraphStructure.getMainView().setMutualEdgesEnabled(view.getMutualEdgesEnabled());
        newGraphStructure.getMainView().getStructureModifier().getEdgeProcessor().computeMetaEdges();
        destination.writeUnlock();
        this.dhns.readUnlock();
    }

    public void duplicateNodes(Dhns destination, Node[] nodes) {
        HashMap<AbstractNode, AbstractNode> nodeMap = new HashMap<AbstractNode, AbstractNode>();
        GraphFactoryImpl factory = destination.factory();
        Graph destGraph = null;
        destGraph = this.dhns.isDirected() ? destination.getDirectedGraph() : (this.dhns.isUndirected() ? destination.getUndirectedGraph() : destination.getMixedGraph());
        this.dhns.readLock();
        destination.writeLock();
        for (Node sourceNode : nodes) {
            AbstractNode absSourceNode = (AbstractNode)sourceNode;
            AbstractNode nodeCopy = factory.newNode(sourceNode.getNodeData().getId());
            destGraph.addNode(nodeCopy);
            this.duplicateNodeData((NodeDataImpl)sourceNode.getNodeData(), nodeCopy.getNodeData());
            nodeMap.put(absSourceNode, nodeCopy);
        }
        ParamAVLIterator edgeIterator = new ParamAVLIterator();
        for (Node sourceNode : nodes) {
            AbstractEdge edgeCopy;
            AbstractNode copyTargetNode;
            AbstractNode originalTargetNode;
            AbstractEdge edge;
            AbstractNode absSourceNode = (AbstractNode)sourceNode;
            AbstractNode nodeCopy = (AbstractNode)nodeMap.get(absSourceNode);
            int sourceView = absSourceNode.getViewId();
            if (!absSourceNode.getEdgesOutTree().isEmpty()) {
                edgeIterator.setNode(absSourceNode.getEdgesOutTree());
                while (edgeIterator.hasNext()) {
                    edge = (AbstractEdge)edgeIterator.next();
                    originalTargetNode = edge.getTarget(sourceView);
                    copyTargetNode = (AbstractNode)nodeMap.get(originalTargetNode);
                    if (copyTargetNode == null) continue;
                    edgeCopy = factory.newEdge(edge.getEdgeData().getId(), nodeCopy, copyTargetNode, edge.getWeight(), edge.isDirected());
                    destGraph.addEdge(edgeCopy);
                    this.duplicateEdgeData(edge.getEdgeData(), edgeCopy.getEdgeData());
                }
            }
            if (absSourceNode.getMetaEdgesOutTree().isEmpty()) continue;
            edgeIterator.setNode(absSourceNode.getMetaEdgesOutTree());
            while (edgeIterator.hasNext()) {
                edge = (AbstractEdge)edgeIterator.next();
                originalTargetNode = edge.getTarget(sourceView);
                copyTargetNode = (AbstractNode)nodeMap.get(originalTargetNode);
                if (copyTargetNode == null) continue;
                edgeCopy = factory.newEdge(edge.getEdgeData().getId(), nodeCopy, copyTargetNode, edge.getWeight(), edge.isDirected());
                destGraph.addEdge(edgeCopy);
                this.duplicateEdgeData(edge.getEdgeData(), edgeCopy.getEdgeData());
            }
        }
        destination.writeUnlock();
        this.dhns.readUnlock();
    }

    private void duplicateNodeData(NodeDataImpl source, NodeDataImpl dest) {
        dest.setX(source.x());
        dest.setY(source.y());
        dest.setZ(source.z());
        dest.setR(source.r());
        dest.setG(source.g());
        dest.setB(source.b());
        dest.setAlpha(source.alpha());
        dest.setSize(source.getSize());
        dest.getTextData().setColor(source.getTextData().getR(), source.getTextData().getG(), source.getTextData().getB(), source.getTextData().getAlpha());
        dest.getTextData().setSize(source.getTextData().getSize());
        dest.getTextData().setVisible(source.getTextData().isVisible());
        Attributes sourceAttributes = source.getAttributes();
        for (int i = 0; i < sourceAttributes.countValues(); ++i) {
            dest.getAttributes().setValue(i, sourceAttributes.getValue(i));
        }
    }

    private void duplicateEdgeData(EdgeDataImpl source, EdgeDataImpl dest) {
        dest.setR(source.r());
        dest.setG(source.g());
        dest.setB(source.b());
        dest.setAlpha(source.alpha());
        dest.getTextData().setColor(source.getTextData().getR(), source.getTextData().getG(), source.getTextData().getB(), source.getTextData().getAlpha());
        dest.getTextData().setSize(source.getTextData().getSize());
        dest.getTextData().setVisible(source.getTextData().isVisible());
        Attributes sourceAttributes = source.getAttributes();
        for (int i = 0; i < sourceAttributes.countValues(); ++i) {
            dest.getAttributes().setValue(i, sourceAttributes.getValue(i));
        }
    }
}

