/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.graph.dhns.predicate.Tautology;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class EdgeProcessor {
    private final TreeStructure treeStructure;
    private final Dhns dhns;
    private final GraphViewImpl view;
    private final int viewId;
    private ParamAVLIterator<AbstractEdge> edgeIterator;

    public EdgeProcessor(Dhns dhns, GraphViewImpl view) {
        this.dhns = dhns;
        this.treeStructure = view.getStructure();
        this.view = view;
        this.viewId = view.getViewId();
        this.edgeIterator = new ParamAVLIterator();
    }

    public AbstractEdge[] clearEdges(AbstractNode node) {
        AbstractEdge edge;
        int edgesCount = node.getEdgesInTree().getCount() + node.getEdgesOutTree().getCount();
        if (edgesCount == 0) {
            return null;
        }
        AbstractEdge[] clearedEdges = new AbstractEdge[edgesCount];
        int i = 0;
        if (node.getEdgesInTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                boolean mutual;
                edge = this.edgeIterator.next();
                this.removeEdgeFromMetaEdge(edge);
                AbstractNode source = edge.getSource(this.viewId);
                this.view.decEdgesCountTotal(1);
                boolean bl = mutual = !edge.isSelfLoop() && node.getEdgesOutTree().hasNeighbour(source);
                if (node.isEnabled() && source.isEnabled()) {
                    this.view.decEdgesCountEnabled(1);
                    node.decEnabledInDegree();
                    source.decEnabledOutDegree();
                    if (mutual) {
                        source.decEnabledMutualDegree();
                        node.decEnabledMutualDegree();
                        this.view.decMutualEdgesEnabled(1);
                    }
                }
                if (mutual) {
                    this.view.decMutualEdgesTotal(1);
                }
                source.getEdgesOutTree().remove(edge);
                clearedEdges[i] = edge;
                ++i;
            }
            node.getEdgesInTree().clear();
        }
        if (node.getEdgesOutTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                this.removeEdgeFromMetaEdge(edge);
                AbstractNode target = edge.getTarget(this.viewId);
                if (!edge.isSelfLoop()) {
                    this.view.decEdgesCountTotal(1);
                    if (node.isEnabled()) {
                        node.decEnabledOutDegree();
                        target.decEnabledInDegree();
                        this.view.decEdgesCountEnabled(1);
                    }
                }
                edge.getTarget(this.viewId).getEdgesInTree().remove(edge);
                clearedEdges[i] = edge;
                ++i;
            }
            node.getEdgesOutTree().clear();
        }
        return clearedEdges;
    }

    public void clearEdgesWithoutRemove(AbstractNode node) {
        AbstractEdge edge;
        if (node.getEdgesInTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                this.removeEdgeFromMetaEdge(edge);
            }
        }
        if (node.getEdgesOutTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                this.removeEdgeFromMetaEdge(edge);
            }
        }
    }

    public void clearMetaEdges(AbstractNode node) {
        AbstractEdge edge;
        if (node.getMetaEdgesInTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getMetaEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                AbstractNode source = edge.getSource(this.viewId);
                if (!edge.isSelfLoop() && node.getMetaEdgesOutTree().hasNeighbour(source)) {
                    node.decMutualMetaEdgeDegree();
                    source.decMutualMetaEdgeDegree();
                    this.view.decMutualMetaEdgesTotal(1);
                }
                source.getMetaEdgesOutTree().remove((MetaEdgeImpl)edge);
                this.view.decMetaEdgesCount(1);
            }
            node.getMetaEdgesInTree().clear();
        }
        if (node.getMetaEdgesOutTree().getCount() > 0) {
            this.edgeIterator.setNode(node.getMetaEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                edge.getTarget(this.viewId).getMetaEdgesInTree().remove((MetaEdgeImpl)edge);
                this.view.decMetaEdgesCount(1);
            }
            node.getMetaEdgesOutTree().clear();
        }
    }

    public void clearMetaEdgesOutOfRange(AbstractNode enabledNode, AbstractNode rangeNode) {
        MetaEdgeImpl metaEdge;
        int rangeStart = rangeNode.getPre();
        int rangeLimit = rangeStart + rangeNode.size;
        if (enabledNode.getMetaEdgesOutTree().getCount() > 0) {
            this.edgeIterator.setNode(enabledNode.getMetaEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                metaEdge = (MetaEdgeImpl)this.edgeIterator.next();
                AbstractNode target = metaEdge.getTarget(this.viewId);
                int targetPre = target.getPre();
                if (targetPre < rangeStart || targetPre > rangeLimit) continue;
                if (!metaEdge.isSelfLoop() && target.getMetaEdgesOutTree().hasNeighbour(enabledNode)) {
                    enabledNode.decMutualMetaEdgeDegree();
                    target.decMutualMetaEdgeDegree();
                    this.view.decMutualMetaEdgesTotal(1);
                }
                this.edgeIterator.remove();
                target.getMetaEdgesInTree().remove(metaEdge);
                this.view.decMetaEdgesCount(1);
            }
        }
        if (enabledNode.getMetaEdgesInTree().getCount() > 0) {
            this.edgeIterator.setNode(enabledNode.getMetaEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                metaEdge = (MetaEdgeImpl)this.edgeIterator.next();
                int sourcePre = metaEdge.getSource(this.viewId).getPre();
                if (sourcePre < rangeStart || sourcePre > rangeLimit) continue;
                this.edgeIterator.remove();
                metaEdge.getSource(this.viewId).getMetaEdgesOutTree().remove(metaEdge);
                this.view.decMetaEdgesCount(1);
            }
        }
    }

    public AbstractEdge[] clearAllEdges() {
        AbstractEdge[] edges = new AbstractEdge[this.view.getEdgesCountTotal()];
        int i = 0;
        TreeListIterator itr = new TreeListIterator(this.treeStructure.getTree());
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            this.edgeIterator.setNode(node.getEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                AbstractEdge edge = this.edgeIterator.next();
                this.dhns.getGraphStructure().removeFromDictionnary(edge);
                edges[i++] = edge;
            }
            node.getEdgesInTree().clear();
            node.getEdgesOutTree().clear();
            node.setEnabledInDegree(0);
            node.setEnabledOutDegree(0);
            node.setEnabledMutualDegree(0);
            node.clearMetaEdges();
        }
        this.view.setEdgesCountTotal(0);
        this.view.setEdgesCountEnabled(0);
        this.view.setMutualEdgesEnabled(0);
        this.view.setMutualEdgesTotal(0);
        return edges;
    }

    public void clearAllMetaEdges() {
        TreeListIterator itr = new TreeListIterator(this.treeStructure.getTree());
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            node.clearMetaEdges();
            node.setMutualMetaEdgeDegree(0);
        }
        this.view.setMetaEdgesCountTotal(0);
        this.view.setMutualMetaEdgesTotal(0);
    }

    public void computeMetaEdges(AbstractNode node, AbstractNode enabledAncestor) {
        if (!this.dhns.getSettingsManager().isAutoMetaEdgeCreation()) {
            return;
        }
        if (enabledAncestor == null) {
            enabledAncestor = node;
        }
        int clusterEnd = node.getPre() + node.size;
        for (int i = node.pre; i <= clusterEnd; ++i) {
            int j;
            AbstractNode[] enabledAncestors;
            AbstractEdge edge;
            AbstractNode desc = this.treeStructure.getNodeAt(i);
            if (desc.getEdgesOutTree().getCount() > 0) {
                this.edgeIterator.setNode(desc.getEdgesOutTree());
                while (this.edgeIterator.hasNext()) {
                    edge = this.edgeIterator.next();
                    enabledAncestors = this.treeStructure.getEnabledAncestorsOrSelf(edge.getTarget(this.viewId));
                    if (enabledAncestors == null) continue;
                    for (j = 0; j < enabledAncestors.length; ++j) {
                        AbstractNode targetNode = enabledAncestors[j];
                        if (targetNode == edge.getTarget(this.viewId) && enabledAncestor == edge.getSource(this.viewId)) continue;
                        this.createMetaEdge(enabledAncestor, targetNode, edge);
                    }
                }
            }
            if (desc.getEdgesInTree().getCount() <= 0) continue;
            this.edgeIterator.setNode(desc.getEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                enabledAncestors = this.treeStructure.getEnabledAncestorsOrSelf(edge.getSource(this.viewId));
                if (enabledAncestors == null) continue;
                for (j = 0; j < enabledAncestors.length; ++j) {
                    AbstractNode sourceNode = enabledAncestors[j];
                    if (sourceNode == edge.getSource(this.viewId) && enabledAncestor == edge.getTarget(this.viewId)) continue;
                    this.createMetaEdge(sourceNode, enabledAncestor, edge);
                }
            }
        }
    }

    public void computeMetaEdges() {
        TreeIterator itr = new TreeIterator(this.treeStructure, true, Tautology.instance);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            this.computeMetaEdges(node, node);
        }
    }

    private void createMetaEdge(AbstractNode source, AbstractNode target, AbstractEdge edge) {
        AbstractNode edgeSource = edge.getSource(this.viewId);
        AbstractNode edgeTarget = edge.getTarget(this.viewId);
        if (edgeSource == source && edgeTarget == target) {
            return;
        }
        if (source == target) {
            return;
        }
        MetaEdgeImpl metaEdge = this.getMetaEdge(source, target);
        if (metaEdge == null) {
            metaEdge = this.createMetaEdge(source, target);
        }
        if (metaEdge != null && metaEdge.addEdge(edge)) {
            this.dhns.getSettingsManager().getMetaEdgeBuilder().pushEdge(edge, edgeSource, edgeTarget, metaEdge);
        }
    }

    private MetaEdgeImpl createMetaEdge(AbstractNode source, AbstractNode target) {
        if (source == target) {
            return null;
        }
        MetaEdgeImpl newEdge = this.dhns.factory().newMetaEdge(source, target);
        source.getMetaEdgesOutTree().add(newEdge);
        target.getMetaEdgesInTree().add(newEdge);
        if (!newEdge.isSelfLoop() && target.getMetaEdgesOutTree().hasNeighbour(source)) {
            source.incMutualMetaEdgeDegree();
            target.incMutualMetaEdgeDegree();
            this.view.incMutualMetaEdgesTotal(1);
        }
        this.view.incMetaEdgesCount(1);
        return newEdge;
    }

    public void createMetaEdge(AbstractEdge edge) {
        if (!this.dhns.getSettingsManager().isAutoMetaEdgeCreation()) {
            return;
        }
        if (edge.isSelfLoop()) {
            return;
        }
        AbstractNode[] sourceAncestors = this.treeStructure.getEnabledAncestorsOrSelf(edge.getSource(this.viewId));
        AbstractNode[] targetAncestors = this.treeStructure.getEnabledAncestorsOrSelf(edge.getTarget(this.viewId));
        if (sourceAncestors != null && targetAncestors != null) {
            for (int i = 0; i < sourceAncestors.length; ++i) {
                for (int j = 0; j < targetAncestors.length; ++j) {
                    AbstractNode sourceParent = sourceAncestors[i];
                    AbstractNode targetParent = targetAncestors[j];
                    if (sourceParent == targetParent) continue;
                    this.createMetaEdge(sourceParent, targetParent, edge);
                }
            }
        }
    }

    public void removeEdgeFromMetaEdge(AbstractEdge edge) {
        if (!this.dhns.getSettingsManager().isAutoMetaEdgeCreation()) {
            return;
        }
        if (edge.isSelfLoop()) {
            return;
        }
        MetaEdgeImpl metaEdge = this.getMetaEdge(edge);
        if (metaEdge != null) {
            if (metaEdge.removeEdge(edge)) {
                AbstractNode edgeSource = edge.getSource(this.viewId);
                AbstractNode edgeTarget = edge.getTarget(this.viewId);
                this.dhns.getSettingsManager().getMetaEdgeBuilder().pullEdge(edge, edgeSource, edgeTarget, metaEdge);
            }
            if (metaEdge.isEmpty()) {
                AbstractNode source = metaEdge.getSource(this.viewId);
                AbstractNode target = metaEdge.getTarget(this.viewId);
                if (!metaEdge.isSelfLoop() && source.getMetaEdgesInTree().hasNeighbour(target)) {
                    source.decMutualMetaEdgeDegree();
                    target.decMutualMetaEdgeDegree();
                    this.view.decMutualMetaEdgesTotal(1);
                }
                source.getMetaEdgesOutTree().remove(metaEdge);
                target.getMetaEdgesInTree().remove(metaEdge);
                this.view.decMetaEdgesCount(1);
            }
        }
    }

    private MetaEdgeImpl getMetaEdge(AbstractNode source, AbstractNode target) {
        if (source == target) {
            return null;
        }
        return (MetaEdgeImpl)source.getMetaEdgesOutTree().getItem(target.getNumber());
    }

    private MetaEdgeImpl getMetaEdge(AbstractEdge edge) {
        if (edge.isSelfLoop()) {
            return null;
        }
        AbstractNode sourceParent = this.treeStructure.getEnabledAncestorOrSelf(edge.getSource(this.viewId));
        AbstractNode targetParent = this.treeStructure.getEnabledAncestorOrSelf(edge.getTarget(this.viewId));
        if (sourceParent != null && targetParent != null && sourceParent != targetParent) {
            return this.getMetaEdge(sourceParent, targetParent);
        }
        return null;
    }

    public AbstractEdge[] flattenNode(AbstractNode node) {
        AbstractEdge realEdge;
        AbstractEdge edge;
        AbstractEdge[] newEdges = null;
        if (!node.getMetaEdgesInTree().isEmpty() || !node.getMetaEdgesOutTree().isEmpty()) {
            newEdges = new AbstractEdge[node.getMetaEdgesInTree().getCount() + node.getMetaEdgesOutTree().getCount()];
        }
        int i = 0;
        if (!node.getMetaEdgesInTree().isEmpty()) {
            this.edgeIterator.setNode(node.getMetaEdgesInTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                AbstractNode source = edge.getSource(this.viewId);
                this.edgeIterator.remove();
                source.getMetaEdgesOutTree().remove((MetaEdgeImpl)edge);
                this.view.decMetaEdgesCount(1);
                if (node.getMetaEdgesOutTree().hasNeighbour(source)) {
                    source.decMutualMetaEdgeDegree();
                }
                if (!node.getEdgesInTree().hasNeighbour(source)) {
                    realEdge = this.dhns.factory().newEdge(source, node, edge.getWeight(), edge.isDirected());
                    realEdge.getEdgeData().moveFrom(edge.getEdgeData());
                    realEdge.setWeight(edge.getWeight());
                    newEdges[i] = realEdge;
                    source.getEdgesOutTree().add(realEdge);
                    node.getEdgesInTree().add(realEdge);
                    source.incEnabledOutDegree();
                    node.incEnabledInDegree();
                    this.view.incEdgesCountEnabled(1);
                    this.view.incEdgesCountTotal(1);
                    if (source.getEdgesInTree().hasNeighbour(node)) {
                        source.incEnabledMutualDegree();
                        node.incEnabledMutualDegree();
                        this.view.incMutualEdgesEnabled(1);
                        this.view.incMutualEdgesTotal(1);
                    }
                }
                ++i;
            }
        }
        if (!node.getMetaEdgesOutTree().isEmpty()) {
            this.edgeIterator.setNode(node.getMetaEdgesOutTree());
            while (this.edgeIterator.hasNext()) {
                edge = this.edgeIterator.next();
                AbstractNode target = edge.getTarget(this.viewId);
                this.edgeIterator.remove();
                target.getMetaEdgesInTree().remove((MetaEdgeImpl)edge);
                this.view.decMetaEdgesCount(1);
                if (!node.getEdgesOutTree().hasNeighbour(target)) {
                    realEdge = this.dhns.factory().newEdge(node, target, edge.getWeight(), edge.isDirected());
                    realEdge.getEdgeData().moveFrom(edge.getEdgeData());
                    realEdge.setWeight(edge.getWeight());
                    newEdges[i] = realEdge;
                    node.getEdgesOutTree().add(realEdge);
                    target.getEdgesInTree().add(realEdge);
                    node.incEnabledOutDegree();
                    target.incEnabledInDegree();
                    this.view.incEdgesCountEnabled(1);
                    this.view.incEdgesCountTotal(1);
                    if (target.getEdgesOutTree().hasNeighbour(node)) {
                        node.incEnabledMutualDegree();
                        target.incEnabledMutualDegree();
                        this.view.incMutualEdgesEnabled(1);
                        this.view.incMutualEdgesTotal(1);
                    }
                }
                ++i;
            }
        }
        this.view.decMutualMetaEdgesTotal(node.getMutualMetaEdgeDegree());
        node.setMutualMetaEdgeDegree(0);
        return newEdges;
    }

    public void incrementEdgesCounting(AbstractNode enabledNode, AbstractNode parent) {
        AbstractEdge edge;
        this.edgeIterator.setNode(enabledNode.getEdgesOutTree());
        while (this.edgeIterator.hasNext()) {
            edge = this.edgeIterator.next();
            AbstractNode target = edge.getTarget(this.view.getViewId());
            if (!target.isEnabled()) continue;
            this.view.incEdgesCountEnabled(1);
            enabledNode.incEnabledOutDegree();
            target.incEnabledInDegree();
            if (!target.getEdgesOutTree().hasNeighbour(enabledNode) || parent != null && (parent == null || target.parent == parent) && (parent == null || target.parent != parent || target.getId() >= enabledNode.getId())) continue;
            this.view.incMutualEdgesEnabled(1);
            enabledNode.incEnabledMutualDegree();
            target.incEnabledMutualDegree();
        }
        this.edgeIterator.setNode(enabledNode.getEdgesInTree());
        while (this.edgeIterator.hasNext()) {
            edge = this.edgeIterator.next();
            AbstractNode source = edge.getSource(this.view.getViewId());
            if (!source.isEnabled() || parent != null && source.parent == parent) continue;
            this.view.incEdgesCountEnabled(1);
            enabledNode.incEnabledInDegree();
            source.incEnabledOutDegree();
        }
    }

    public void decrementEdgesCouting(AbstractNode disabledNode, AbstractNode parent) {
        AbstractEdge edge;
        this.edgeIterator.setNode(disabledNode.getEdgesOutTree());
        while (this.edgeIterator.hasNext()) {
            edge = this.edgeIterator.next();
            AbstractNode target = edge.getTarget(this.view.getViewId());
            if (!target.isEnabled() && (parent == null || target.parent != parent) && !edge.isSelfLoop()) continue;
            target.decEnabledInDegree();
            disabledNode.decEnabledOutDegree();
            this.view.decEdgesCountEnabled(1);
            if (!target.getEdgesOutTree().hasNeighbour(disabledNode) || parent != null && (parent == null || target.parent != parent || target.getId() >= disabledNode.getId()) || edge.isSelfLoop()) continue;
            target.decEnabledMutualDegree();
            disabledNode.decEnabledMutualDegree();
            this.view.decMutualEdgesEnabled(1);
        }
        this.edgeIterator.setNode(disabledNode.getEdgesInTree());
        while (this.edgeIterator.hasNext()) {
            edge = this.edgeIterator.next();
            AbstractNode source = edge.getSource(this.view.getViewId());
            if (!source.isEnabled()) continue;
            this.view.decEdgesCountEnabled(1);
            disabledNode.decEnabledInDegree();
            source.decEnabledOutDegree();
        }
    }

    public void resetEdgesCounting(AbstractNode node) {
        node.setEnabledInDegree(0);
        node.setEnabledOutDegree(0);
        node.setEnabledMutualDegree(0);
    }

    public void computeEdgesCounting(AbstractNode node) {
        this.edgeIterator.setNode(node.getEdgesOutTree());
        while (this.edgeIterator.hasNext()) {
            AbstractEdge edge = this.edgeIterator.next();
            AbstractNode target = edge.getTarget(this.view.getViewId());
            if (!target.isEnabled()) continue;
            target.incEnabledInDegree();
            node.incEnabledOutDegree();
            this.view.incEdgesCountEnabled(1);
            if (!target.getEdgesOutTree().hasNeighbour(node) || target.getId() >= node.getId()) continue;
            target.incEnabledMutualDegree();
            node.incEnabledMutualDegree();
            this.view.incMutualEdgesEnabled(1);
        }
    }
}

