/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.event.AbstractEvent;
import org.gephi.graph.dhns.event.EdgeEvent;
import org.gephi.graph.dhns.event.GeneralEvent;
import org.gephi.graph.dhns.event.GraphEventDataImpl;
import org.gephi.graph.dhns.event.GraphEventImpl;
import org.gephi.graph.dhns.event.NodeEvent;
import org.gephi.graph.dhns.event.ViewEvent;

public class EventManager
implements Runnable {
    private static final long DELAY = 100L;
    private final List<GraphListener> listeners;
    private final AtomicReference<Thread> thread = new AtomicReference();
    private final LinkedBlockingQueue<AbstractEvent> eventQueue;
    private final Object lock = new Object();
    private final LinkedList<Integer> rateList = new LinkedList();
    private double avgRate = 1.0;
    private boolean stop;

    public EventManager(Dhns dhns) {
        this.eventQueue = new LinkedBlockingQueue();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.rateList.add(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rate = 0;
        while (!this.stop) {
            if (rate == (int)this.avgRate) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                int w = (int)((float)this.eventQueue.size() * 0.1f);
                w = Math.max(1, w);
                this.updateRate(w);
                ++rate;
            }
            ArrayList eventCompress = null;
            AbstractEvent precEvt = null;
            AbstractEvent evt = null;
            while ((evt = this.eventQueue.peek()) != null) {
                if (precEvt != null) {
                    if (!(evt instanceof NodeEvent) && !(evt instanceof EdgeEvent) || !precEvt.getEventType().equals((Object)evt.getEventType()) || precEvt.getView() != evt.getView()) break;
                    if (eventCompress == null) {
                        eventCompress = new ArrayList();
                        eventCompress.add(precEvt.getData());
                    }
                    eventCompress.add(evt.getData());
                }
                this.eventQueue.poll();
                precEvt = evt;
            }
            if (precEvt != null) {
                GraphEvent event = this.createEvent(precEvt, eventCompress);
                for (GraphListener l : this.listeners.toArray(new GraphListener[0])) {
                    l.graphChanged(event);
                }
            }
            ++rate;
            while (this.eventQueue.isEmpty()) {
                rate = (int)this.avgRate;
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private GraphEvent createEvent(AbstractEvent event, List<Object> compress) {
        GraphEventDataImpl eventData = event instanceof GeneralEvent ? null : new GraphEventDataImpl();
        GraphEventImpl graphEventImpl = new GraphEventImpl(event.getView(), event.getEventType(), eventData);
        if (event instanceof NodeEvent || event instanceof EdgeEvent) {
            ArrayList<Node> nodes = null;
            ArrayList<Edge> edges = null;
            if (compress != null) {
                for (Object o : compress) {
                    if (o instanceof Node) {
                        if (nodes == null) {
                            nodes = new ArrayList<Node>();
                        }
                        nodes.add((Node)o);
                        continue;
                    }
                    if (edges == null) {
                        edges = new ArrayList<Edge>();
                    }
                    edges.add((Edge)o);
                }
                switch (event.getEventType()) {
                    case ADD_NODES_AND_EDGES: {
                        if (nodes != null) {
                            eventData.setAddedNodes(nodes.toArray(new Node[0]));
                        }
                        if (edges == null) break;
                        eventData.setAddedEdges(edges.toArray(new Edge[0]));
                        break;
                    }
                    case REMOVE_NODES_AND_EDGES: {
                        if (nodes != null) {
                            eventData.setRemovedNodes(nodes.toArray(new Node[0]));
                        }
                        if (edges == null) break;
                        eventData.setRemovedEdges(edges.toArray(new Edge[0]));
                        break;
                    }
                    case EXPAND: {
                        eventData.setExpandedNodes(nodes.toArray(new Node[0]));
                        break;
                    }
                    case RETRACT: {
                        eventData.setRetractedNodes(nodes.toArray(new Node[0]));
                        break;
                    }
                    case MOVE_NODES: {
                        eventData.setMovedNodes(nodes.toArray(new Node[0]));
                    }
                }
            } else {
                switch (event.getEventType()) {
                    case ADD_NODES_AND_EDGES: {
                        if (event instanceof NodeEvent) {
                            eventData.setAddedNodes(new Node[]{(Node)event.getData()});
                            break;
                        }
                        eventData.setAddedEdges(new Edge[]{(Edge)event.getData()});
                        break;
                    }
                    case REMOVE_NODES_AND_EDGES: {
                        if (event instanceof NodeEvent) {
                            eventData.setRemovedNodes(new Node[]{(Node)event.getData()});
                            break;
                        }
                        eventData.setRemovedEdges(new Edge[]{(Edge)event.getData()});
                        break;
                    }
                    case EXPAND: {
                        eventData.setExpandedNodes(new Node[]{(Node)event.getData()});
                        break;
                    }
                    case RETRACT: {
                        eventData.setRetractedNodes(new Node[]{(Node)event.getData()});
                        break;
                    }
                    case MOVE_NODES: {
                        eventData.setMovedNodes(new Node[]{(Node)event.getData()});
                    }
                }
            }
        } else if (event instanceof ViewEvent) {
            eventData.setView((GraphView)event.getData());
        }
        return graphEventImpl;
    }

    private double updateRate(int n) {
        int windowLength = 10;
        if (this.rateList.size() == windowLength) {
            Integer oldest = this.rateList.poll();
            this.avgRate = (this.avgRate * (double)windowLength - (double)oldest.intValue()) / (double)(windowLength - 1);
        }
        this.avgRate = (this.avgRate * (double)this.rateList.size() + (double)n) / (double)(this.rateList.size() + 1);
        this.rateList.add(n);
        return this.avgRate;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(AbstractEvent event) {
        this.eventQueue.add(event);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("graph-event-bus");
        if (this.thread.compareAndSet(null, t)) {
            t.start();
        }
    }

    public boolean isRunning() {
        return this.thread.get() != null;
    }

    public void addGraphListener(GraphListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeGraphListener(GraphListener listener) {
        this.listeners.remove(listener);
    }
}

