/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import java.util.HashMap;
import java.util.Map;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphSettings;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AverageMetaEdgeBuilder;
import org.gephi.graph.dhns.edge.SumMetaEdgeBuilder;
import org.gephi.graph.dhns.event.GeneralEvent;
import org.gephi.graph.spi.MetaEdgeBuilder;

public class SettingsManager
implements GraphSettings {
    private Dhns dhns;
    private Boolean autoMetaEdgeCreation;
    private MetaEdgeBuilder metaEdgeBuilder;
    private Float metaEdgeBuilderNonDeepDivisor;
    private Estimator defaultWeightEstimator;

    public SettingsManager(Dhns dhns) {
        this.dhns = dhns;
        this.defaultSettings();
    }

    private void defaultSettings() {
        this.autoMetaEdgeCreation = Boolean.TRUE;
        this.metaEdgeBuilderNonDeepDivisor = Float.valueOf(10.0f);
        this.metaEdgeBuilder = new SumMetaEdgeBuilder(this.metaEdgeBuilderNonDeepDivisor.floatValue());
        this.defaultWeightEstimator = Estimator.AVERAGE;
    }

    public boolean isAutoMetaEdgeCreation() {
        return this.autoMetaEdgeCreation;
    }

    @Override
    public MetaEdgeBuilder getMetaEdgeBuilder() {
        return this.metaEdgeBuilder;
    }

    public Estimator getDefaultWeightEstimator() {
        return this.defaultWeightEstimator;
    }

    @Override
    public void setMetaEdgeBuilder(MetaEdgeBuilder metaEdgeBuilder) {
        this.putClientProperty("metaEdgeBuilder", metaEdgeBuilder);
    }

    @Override
    public void putClientProperty(String key, Object value) {
        if (key.equals("autoMetaEdgeCreation")) {
            this.autoMetaEdgeCreation = (Boolean)value;
            this.fireUpdate();
        } else if (key.equals("metaEdgeBuilder")) {
            if (value instanceof MetaEdgeBuilder) {
                this.metaEdgeBuilder = (MetaEdgeBuilder)value;
            }
            if (value.equals("average")) {
                this.metaEdgeBuilder = new AverageMetaEdgeBuilder(this.metaEdgeBuilderNonDeepDivisor.floatValue());
            } else if (value.equals("sum")) {
                this.metaEdgeBuilder = new SumMetaEdgeBuilder(this.metaEdgeBuilderNonDeepDivisor.floatValue());
            }
            this.fireUpdate();
        } else if (key.equals("metaEdgeBuilderNonDeepDivisor")) {
            this.metaEdgeBuilderNonDeepDivisor = (Float)value;
            if (this.metaEdgeBuilder instanceof SumMetaEdgeBuilder) {
                this.metaEdgeBuilder = new SumMetaEdgeBuilder(this.metaEdgeBuilderNonDeepDivisor.floatValue());
            } else if (this.metaEdgeBuilder instanceof AverageMetaEdgeBuilder) {
                this.metaEdgeBuilder = new AverageMetaEdgeBuilder(this.metaEdgeBuilderNonDeepDivisor.floatValue());
            }
            this.fireUpdate();
        } else if (key.equals("defaultWeightEstimator")) {
            this.defaultWeightEstimator = (Estimator)((Object)value);
            this.fireUpdate();
        }
    }

    @Override
    public Object getClientProperty(String key) {
        if (key.equals("autoMetaEdgeCreation")) {
            return this.autoMetaEdgeCreation;
        }
        if (key.equals("metaEdgeBuilder")) {
            if (this.metaEdgeBuilder instanceof SumMetaEdgeBuilder) {
                return "sum";
            }
            if (this.metaEdgeBuilder instanceof AverageMetaEdgeBuilder) {
                return "average";
            }
            return this.metaEdgeBuilder.getClass().getName();
        }
        if (key.equals("metaEdgeBuilderNonDeepDivisor")) {
            return this.metaEdgeBuilderNonDeepDivisor;
        }
        if (key.equals("defaultWeightEstimator")) {
            return this.defaultWeightEstimator;
        }
        return null;
    }

    private void fireUpdate() {
        this.dhns.getGraphVersion().incEdgeVersion();
        for (GraphViewImpl view : this.dhns.getGraphStructure().getViews()) {
            this.dhns.getEventManager().fireEvent(new GeneralEvent(GraphEvent.EventType.META_EDGES_UPDATE, view));
        }
    }

    @Override
    public Map<String, Object> getClientProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoMetaEdgeCreation", this.getClientProperty("autoMetaEdgeCreation"));
        map.put("metaEdgeBuilder", this.getClientProperty("metaEdgeBuilder"));
        map.put("metaEdgeBuilderNonDeepDivisor", this.getClientProperty("metaEdgeBuilderNonDeepDivisor"));
        map.put("defaultWeightEstimator", this.getClientProperty("defaultWeightEstimator"));
        return map;
    }
}

