/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.core;

import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;

public class TreeStructure {
    protected DurableTreeList tree;
    protected AbstractNode root;
    protected final GraphViewImpl view;

    public TreeStructure(GraphViewImpl view) {
        this.tree = new DurableTreeList(view);
        this.view = view;
        this.initRoot();
    }

    private void initRoot() {
        this.root = new AbstractNode(0, this.view != null ? this.view.getViewId() : 0, 0, 0, 0, null);
        this.tree.add(this.root);
    }

    public AbstractNode getNodeAt(int pre) {
        return this.tree.get(pre);
    }

    public AbstractNode getEnabledAncestorOrSelf(AbstractNode node) {
        AbstractNode parent = node;
        while (!parent.isEnabled()) {
            parent = parent.parent;
            if (parent != null && parent.getPre() != 0) continue;
            return null;
        }
        return parent;
    }

    public AbstractNode[] getEnabledAncestorsOrSelf(AbstractNode node) {
        AbstractNode enabled = this.getEnabledAncestorOrSelf(node);
        if (enabled != null) {
            return new AbstractNode[]{enabled};
        }
        return null;
    }

    public AbstractNode getEnabledAncestor(AbstractNode node) {
        AbstractNode parent = node.parent;
        while (!parent.isEnabled()) {
            if (parent.getPre() == 0) {
                return null;
            }
            parent = parent.parent;
        }
        return parent;
    }

    public void insertAtEnd(AbstractNode node) {
        node.pre = this.tree.size();
        this.tree.add(node);
    }

    public void insertAsChild(AbstractNode node, AbstractNode parent) {
        node.parent = parent;
        node.pre = parent.getPre() + parent.size + 1;
        node.level = parent.level + 1;
        this.tree.add(node.pre, node);
        this.incrementAncestorsSize(node);
    }

    public void resetLevelSize(int firstLevel) {
        this.tree.levelsSize = new int[1 + (firstLevel > 0 ? 1 : 0)];
        if (firstLevel > 0) {
            this.tree.levelsSize[1] = firstLevel;
        }
    }

    public void move(AbstractNode node, AbstractNode newParent) {
        AbstractNode sourceParent = node.parent;
        int sourceSize = 1 + node.size;
        this.tree.move(node.getPre(), newParent.getPre());
        if (sourceParent != null) {
            this.decrementAncestorAndSelfSize(sourceParent, sourceSize);
        }
        this.incrementAncestorsAndSelfSize(newParent, sourceSize);
    }

    public void deleteAtPre(AbstractNode node) {
        int pre = node.getPre();
        AbstractNode n = this.tree.remove(pre);
        n.removeFromView(this.view.getViewId());
        for (int i = 0; i < node.size; ++i) {
            n = this.tree.remove(pre);
            n.removeFromView(this.view.getViewId());
        }
    }

    public void deleteDescendantAndSelf(AbstractNode node) {
        this.decrementAncestorSize(node, node.size + 1);
        this.deleteAtPre(node);
    }

    public void deleteOnlySelf(AbstractNode node) {
        int pre = node.getPre();
        AbstractNode n = this.tree.remove(pre);
        n.removeFromView(this.view.getViewId());
    }

    public void incrementAncestorsSize(AbstractNode node) {
        this.incrementAncestorsSize(node, 1);
    }

    public void incrementAncestorsSize(AbstractNode node, int shift) {
        while (node.parent != null) {
            node = node.parent;
            node.size += shift;
            node.getPost();
        }
    }

    public void incrementAncestorsAndSelfSize(AbstractNode node, int shift) {
        while (node != null) {
            node.size += shift;
            node.getPost();
            node = node.parent;
        }
    }

    public void decrementAncestorSize(AbstractNode node, int shift) {
        while (node.parent != null) {
            node = node.parent;
            node.size -= shift;
            node.getPost();
        }
    }

    public void decrementAncestorAndSelfSize(AbstractNode node, int shift) {
        while (node != null) {
            node.size -= shift;
            node.getPost();
            node = node.parent;
        }
    }

    public boolean hasEnabledDescendant(AbstractNode node) {
        for (int i = node.getPre() + 1; i <= node.pre + node.size; ++i) {
            AbstractNode descendant = this.tree.get(i);
            if (!descendant.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void showTreeAsTable() {
        System.out.println("pre\tsize\tlevel\tparent\tpost\tenabled\tid");
        System.out.println("-----------------------------------------------------------------");
        int pre = 0;
        for (AbstractNode p : this.tree) {
            System.out.println(p.pre + "\t" + p.size + "\t" + p.level + "\t" + (p.parent == null ? "null" : Integer.valueOf(p.parent.getPre())) + "\t" + p.post + "\t" + p.isEnabled() + "\t" + p.getId());
            ++pre;
        }
    }

    public void clear() {
        TreeListIterator itr = new TreeListIterator(this.tree);
        while (itr.hasNext()) {
            AbstractNode preNode = itr.next();
            preNode.avlNode = null;
            preNode.parent = null;
        }
        this.tree.clear();
        this.root = null;
        this.initRoot();
    }

    public int getTreeSize() {
        return this.tree.size();
    }

    public int getTreeHeight() {
        int[] levelsSize = this.tree.levelsSize;
        for (int i = levelsSize.length - 1; i >= 0; --i) {
            if (levelsSize[i] <= 0) continue;
            return i;
        }
        return 0;
    }

    public int getLevelSize(int level) {
        return this.tree.levelsSize[level];
    }

    public DurableTreeList getTree() {
        return this.tree;
    }

    public AbstractNode getRoot() {
        return this.root;
    }
}

