/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge;

import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.node.AbstractNode;

public class MetaEdgeImpl
extends AbstractEdge
implements MetaEdge {
    private int count = 0;
    private int directedCount = 0;

    public MetaEdgeImpl(int ID, AbstractNode source, AbstractNode target) {
        super(ID, source, target);
        this.setWeight(0.0f);
    }

    public boolean addEdge(AbstractEdge edge) {
        if (edge.isDirected()) {
            ++this.directedCount;
        }
        ++this.count;
        return true;
    }

    public boolean removeEdge(AbstractEdge edge) {
        if (edge.isDirected()) {
            --this.directedCount;
        }
        --this.count;
        return true;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isDirected() {
        return this.directedCount > 0;
    }

    @Override
    public boolean isMetaEdge() {
        return true;
    }

    public AbstractEdge getUndirected() {
        if (this.source == this.target) {
            return this;
        }
        AbstractEdge mutual = (AbstractEdge)this.source.getMetaEdgesInTree().getItem(this.target.getNumber());
        if (mutual != null && mutual.getId() < this.ID) {
            return mutual;
        }
        return this;
    }
}

