/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class EdgeAndMetaEdgeIterator
extends AbstractEdgeIterator
implements Iterator<Edge> {
    protected AbstractNodeIterator nodeIterator;
    protected ParamAVLIterator<MetaEdgeImpl> edgeIterator;
    protected AbstractNode currentNode;
    protected AbstractEdge pointer;
    protected boolean undirected;
    protected boolean metaEdge = false;
    protected Predicate<AbstractNode> nodePredicate;
    protected Predicate<AbstractEdge> edgePredicate;

    public EdgeAndMetaEdgeIterator(TreeStructure treeStructure, AbstractNodeIterator nodeIterator, boolean undirected, Predicate<AbstractNode> nodePredicate, Predicate<AbstractEdge> edgePredicate) {
        this.nodeIterator = nodeIterator;
        this.edgeIterator = new ParamAVLIterator();
        this.undirected = undirected;
        this.nodePredicate = nodePredicate;
        this.edgePredicate = edgePredicate;
    }

    @Override
    public boolean hasNext() {
        while (this.pointer == null || this.undirected && (this.metaEdge && ((MetaEdgeImpl)this.pointer).getUndirected() != this.pointer || !this.metaEdge && this.pointer.getUndirected(this.currentNode.getViewId()) != this.pointer)) {
            while (!this.edgeIterator.hasNext()) {
                if (this.currentNode != null && !this.metaEdge) {
                    this.metaEdge = true;
                    if (this.currentNode.getMetaEdgesOutTree().isEmpty()) continue;
                    this.edgeIterator.setNode(this.currentNode.getMetaEdgesOutTree());
                    continue;
                }
                if (this.nodeIterator.hasNext()) {
                    this.currentNode = this.nodeIterator.next();
                    if (!this.currentNode.getEdgesOutTree().isEmpty()) {
                        this.edgeIterator.setNode(this.currentNode.getEdgesOutTree());
                    }
                    this.metaEdge = false;
                    continue;
                }
                return false;
            }
            this.pointer = this.edgeIterator.next();
            if (this.metaEdge || this.nodePredicate.evaluate(this.pointer.getTarget(this.currentNode.getViewId()))) continue;
            this.pointer = null;
        }
        return true;
    }

    @Override
    public AbstractEdge next() {
        AbstractEdge e = this.pointer;
        this.pointer = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

