/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.edge.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class EdgeNodeIterator
extends AbstractEdgeIterator
implements Iterator<Edge> {
    protected AbstractNode node;
    protected int viewId;
    protected ParamAVLIterator<AbstractEdge> edgeIterator;
    protected EdgeNodeIteratorMode mode;
    protected AbstractEdge pointer;
    protected boolean undirected;
    protected Predicate<AbstractNode> nodePredicate;
    protected Predicate<AbstractEdge> edgePredicate;

    public EdgeNodeIterator(AbstractNode node, EdgeNodeIteratorMode mode, boolean undirected, Predicate<AbstractNode> nodePredicate, Predicate<AbstractEdge> edgePredicate) {
        this.node = node;
        this.mode = mode;
        this.viewId = node.getViewId();
        this.undirected = undirected;
        this.edgeIterator = new ParamAVLIterator();
        if (mode.equals((Object)EdgeNodeIteratorMode.OUT) || mode.equals((Object)EdgeNodeIteratorMode.BOTH)) {
            this.edgeIterator.setNode(node.getEdgesOutTree());
        } else {
            this.edgeIterator.setNode(node.getEdgesInTree());
        }
        this.nodePredicate = nodePredicate;
        this.edgePredicate = edgePredicate;
    }

    @Override
    public boolean hasNext() {
        while (this.pointer == null || this.undirected && this.pointer.getUndirected(this.viewId) != this.pointer) {
            if (this.mode.equals((Object)EdgeNodeIteratorMode.BOTH)) {
                boolean res = this.edgeIterator.hasNext();
                if (res) {
                    this.pointer = this.edgeIterator.next();
                    if (!this.pointer.isSelfLoop()) continue;
                    this.pointer = null;
                    continue;
                }
                this.edgeIterator.setNode(this.node.getEdgesInTree());
                this.mode = EdgeNodeIteratorMode.IN;
                continue;
            }
            if (this.edgeIterator.hasNext()) {
                this.pointer = this.edgeIterator.next();
                if (this.nodePredicate.evaluate(this.mode.equals((Object)EdgeNodeIteratorMode.IN) ? this.pointer.getSource(this.viewId) : this.pointer.getTarget(this.viewId))) continue;
                this.pointer = null;
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public AbstractEdge next() {
        AbstractEdge e = this.pointer;
        this.pointer = null;
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum EdgeNodeIteratorMode {
        OUT,
        IN,
        BOTH;

    }
}

