/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.MetaEdge;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MetaEdgeImpl;
import org.gephi.graph.dhns.edge.iterators.BiEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeAndMetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeIterator;
import org.gephi.graph.dhns.edge.iterators.EdgeNodeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeIterator;
import org.gephi.graph.dhns.edge.iterators.MetaEdgeNodeIterator;
import org.gephi.graph.dhns.edge.iterators.RangeEdgeIterator;
import org.gephi.graph.dhns.graph.HierarchicalGraphImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.NeighborIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.predicate.Tautology;

public class HierarchicalDirectedGraphImpl
extends HierarchicalGraphImpl
implements HierarchicalDirectedGraph {
    public HierarchicalDirectedGraphImpl(Dhns dhns, GraphViewImpl view) {
        super(dhns, view);
    }

    @Override
    public boolean addEdge(Edge edge) {
        AbstractEdge absEdge = this.checkEdge(edge);
        if (!edge.isDirected()) {
            throw new IllegalArgumentException("Can't add an undirected egde");
        }
        if (this.checkEdgeExist(absEdge.getSource(this.view.getViewId()), absEdge.getTarget(this.view.getViewId()))) {
            return false;
        }
        if (!absEdge.hasAttributes()) {
            absEdge.setAttributes(this.dhns.factory().newEdgeAttributes(edge.getEdgeData()));
        }
        this.view.getStructureModifier().addEdge(absEdge);
        this.dhns.touchDirected();
        return true;
    }

    @Override
    public boolean addEdge(Node source, Node target) {
        AbstractNode absTarget;
        AbstractNode absSource = this.checkNode(source);
        if (this.checkEdgeExist(absSource, absTarget = this.checkNode(target))) {
            return false;
        }
        AbstractEdge edge = this.dhns.factory().newEdge(source, target);
        this.view.getStructureModifier().addEdge(edge);
        this.dhns.touchDirected();
        return true;
    }

    @Override
    public boolean removeEdge(Edge edge) {
        AbstractEdge absEdge = this.checkEdge(edge);
        return this.view.getStructureModifier().deleteEdge(absEdge);
    }

    @Override
    public NodeIterable getSuccessors(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new NeighborIterator(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.OUT, false, this.enabledNodePredicate, Tautology.instance), absNode, Tautology.instance));
    }

    @Override
    public NodeIterable getPredecessors(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new NeighborIterator(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.IN, false, this.enabledNodePredicate, Tautology.instance), absNode, Tautology.instance));
    }

    @Override
    public boolean isSuccessor(Node node, Node successor) {
        return this.getEdge(node, successor) != null;
    }

    @Override
    public boolean isPredecessor(Node node, Node predecessor) {
        return this.getEdge(predecessor, node) != null;
    }

    @Override
    public int getInDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledInDegree();
        return count;
    }

    @Override
    public int getOutDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledOutDegree();
        return count;
    }

    @Override
    public int getMutualDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledMutualDegree();
        return count;
    }

    @Override
    public boolean contains(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        AbstractEdge absEdge = (AbstractEdge)edge;
        return this.getEdge(absEdge.getSource(this.view.getViewId()), absEdge.getTarget(this.view.getViewId())) != null;
    }

    @Override
    public EdgeIterable getEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, this.enabledNodePredicate, Tautology.instance));
    }

    @Override
    public EdgeIterable getEdgesTree() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeIterator(this.structure, new TreeIterator(this.structure, false, Tautology.instance), false, Tautology.instance, Tautology.instance));
    }

    @Override
    public EdgeIterable getInEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.IN, false, this.enabledNodePredicate, Tautology.instance));
    }

    @Override
    public EdgeIterable getOutEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.OUT, false, this.enabledNodePredicate, Tautology.instance));
    }

    @Override
    public EdgeIterable getEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false, this.enabledNodePredicate, Tautology.instance));
    }

    @Override
    public NodeIterable getNeighbors(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new NeighborIterator(new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, true, this.enabledNodePredicate, Tautology.instance), absNode, Tautology.instance));
    }

    @Override
    public Edge getEdge(Node source, Node target) {
        if (source == null || target == null) {
            return null;
        }
        AbstractNode sourceNode = this.checkNode(source);
        AbstractNode targetNode = this.checkNode(target);
        AbstractEdge res = (AbstractEdge)sourceNode.getEdgesOutTree().getItem(targetNode.getNumber());
        return res;
    }

    @Override
    public int getEdgeCount() {
        return this.view.getEdgesCountEnabled();
    }

    @Override
    public int getTotalEdgeCount() {
        return this.view.getEdgesCountEnabled() + this.view.getMetaEdgesCountTotal();
    }

    @Override
    public int getDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesInTree().getCount() + absNode.getEdgesOutTree().getCount();
        return count;
    }

    @Override
    public boolean isAdjacent(Node node1, Node node2) {
        if (node1 == node2) {
            throw new IllegalArgumentException("Nodes can't be the same");
        }
        return this.isSuccessor(node1, node2) || this.isPredecessor(node1, node2);
    }

    @Override
    public boolean isDirected(Edge edge) {
        this.checkEdgeOrMetaEdge(edge);
        return true;
    }

    @Override
    public EdgeIterable getInnerEdges(Node nodeGroup) {
        this.readLock();
        AbstractNode absNode = this.checkNode(nodeGroup);
        return this.dhns.newEdgeIterable(new RangeEdgeIterator(this.structure, this.view.getViewId(), absNode, absNode, true, false, Tautology.instance, Tautology.instance));
    }

    @Override
    public EdgeIterable getOuterEdges(Node nodeGroup) {
        this.readLock();
        AbstractNode absNode = this.checkNode(nodeGroup);
        return this.dhns.newEdgeIterable(new RangeEdgeIterator(this.structure, this.view.getViewId(), absNode, absNode, false, false, Tautology.instance, Tautology.instance));
    }

    @Override
    public EdgeIterable getMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new MetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false));
    }

    @Override
    public EdgeIterable getEdgesAndMetaEdges() {
        this.readLock();
        return this.dhns.newEdgeIterable(new EdgeAndMetaEdgeIterator(this.structure, new TreeIterator(this.structure, true, Tautology.instance), false, this.enabledNodePredicate, Tautology.instance));
    }

    @Override
    public EdgeIterable getMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false));
    }

    @Override
    public EdgeIterable getEdgesAndMetaEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        EdgeNodeIterator std = new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false, this.enabledNodePredicate, Tautology.instance);
        MetaEdgeNodeIterator meta = new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.BOTH, false);
        return this.dhns.newEdgeIterable(new BiEdgeIterator(std, meta));
    }

    @Override
    public boolean removeMetaEdge(Edge edge) {
        MetaEdgeImpl absEdge = this.checkMetaEdge(edge);
        return this.view.getStructureModifier().deleteMetaEdge(absEdge);
    }

    @Override
    public EdgeIterable getMetaInEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new MetaEdgeNodeIterator(null, absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.IN, false));
    }

    @Override
    public EdgeIterable getInEdgesAndMetaInEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        EdgeNodeIterator std = new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.IN, false, this.enabledNodePredicate, Tautology.instance);
        MetaEdgeNodeIterator meta = new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.IN, false);
        return this.dhns.newEdgeIterable(new BiEdgeIterator(std, meta));
    }

    @Override
    public EdgeIterable getMetaOutEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newEdgeIterable(new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), null, MetaEdgeNodeIterator.EdgeNodeIteratorMode.OUT, false));
    }

    @Override
    public EdgeIterable getOutEdgesAndMetaOutEdges(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        EdgeNodeIterator std = new EdgeNodeIterator(absNode, EdgeNodeIterator.EdgeNodeIteratorMode.OUT, false, this.enabledNodePredicate, Tautology.instance);
        MetaEdgeNodeIterator meta = new MetaEdgeNodeIterator(absNode.getMetaEdgesOutTree(), absNode.getMetaEdgesInTree(), MetaEdgeNodeIterator.EdgeNodeIteratorMode.OUT, false);
        return this.dhns.newEdgeIterable(new BiEdgeIterator(std, meta));
    }

    @Override
    public int getMetaInDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesInTree().getCount();
        return count;
    }

    @Override
    public int getTotalInDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledInDegree() + absNode.getMetaEdgesInTree().getCount();
        return count;
    }

    @Override
    public int getMetaOutDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    @Override
    public int getTotalOutDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEnabledOutDegree() + absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    @Override
    public int getMetaDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    @Override
    public int getTotalDegree(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = absNode.getEdgesInTree().getCount() + absNode.getEdgesOutTree().getCount() + absNode.getMetaEdgesInTree().getCount() + absNode.getMetaEdgesOutTree().getCount();
        return count;
    }

    @Override
    public MetaEdge getMetaEdge(Node source, Node target) {
        AbstractNode sourceNode = this.checkNode(source);
        AbstractNode targetNode = this.checkNode(target);
        return (MetaEdge)sourceNode.getMetaEdgesOutTree().getItem(targetNode.getNumber());
    }

    @Override
    public HierarchicalDirectedGraphImpl copy(Dhns dhns, GraphViewImpl view) {
        return new HierarchicalDirectedGraphImpl(dhns, view);
    }

    @Override
    public EdgeIterable getHierarchyEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

