/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph;

import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.ImmutableTreeNode;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.graph.AbstractGraphImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.ChildrenIterator;
import org.gephi.graph.dhns.node.iterators.DescendantIterator;
import org.gephi.graph.dhns.node.iterators.LevelIterator;
import org.gephi.graph.dhns.node.iterators.TreeIterator;
import org.gephi.graph.dhns.predicate.Predicate;
import org.gephi.graph.dhns.predicate.Tautology;
import org.gephi.graph.dhns.utils.TreeNodeWrapper;

public abstract class HierarchicalGraphImpl
extends AbstractGraphImpl
implements HierarchicalGraph {
    protected final Predicate<AbstractNode> enabledNodePredicate = new Predicate<AbstractNode>(){

        @Override
        public boolean evaluate(AbstractNode element) {
            return element.isEnabled();
        }
    };

    public HierarchicalGraphImpl(Dhns dhns, GraphViewImpl view) {
        super(dhns, view);
    }

    public abstract HierarchicalGraphImpl copy(Dhns var1, GraphViewImpl var2);

    @Override
    public boolean addNode(Node node, Node parent) {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        AbstractNode absNode = (AbstractNode)node;
        AbstractNode absParent = null;
        if (parent != null) {
            absParent = this.checkNode(parent);
        }
        if (absNode.isValid(this.view.getViewId())) {
            return false;
        }
        if (absNode.avlNode != null) {
            if (absNode.getInView(this.view.getViewId()) != null) {
                return false;
            }
            absNode = new AbstractNode(absNode.getNodeData(), this.view.getViewId());
        }
        if (!absNode.getNodeData().hasAttributes()) {
            absNode.getNodeData().setAttributes(this.dhns.factory().newNodeAttributes(absNode.getNodeData()));
        }
        this.view.getStructureModifier().addNode(absNode, absParent);
        return true;
    }

    @Override
    public boolean addNode(Node node) {
        return this.addNode(node, null);
    }

    @Override
    public boolean contains(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        AbstractNode absNode = (AbstractNode)node;
        boolean res = false;
        if (absNode.isValid(this.view.getViewId())) {
            res = this.structure.getTree().contains(absNode);
        } else if ((absNode = absNode.getInView(this.view.getViewId())) != null) {
            res = true;
        }
        return res;
    }

    @Override
    public Node getNode(int id) {
        return this.dhns.getGraphStructure().getNodeFromDictionnary(id, this.view.getViewId());
    }

    @Override
    public Edge getEdge(int id) {
        return this.dhns.getGraphStructure().getEdgeFromDictionnary(id);
    }

    @Override
    public Node getNode(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.dhns.getGraphStructure().getNodeFromDictionnary(id, this.view.getViewId());
    }

    @Override
    public Edge getEdge(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.dhns.getGraphStructure().getEdgeFromDictionnary(id);
    }

    @Override
    public NodeIterable getNodes() {
        this.readLock();
        return this.dhns.newNodeIterable(new TreeIterator(this.structure, true, Tautology.instance));
    }

    @Override
    public NodeIterable getNodesTree() {
        this.readLock();
        return this.dhns.newNodeIterable(new TreeIterator(this.structure, false, Tautology.instance));
    }

    @Override
    public int getNodeCount() {
        int count = this.view.getNodesEnabled();
        return count;
    }

    @Override
    public NodeIterable getNodes(int level) {
        this.readLock();
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            this.readUnlock();
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        return this.dhns.newNodeIterable(new LevelIterator(this.structure, level, Tautology.instance));
    }

    @Override
    public int getLevelSize(int level) {
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        int res = this.structure.getLevelSize(level);
        return res;
    }

    @Override
    public boolean isSelfLoop(Edge edge) {
        AbstractEdge absEdge = this.checkEdge(edge);
        return absEdge.getSource(this.view.getViewId()) == absEdge.getTarget(this.view.getViewId());
    }

    @Override
    public boolean isAdjacent(Edge edge1, Edge edge2) {
        if (edge1 == edge2) {
            throw new IllegalArgumentException("Edges can't be the same");
        }
        AbstractEdge absEdge1 = this.checkEdge(edge1);
        AbstractEdge absEdge2 = this.checkEdge(edge2);
        return absEdge1.getSource(this.view.getViewId()) == absEdge2.getSource(this.view.getViewId()) || absEdge1.getSource(this.view.getViewId()) == absEdge2.getTarget(this.view.getViewId()) || absEdge1.getTarget(this.view.getViewId()) == absEdge2.getSource(this.view.getViewId()) || absEdge1.getTarget(this.view.getViewId()) == absEdge2.getTarget(this.view.getViewId());
    }

    @Override
    public Node getOpposite(Node node, Edge edge) {
        this.checkNode(node);
        AbstractEdge absEdge = this.checkEdgeOrMetaEdge(edge);
        if (absEdge.getSource(this.view.getViewId()) == node) {
            return absEdge.getTarget(this.view.getViewId());
        }
        if (absEdge.getTarget(this.view.getViewId()) == node) {
            return absEdge.getSource(this.view.getViewId());
        }
        throw new IllegalArgumentException("Node must be either source or target of the edge.");
    }

    @Override
    public boolean removeNode(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().deleteNode(absNode);
        return true;
    }

    @Override
    public void clear() {
        this.view.getStructureModifier().clear();
    }

    @Override
    public void clearEdges() {
        this.view.getStructureModifier().clearEdges();
    }

    @Override
    public void clearEdges(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().clearEdges(absNode);
    }

    @Override
    public void clearMetaEdges(Node node) {
        AbstractNode absNode = this.checkNode(node);
        this.view.getStructureModifier().clearMetaEdges(absNode);
    }

    @Override
    public void setId(Node node, String id) {
        if (node == null) {
            throw new NullPointerException("node can't be null");
        }
        this.dhns.getGraphStructure().setNodeId(((AbstractNode)node).getNodeData(), id);
    }

    @Override
    public void setId(Edge edge, String id) {
        if (edge == null) {
            throw new NullPointerException("edge can't be null");
        }
        this.dhns.getGraphStructure().setEdgeId((AbstractEdge)edge, id);
    }

    @Override
    public ImmutableTreeNode wrapToTreeNode() {
        TreeNodeWrapper wrapper = new TreeNodeWrapper(this.structure);
        this.readLock();
        ImmutableTreeNode treeNode = wrapper.wrap(new TreeIterator(this.structure, false, Tautology.instance));
        this.readUnlock();
        return treeNode;
    }

    @Override
    public int getChildrenCount(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int count = 0;
        ChildrenIterator itr = new ChildrenIterator(this.structure, absNode, Tautology.instance);
        while (itr.hasNext()) {
            itr.next();
            ++count;
        }
        return count;
    }

    @Override
    public int getDescendantCount(Node node) {
        AbstractNode absNode = this.checkNode(node);
        return absNode.size;
    }

    @Override
    public Node getParent(Node node) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode parent = null;
        if (absNode.parent != this.structure.getRoot()) {
            parent = absNode.parent;
        }
        return parent;
    }

    @Override
    public NodeIterable getChildren(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new ChildrenIterator(this.structure, absNode, Tautology.instance));
    }

    @Override
    public NodeIterable getDescendant(Node node) {
        this.readLock();
        AbstractNode absNode = this.checkNode(node);
        return this.dhns.newNodeIterable(new DescendantIterator(this.structure, absNode, Tautology.instance));
    }

    @Override
    public NodeIterable getTopNodes() {
        this.readLock();
        return this.dhns.newNodeIterable(new ChildrenIterator(this.structure, Tautology.instance));
    }

    @Override
    public boolean isDescendant(Node node, Node descendant) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absDesc = this.checkNode(descendant);
        boolean res = false;
        res = absDesc.getPre() > absNode.getPre() && absDesc.getPost() < absNode.getPost();
        return res;
    }

    @Override
    public boolean isAncestor(Node node, Node ancestor) {
        return this.isDescendant(ancestor, node);
    }

    @Override
    public boolean isFollowing(Node node, Node following) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absFoll = this.checkNode(following);
        boolean res = absFoll.getPre() > absNode.getPre() && absFoll.getPost() > absNode.getPost();
        return res;
    }

    @Override
    public boolean isPreceding(Node node, Node preceding) {
        return this.isFollowing(preceding, node);
    }

    @Override
    public boolean isParent(Node node, Node parent) {
        AbstractNode absNode = this.checkNode(node);
        AbstractNode absParent = this.checkNode(parent);
        boolean res = absNode.parent == absParent;
        return res;
    }

    @Override
    public int getHeight() {
        int res = this.structure.getTreeHeight() - 1;
        return res;
    }

    @Override
    public int getLevel(Node node) {
        AbstractNode absNode = this.checkNode(node);
        int res = absNode.level - 1;
        return res;
    }

    @Override
    public void moveToGroup(Node node, Node nodeGroup) {
        AbstractNode absGroup;
        AbstractNode absNode = this.checkNode(node);
        if (this.isDescendant(absNode, absGroup = this.checkNode(nodeGroup))) {
            throw new IllegalArgumentException("nodeGroup can't be a descendant of node");
        }
        this.view.getStructureModifier().moveToGroup(absNode, absGroup);
    }

    @Override
    public void removeFromGroup(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.parent.parent == null) {
            throw new IllegalArgumentException("Node parent can't be the root of the tree");
        }
        this.view.getStructureModifier().moveToGroup(absNode, absNode.parent.parent);
    }

    @Override
    public Node groupNodes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("nodes can't be null or empty");
        }
        AbstractNode[] absNodes = new AbstractNode[nodes.length];
        AbstractNode parent = null;
        for (int i = 0; i < nodes.length; ++i) {
            AbstractNode node;
            absNodes[i] = node = this.checkNode(nodes[i]);
            if (parent == null) {
                parent = node.parent;
                continue;
            }
            if (parent == node.parent) continue;
            throw new IllegalArgumentException("All nodes must have the same parent");
        }
        Node group = this.view.getStructureModifier().group(absNodes);
        return group;
    }

    @Override
    public void ungroupNodes(Node nodeGroup) {
        AbstractNode absNode = this.checkNode(nodeGroup);
        if (absNode.size == 0) {
            throw new IllegalArgumentException("nodeGroup can't be empty");
        }
        this.view.getStructureModifier().ungroup(absNode);
    }

    @Override
    public boolean expand(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.size == 0 || !absNode.isEnabled()) {
            return false;
        }
        this.view.getStructureModifier().expand(absNode);
        return true;
    }

    @Override
    public boolean retract(Node node) {
        AbstractNode absNode = this.checkNode(node);
        if (absNode.size == 0 || absNode.isEnabled()) {
            return false;
        }
        this.view.getStructureModifier().retract(absNode);
        return true;
    }

    @Override
    public boolean isInView(Node node) {
        AbstractNode absNode = this.checkNode(node);
        boolean res = absNode.isEnabled();
        return res;
    }

    @Override
    public void resetViewToLeaves() {
        this.view.getStructureModifier().resetViewToLeaves();
    }

    @Override
    public void resetViewToLevel(int level) {
        this.readLock();
        int height = this.structure.getTreeHeight();
        if (++level > height) {
            this.readUnlock();
            throw new IllegalArgumentException("Level must be between 0 and the height of the tree, currently height=" + (height - 1));
        }
        this.readUnlock();
        this.view.getStructureModifier().resetViewToLevel(level);
    }

    @Override
    public void resetViewToTopNodes() {
        this.view.getStructureModifier().resetViewToTopNodes();
    }

    @Override
    public void flatten() {
        this.view.getStructureModifier().flatten();
    }

    @Override
    public Attributes getAttributes() {
        return this.view.getAttributes();
    }
}

