/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph.iterators;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.EdgeIterator;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.graph.iterators.EdgeIteratorImpl;
import org.gephi.graph.dhns.graph.iterators.FilteredEdgeIteratorImpl;
import org.gephi.graph.dhns.predicate.Predicate;

public class EdgeIterableImpl
implements EdgeIterable {
    private EdgeIteratorImpl iterator;

    public EdgeIterableImpl(AbstractEdgeIterator iterator, Lock lock) {
        this.iterator = new EdgeIteratorImpl(iterator, lock);
    }

    public EdgeIterableImpl(AbstractEdgeIterator iterator, Lock lock, Predicate<AbstractEdge> predicate) {
        this.iterator = new FilteredEdgeIteratorImpl(iterator, lock, predicate);
    }

    public EdgeIterableImpl(EdgeIterableImpl iterable, Predicate<AbstractEdge> predicate) {
        this(iterable.getIterator().getIterator(), iterable.getIterator().getLock(), predicate);
    }

    @Override
    public EdgeIterator iterator() {
        return this.iterator;
    }

    @Override
    public void doBreak() {
        if (this.iterator.lock != null) {
            this.iterator.lock.unlock();
        }
    }

    @Override
    public Edge[] toArray() {
        ArrayList<Edge> list = new ArrayList<Edge>();
        while (this.iterator.hasNext()) {
            list.add(this.iterator.next());
        }
        return list.toArray(new Edge[0]);
    }

    public EdgeIteratorImpl getIterator() {
        return this.iterator;
    }
}

