/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.graph.iterators;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.NodeIterator;
import org.gephi.graph.dhns.graph.iterators.FilteredNodeIteratorImpl;
import org.gephi.graph.dhns.graph.iterators.NodeIteratorImpl;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;

public class NodeIterableImpl
implements NodeIterable {
    private NodeIteratorImpl iterator;

    public NodeIterableImpl(AbstractNodeIterator iterator, Lock lock) {
        this.iterator = new NodeIteratorImpl(iterator, lock);
    }

    public NodeIterableImpl(AbstractNodeIterator iterator, Lock lock, Predicate<Node> predicate) {
        this.iterator = new FilteredNodeIteratorImpl(iterator, lock, predicate);
    }

    public NodeIterableImpl(NodeIterableImpl iterable, Predicate<Node> predicate) {
        this(iterable.getIterator().getIterator(), iterable.getIterator().getLock(), predicate);
    }

    @Override
    public NodeIterator iterator() {
        return this.iterator;
    }

    @Override
    public void doBreak() {
        if (this.iterator.lock != null) {
            this.iterator.lock.unlock();
        }
    }

    @Override
    public Node[] toArray() {
        ArrayList<Node> list = new ArrayList<Node>();
        while (this.iterator.hasNext()) {
            list.add(this.iterator.next());
        }
        return list.toArray(new Node[0]);
    }

    public NodeIteratorImpl getIterator() {
        return this.iterator;
    }
}

