/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node;

import org.gephi.data.properties.PropertiesColumn;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.GroupData;
import org.gephi.graph.api.Model;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.TextData;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.utils.avl.ViewNodeTree;
import org.gephi.graph.spi.LayoutData;

public class NodeDataImpl
implements NodeData,
GroupData {
    protected final int ID;
    protected final ViewNodeTree nodes = new ViewNodeTree();
    protected LayoutData layoutData;
    protected float x;
    protected float y;
    protected float z;
    protected float r = 0.6f;
    protected float g = 0.6f;
    protected float b = 0.6f;
    protected float alpha = 1.0f;
    protected float size = 1.0f;
    protected Model model;
    protected boolean fixed;
    protected String label;
    protected Attributes attributes;
    protected TextData textData;
    protected Model hullModel;

    public NodeDataImpl(int ID, AbstractNode rootNode) {
        if (rootNode != null) {
            this.nodes.add(rootNode);
        }
        this.ID = ID;
        this.x = (float)((0.01 + Math.random()) * 1000.0) - 500.0f;
        this.y = (float)((0.01 + Math.random()) * 1000.0) - 500.0f;
    }

    public int getID() {
        return this.ID;
    }

    public ViewNodeTree getNodes() {
        return this.nodes;
    }

    @Override
    public AbstractNode getRootNode() {
        return this.nodes.get(0);
    }

    @Override
    public Node getNode(int viewId) {
        return this.nodes.get(viewId);
    }

    public LayoutData getLayoutData() {
        return this.layoutData;
    }

    @Override
    public void setLayoutData(LayoutData layoutData) {
        this.layoutData = layoutData;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public void setX(float x) {
        this.x = x;
        this.updatePositionFlag();
    }

    @Override
    public void setY(float y) {
        this.y = y;
        this.updatePositionFlag();
    }

    @Override
    public void setZ(float z) {
        this.z = z;
        this.updatePositionFlag();
    }

    private void updatePositionFlag() {
        if (this.model != null) {
            this.model.updatePositionFlag();
        }
    }

    @Override
    public float getRadius() {
        return this.size;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public float r() {
        return this.r;
    }

    @Override
    public float g() {
        return this.g;
    }

    @Override
    public float b() {
        return this.b;
    }

    @Override
    public void setR(float r) {
        this.r = r;
    }

    @Override
    public void setG(float g) {
        this.g = g;
    }

    @Override
    public void setB(float b) {
        this.b = b;
    }

    @Override
    public void setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public void setLabel(String label) {
        if (this.attributes != null) {
            this.attributes.setValue(PropertiesColumn.NODE_LABEL.getIndex(), (Object)label);
        } else {
            this.label = label;
        }
    }

    @Override
    public float alpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model obj) {
        this.model = obj;
    }

    @Override
    public String getLabel() {
        if (this.attributes != null) {
            return (String)this.attributes.getValue(PropertiesColumn.NODE_LABEL.getIndex());
        }
        return this.label;
    }

    @Override
    public String getId() {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.getValue(PropertiesColumn.NODE_ID.getIndex());
    }

    public String setId(String id) {
        if (this.attributes == null) {
            return null;
        }
        String oldId = (String)this.attributes.getValue(PropertiesColumn.NODE_ID.getIndex());
        this.attributes.setValue(PropertiesColumn.NODE_ID.getIndex(), (Object)id);
        return oldId;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    public TextData getTextData() {
        return this.textData;
    }

    public void setTextData(TextData textData) {
        this.textData = textData;
    }

    @Override
    public Model getHullModel() {
        return this.hullModel;
    }

    @Override
    public void setHullModel(Model hullModel) {
        this.hullModel = hullModel;
    }
}

