/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.DurableTreeList;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;

public class LevelIterator
extends AbstractNodeIterator
implements Iterator<Node> {
    protected DurableTreeList treeList;
    protected int nextIndex;
    protected int diffIndex;
    protected int treeSize;
    protected DurableTreeList.DurableAVLNode currentNode;
    protected int level;
    protected Predicate<AbstractNode> predicate;

    public LevelIterator(TreeStructure treeStructure, int level, Predicate<AbstractNode> predicate) {
        this.treeList = treeStructure.getTree();
        this.nextIndex = 1;
        this.diffIndex = 2;
        this.treeSize = this.treeList.size();
        this.level = level;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        while (this.nextIndex < this.treeSize) {
            this.currentNode = this.diffIndex > 1 ? this.treeList.getNode(this.nextIndex) : this.currentNode.next();
            while (this.currentNode.getValue().level != this.level) {
                ++this.nextIndex;
                if (this.nextIndex >= this.treeSize) {
                    return false;
                }
                this.currentNode = this.currentNode.next();
            }
            if (!this.predicate.evaluate(this.currentNode.getValue())) {
                this.nextIndex = this.currentNode.getValue().getPre() + 1 + this.currentNode.getValue().size;
                this.diffIndex = this.nextIndex - this.currentNode.getValue().pre;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractNode next() {
        this.nextIndex = this.currentNode.getValue().getPre() + 1 + this.currentNode.getValue().size;
        this.diffIndex = this.nextIndex - this.currentNode.getValue().pre;
        return this.currentNode.getValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

