/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.node.iterators;

import java.util.Iterator;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.iterators.AbstractEdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.graph.dhns.predicate.Predicate;

public class NeighborIterator
extends AbstractNodeIterator
implements Iterator<Node> {
    private AbstractEdgeIterator edgeIterator;
    private AbstractNode owner;
    private AbstractNode pointer;
    private Predicate<AbstractNode> predicate;

    public NeighborIterator(AbstractEdgeIterator edgeIterator, AbstractNode owner, Predicate<AbstractNode> predicate) {
        this.edgeIterator = edgeIterator;
        this.owner = owner;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        while (this.edgeIterator.hasNext()) {
            AbstractEdge edge = this.edgeIterator.next();
            if (edge.isSelfLoop()) continue;
            AbstractNode source = edge.getSource(this.owner.getViewId());
            this.pointer = source == this.owner ? edge.getTarget(this.owner.getViewId()) : source;
            if (!this.predicate.evaluate(this.pointer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractNode next() {
        return this.pointer;
    }

    @Override
    public void remove() {
        this.edgeIterator.remove();
    }
}

