/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.utils;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphFactoryImpl;
import org.gephi.graph.dhns.core.GraphStructure;
import org.gephi.graph.dhns.core.GraphVersion;
import org.gephi.graph.dhns.core.GraphViewImpl;
import org.gephi.graph.dhns.core.IDGen;
import org.gephi.graph.dhns.core.SettingsManager;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.MixedEdgeImpl;
import org.gephi.graph.dhns.edge.ProperEdgeImpl;
import org.gephi.graph.dhns.edge.SelfLoopImpl;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.utils.collection.avl.ParamAVLIterator;

public class DHNSSerializer {
    private static final String ELEMENT_DHNS = "Dhns";
    private static final String ELEMENT_DHNS_STATUS = "Status";
    private static final String ELEMENT_EDGES = "Edges";
    private static final String ELEMENT_EDGES_PROPER = "ProperEdge";
    private static final String ELEMENT_EDGES_SELFLOOP = "SelfLoop";
    private static final String ELEMENT_EDGES_MIXED = "MixedEdge";
    private static final String ELEMENT_VIEW = "View";
    private static final String ELEMENT_VIEW_NODE = "ViewNode";
    private static final String ELEMENT_VIEW_EDGE = "ViewEdge";
    private static final String ELEMENT_TREESTRUCTURE = "TreeStructure";
    private static final String ELEMENT_TREESTRUCTURE_TREE = "Tree";
    private static final String ELEMENT_TREESTRUCTURE_NODE = "Node";
    private static final String ELEMENT_GRAPHVERSION = "GraphVersion";
    private static final String ELEMENT_SETTINGS = "Settings";
    private static final String ELEMENT_SETTINGS_PROPERTY = "Property";
    private static final String ELEMENT_IDGEN = "IDGen";

    public void writeDhns(XMLStreamWriter writer, Dhns dhns) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_DHNS);
        writer.writeStartElement(ELEMENT_DHNS_STATUS);
        writer.writeAttribute("directed", String.valueOf(dhns.isDirected()));
        writer.writeAttribute("undirected", String.valueOf(dhns.isUndirected()));
        writer.writeAttribute("mixed", String.valueOf(dhns.isMixed()));
        writer.writeAttribute("hierarchical", String.valueOf(dhns.isHierarchical()));
        writer.writeEndElement();
        this.writeIDGen(writer, dhns.getIdGen());
        this.writeSettings(writer, dhns.getSettingsManager());
        this.writeGraphVersion(writer, dhns.getGraphVersion());
        this.writeTreeStructure(writer, dhns.getGraphStructure().getMainView());
        this.writeEdges(writer, dhns.getGraphStructure().getMainView().getStructure());
        for (GraphViewImpl view : dhns.getGraphStructure().getViews()) {
            if (view == dhns.getGraphStructure().getMainView()) continue;
        }
        writer.writeEndElement();
    }

    public void readDhns(XMLStreamReader reader, Dhns dhns) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_DHNS_STATUS.equalsIgnoreCase(name)) {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String attName = reader.getAttributeName(i).getLocalPart();
                        if ("directed".equalsIgnoreCase(attName)) {
                            dhns.setDirected(Boolean.parseBoolean(reader.getAttributeValue(i)));
                            continue;
                        }
                        if ("undirected".equalsIgnoreCase(attName)) {
                            dhns.setUndirected(Boolean.parseBoolean(reader.getAttributeValue(i)));
                            continue;
                        }
                        if (!"mixed".equalsIgnoreCase(attName)) continue;
                        dhns.setMixed(Boolean.parseBoolean(reader.getAttributeValue(i)));
                    }
                    continue;
                }
                if (ELEMENT_IDGEN.equalsIgnoreCase(name)) {
                    this.readIDGen(reader, dhns.getIdGen());
                    continue;
                }
                if (ELEMENT_SETTINGS.equalsIgnoreCase(name)) {
                    this.readSettings(reader, dhns.getSettingsManager());
                    continue;
                }
                if (ELEMENT_GRAPHVERSION.equalsIgnoreCase(name)) {
                    this.readGraphVersion(reader, dhns.getGraphVersion());
                    continue;
                }
                if (ELEMENT_TREESTRUCTURE.equalsIgnoreCase(name)) {
                    this.readTreeStructure(reader, dhns.getGraphStructure(), dhns.factory());
                    continue;
                }
                if (ELEMENT_EDGES.equalsIgnoreCase(name)) {
                    this.readEdges(reader, dhns.getGraphStructure(), dhns.factory());
                    continue;
                }
                if (!ELEMENT_VIEW.equalsIgnoreCase(name)) continue;
            }
            if (!eventType.equals(2) || !ELEMENT_DHNS.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void writeEdges(XMLStreamWriter writer, TreeStructure treeStructure) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_EDGES);
        ParamAVLIterator edgeIterator = new ParamAVLIterator();
        TreeListIterator itr = new TreeListIterator(treeStructure.getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            edgeIterator.setNode(node.getEdgesOutTree());
            while (edgeIterator.hasNext()) {
                AbstractEdge edge = (AbstractEdge)edgeIterator.next();
                if (edge.isSelfLoop()) {
                    writer.writeStartElement(ELEMENT_EDGES_SELFLOOP);
                } else if (edge.isMixed()) {
                    writer.writeStartElement(ELEMENT_EDGES_MIXED);
                    writer.writeAttribute("directed", String.valueOf(edge.isDirected()));
                } else {
                    writer.writeStartElement(ELEMENT_EDGES_PROPER);
                }
                writer.writeAttribute("source", String.valueOf(edge.getSource().pre));
                writer.writeAttribute("target", String.valueOf(edge.getTarget().pre));
                writer.writeAttribute("weight", String.valueOf(edge.getWeight()));
                writer.writeAttribute("id", String.valueOf(edge.getId()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public void readEdges(XMLStreamReader reader, GraphStructure graphStructure, GraphFactoryImpl factory) throws XMLStreamException {
        TreeStructure treeStructure = graphStructure.getMainView().getStructure();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    Integer source = 0;
                    Integer target = 0;
                    Integer id = 0;
                    Boolean directed = false;
                    Float weight = Float.valueOf(0.0f);
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String attName = reader.getAttributeName(i).getLocalPart();
                        if ("id".equalsIgnoreCase(attName)) {
                            id = Integer.parseInt(reader.getAttributeValue(i));
                            continue;
                        }
                        if ("source".equalsIgnoreCase(attName)) {
                            source = Integer.parseInt(reader.getAttributeValue(i));
                            continue;
                        }
                        if ("target".equalsIgnoreCase(attName)) {
                            target = Integer.parseInt(reader.getAttributeValue(i));
                            continue;
                        }
                        if ("directed".equalsIgnoreCase(attName)) {
                            directed = Boolean.parseBoolean(reader.getAttributeValue(i));
                            continue;
                        }
                        if (!"weight".equalsIgnoreCase(attName)) continue;
                        weight = Float.valueOf(Float.parseFloat(reader.getAttributeValue(i)));
                    }
                    AbstractNode srcNode = treeStructure.getNodeAt(source);
                    AbstractNode destNode = treeStructure.getNodeAt(target);
                    AbstractEdge edge = ELEMENT_EDGES_PROPER.equalsIgnoreCase(name) ? new ProperEdgeImpl(id, srcNode, destNode) : (ELEMENT_EDGES_MIXED.equalsIgnoreCase(name) ? new MixedEdgeImpl(id, srcNode, destNode, (boolean)directed) : new SelfLoopImpl(id, srcNode));
                    edge.setWeight(weight.floatValue());
                    edge.getEdgeData().setAttributes(factory.newEdgeAttributes(edge.getEdgeData()));
                    edge.getEdgeData().setId(String.valueOf(edge.getId()));
                    edge.getEdgeData().setTextData(factory.newTextData());
                    srcNode.getEdgesOutTree().add(edge);
                    destNode.getEdgesInTree().add(edge);
                    graphStructure.addToDictionnary(edge);
                    break;
                }
                case 2: {
                    if (!ELEMENT_EDGES.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        graphStructure.getMainView().getStructureModifier().getEdgeProcessor().computeMetaEdges();
    }

    public void writeTreeStructure(XMLStreamWriter writer, GraphViewImpl view) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_TREESTRUCTURE);
        writer.writeAttribute("edgesenabled", String.valueOf(view.getEdgesCountEnabled()));
        writer.writeAttribute("edgestotal", String.valueOf(view.getEdgesCountTotal()));
        writer.writeAttribute("mutualedgesenabled", String.valueOf(view.getMutualEdgesEnabled()));
        writer.writeAttribute("mutualedgestotal", String.valueOf(view.getMutualEdgesTotal()));
        writer.writeAttribute("nodesenabled", String.valueOf(view.getNodesEnabled()));
        writer.writeStartElement(ELEMENT_TREESTRUCTURE_TREE);
        TreeListIterator itr = new TreeListIterator(view.getStructure().getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            writer.writeStartElement(ELEMENT_TREESTRUCTURE_NODE);
            writer.writeAttribute("id", String.valueOf(node.getId()));
            writer.writeAttribute("enabled", String.valueOf(node.isEnabled()));
            writer.writeAttribute("pre", String.valueOf(node.pre));
            writer.writeAttribute("parent", String.valueOf(node.parent.pre));
            writer.writeAttribute("enabledindegree", String.valueOf(node.getEnabledInDegree()));
            writer.writeAttribute("enabledoutdegree", String.valueOf(node.getEnabledOutDegree()));
            writer.writeAttribute("enabledmutualdegree", String.valueOf(node.getEnabledMutualDegree()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readTreeStructure(XMLStreamReader reader, GraphStructure graphStructure, GraphFactoryImpl factory) throws XMLStreamException {
        graphStructure.getMainView().setEdgesCountEnabled(Integer.parseInt(reader.getAttributeValue(null, "edgesenabled")));
        graphStructure.getMainView().setEdgesCountTotal(Integer.parseInt(reader.getAttributeValue(null, "edgestotal")));
        graphStructure.getMainView().setMutualEdgesEnabled(Integer.parseInt(reader.getAttributeValue(null, "mutualedgesenabled")));
        graphStructure.getMainView().setMutualEdgesTotal(Integer.parseInt(reader.getAttributeValue(null, "mutualedgestotal")));
        graphStructure.getMainView().setNodesEnabled(Integer.parseInt(reader.getAttributeValue(null, "nodesenabled")));
        TreeStructure treeStructure = graphStructure.getMainView().getStructure();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_TREESTRUCTURE_NODE.equalsIgnoreCase(name)) break;
                    Boolean enabled = Boolean.parseBoolean(reader.getAttributeValue(null, "enabled"));
                    AbstractNode parentNode = treeStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "parent")));
                    AbstractNode absNode = new AbstractNode(Integer.parseInt(reader.getAttributeValue(null, "id")), 0, 0, 0, 0, parentNode);
                    absNode.setEnabled(enabled);
                    Integer inDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledindegree"));
                    Integer outDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledoutdegree"));
                    Integer mutualDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledmutualdegree"));
                    absNode.setEnabledInDegree(inDegree);
                    absNode.setEnabledOutDegree(outDegree);
                    absNode.setEnabledMutualDegree(mutualDegree);
                    absNode.getNodeData().setAttributes(factory.newNodeAttributes(absNode.getNodeData()));
                    absNode.getNodeData().setId(String.valueOf(absNode.getId()));
                    absNode.getNodeData().setTextData(factory.newTextData());
                    treeStructure.insertAsChild(absNode, parentNode);
                    graphStructure.addToDictionnary(absNode);
                    break;
                }
                case 2: {
                    if (!ELEMENT_TREESTRUCTURE.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void writeGraphView(XMLStreamWriter writer, GraphViewImpl graphView) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_VIEW);
        writer.writeAttribute("id", String.valueOf(graphView.getViewId()));
        writer.writeAttribute("edgesenabled", String.valueOf(graphView.getEdgesCountEnabled()));
        writer.writeAttribute("edgestotal", String.valueOf(graphView.getEdgesCountTotal()));
        writer.writeAttribute("mutualedgesenabled", String.valueOf(graphView.getMutualEdgesEnabled()));
        writer.writeAttribute("mutualedgestotal", String.valueOf(graphView.getMutualEdgesTotal()));
        writer.writeAttribute("nodesenabled", String.valueOf(graphView.getNodesEnabled()));
        TreeListIterator itr = new TreeListIterator(graphView.getStructure().getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode node = itr.next();
            writer.writeStartElement(ELEMENT_VIEW_NODE);
            writer.writeAttribute("mainpre", String.valueOf(node.getInView((int)0).pre));
            writer.writeAttribute("enabled", String.valueOf(node.isEnabled()));
            writer.writeAttribute("pre", String.valueOf(node.pre));
            writer.writeAttribute("parent", String.valueOf(node.parent.pre));
            writer.writeAttribute("enabledindegree", String.valueOf(node.getEnabledInDegree()));
            writer.writeAttribute("enabledoutdegree", String.valueOf(node.getEnabledOutDegree()));
            writer.writeAttribute("enabledmutualdegree", String.valueOf(node.getEnabledMutualDegree()));
            writer.writeEndElement();
        }
        ParamAVLIterator edgeIterator = new ParamAVLIterator();
        TreeListIterator itr2 = new TreeListIterator(graphView.getStructure().getTree(), 1);
        while (itr2.hasNext()) {
            AbstractNode node = itr2.next();
            edgeIterator.setNode(node.getEdgesOutTree());
            while (edgeIterator.hasNext()) {
                AbstractEdge edge = (AbstractEdge)edgeIterator.next();
                writer.writeStartElement(ELEMENT_VIEW_EDGE);
                writer.writeAttribute("id", String.valueOf(edge.getId()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public void readGraphView(XMLStreamReader reader, GraphStructure graphStructure) throws XMLStreamException {
        GraphViewImpl graphView = graphStructure.createView(Integer.parseInt(reader.getAttributeValue(null, "id")));
        graphView.setEdgesCountEnabled(Integer.parseInt(reader.getAttributeValue(null, "edgesenabled")));
        graphView.setEdgesCountTotal(Integer.parseInt(reader.getAttributeValue(null, "edgestotal")));
        graphView.setMutualEdgesEnabled(Integer.parseInt(reader.getAttributeValue(null, "mutualedgesenabled")));
        graphView.setMutualEdgesTotal(Integer.parseInt(reader.getAttributeValue(null, "mutualedgestotal")));
        graphView.setNodesEnabled(Integer.parseInt(reader.getAttributeValue(null, "nodesenabled")));
        TreeStructure mainStructure = graphStructure.getMainView().getStructure();
        TreeStructure treeStructure = graphView.getStructure();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (ELEMENT_VIEW_NODE.equalsIgnoreCase(name)) {
                        Boolean enabled = Boolean.parseBoolean(reader.getAttributeValue(null, "enabled"));
                        AbstractNode mainNode = mainStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "mainpre")));
                        AbstractNode parentNode = treeStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "parent")));
                        AbstractNode node = new AbstractNode(mainNode.getNodeData(), graphView.getViewId(), 0, 0, 0, parentNode);
                        Integer inDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledindegree"));
                        Integer outDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledoutdegree"));
                        Integer mutualDegree = Integer.parseInt(reader.getAttributeValue(null, "enabledmutualdegree"));
                        node.setEnabledInDegree(inDegree);
                        node.setEnabledOutDegree(outDegree);
                        node.setEnabledMutualDegree(mutualDegree);
                        node.setEnabled(enabled);
                        treeStructure.insertAsChild(node, parentNode);
                        break;
                    }
                    if (!ELEMENT_VIEW_EDGE.equalsIgnoreCase(name)) break;
                    AbstractEdge edge = graphStructure.getEdgeFromDictionnary(Integer.parseInt(reader.getAttributeValue(null, "id")));
                    AbstractNode source = edge.getSource(graphView.getViewId());
                    AbstractNode target = edge.getTarget(graphView.getViewId());
                    source.getEdgesOutTree().add(edge);
                    target.getEdgesInTree().add(edge);
                    break;
                }
                case 2: {
                    if (!ELEMENT_VIEW.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        graphView.getStructureModifier().getEdgeProcessor().computeMetaEdges();
    }

    public void writeGraphVersion(XMLStreamWriter writer, GraphVersion graphVersion) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_GRAPHVERSION);
        writer.writeAttribute("node", String.valueOf(graphVersion.getNodeVersion()));
        writer.writeAttribute("edge", String.valueOf(graphVersion.getEdgeVersion()));
        writer.writeEndElement();
    }

    public void readGraphVersion(XMLStreamReader reader, GraphVersion graphVersion) {
        int nodeVersion = Integer.parseInt(reader.getAttributeValue(null, "node"));
        int edgeVersion = Integer.parseInt(reader.getAttributeValue(null, "edge"));
        graphVersion.setVersion(nodeVersion, edgeVersion);
    }

    public void writeSettings(XMLStreamWriter writer, SettingsManager settingsManager) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_SETTINGS);
        for (Map.Entry<String, Object> entry : settingsManager.getClientProperties().entrySet()) {
            writer.writeStartElement(ELEMENT_SETTINGS_PROPERTY);
            writer.writeAttribute("key", entry.getKey());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XMLEncoder xmlEncoder = new XMLEncoder(stream);
            xmlEncoder.writeObject(entry.getValue());
            xmlEncoder.close();
            writer.writeAttribute("value", stream.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readSettings(XMLStreamReader reader, SettingsManager settingsManager) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_SETTINGS_PROPERTY.equalsIgnoreCase(name)) break;
                    String key = reader.getAttributeValue(null, "key");
                    String valueXML = reader.getAttributeValue(null, "value");
                    XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(valueXML.getBytes()));
                    Object value = xmlDecoder.readObject();
                    settingsManager.putClientProperty(key, value);
                    break;
                }
                case 2: {
                    if (!ELEMENT_SETTINGS.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void writeIDGen(XMLStreamWriter writer, IDGen idGen) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_IDGEN);
        writer.writeAttribute("node", String.valueOf(idGen.getNodeGen()));
        writer.writeAttribute("edge", String.valueOf(idGen.getEdgeGen()));
        writer.writeEndElement();
    }

    public void readIDGen(XMLStreamReader reader, IDGen idGen) {
        int nodeGen = Integer.parseInt(reader.getAttributeValue(null, "node"));
        int edgeGen = Integer.parseInt(reader.getAttributeValue(null, "edge"));
        idGen.setNodeGen(nodeGen);
        idGen.setEdgeGen(edgeGen);
    }
}

