/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.utils;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.dhns.core.Dhns;
import org.gephi.graph.dhns.core.GraphStructure;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.edge.AbstractEdge;
import org.gephi.graph.dhns.edge.EdgeDataImpl;
import org.gephi.graph.dhns.edge.iterators.EdgeIterator;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.NodeDataImpl;
import org.gephi.graph.dhns.node.iterators.TreeListIterator;
import org.gephi.graph.dhns.predicate.Tautology;

public class DataSerializer {
    private static final String ELEMENT_DATA = "Data";
    private static final String ELEMENT_NODEDATA = "nodedata";
    private static final String ELEMENT_NODEDATA_POSITION = "position";
    private static final String ELEMENT_NODEDATA_COLOR = "color";
    private static final String ELEMENT_NODEDATA_SIZE = "size";
    private static final String ELEMENT_EDGEDATA = "edgedata";
    private static final String ELEMENT_EDGEDATA_COLOR = "color";

    public void writeData(XMLStreamWriter writer, Dhns dhns) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_DATA);
        TreeStructure treeStructure = dhns.getGraphStructure().getMainView().getStructure();
        TreeListIterator itr = new TreeListIterator(treeStructure.getTree(), 1);
        while (itr.hasNext()) {
            AbstractNode absNode = itr.next();
            NodeDataImpl nodeData = absNode.getNodeData();
            if (nodeData == null) continue;
            this.writeNodeData(writer, nodeData);
        }
        EdgeIterator edgeIterator = new EdgeIterator(treeStructure, new TreeListIterator(treeStructure.getTree(), 1), false, Tautology.instance, Tautology.instance);
        while (edgeIterator.hasNext()) {
            EdgeDataImpl edgeData = edgeIterator.next().getEdgeData();
            if (edgeData == null) continue;
            this.writeEdgeData(writer, edgeData);
        }
        writer.writeEndElement();
    }

    public void readData(XMLStreamReader reader, Dhns dhns) throws XMLStreamException {
        GraphStructure structure = dhns.getGraphStructure();
        TreeStructure treeStructure = structure.getMainView().getStructure();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_NODEDATA.equalsIgnoreCase(name)) {
                    AbstractNode node = treeStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "nodepre")));
                    NodeDataImpl nodeDataImpl = node.getNodeData();
                    this.readNodeData(reader, nodeDataImpl, structure);
                    continue;
                }
                if (!ELEMENT_EDGEDATA.equalsIgnoreCase(name)) continue;
                AbstractNode source = treeStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "sourcepre")));
                AbstractNode target = treeStructure.getNodeAt(Integer.parseInt(reader.getAttributeValue(null, "targetpre")));
                AbstractEdge edge = (AbstractEdge)source.getEdgesOutTree().getItem(target.getId());
                EdgeDataImpl edgeDataImpl = edge.getEdgeData();
                this.readEdgeData(reader, edgeDataImpl, structure);
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_DATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void writeNodeData(XMLStreamWriter writer, NodeDataImpl nodeData) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_NODEDATA);
        AbstractNode node = nodeData.getRootNode();
        writer.writeAttribute("nodepre", String.valueOf(node.getPre()));
        if (nodeData.getId() != null && !nodeData.getId().equals(String.valueOf(node.getId()))) {
            writer.writeAttribute("id", nodeData.getId());
        }
        writer.writeStartElement(ELEMENT_NODEDATA_POSITION);
        writer.writeAttribute("x", String.valueOf(nodeData.x()));
        writer.writeAttribute("y", String.valueOf(nodeData.y()));
        writer.writeAttribute("z", String.valueOf(nodeData.z()));
        writer.writeEndElement();
        writer.writeStartElement("color");
        writer.writeAttribute("r", String.valueOf(nodeData.r()));
        writer.writeAttribute("g", String.valueOf(nodeData.g()));
        writer.writeAttribute("b", String.valueOf(nodeData.b()));
        writer.writeAttribute("a", String.valueOf(nodeData.alpha()));
        writer.writeEndElement();
        writer.writeStartElement(ELEMENT_NODEDATA_SIZE);
        writer.writeAttribute("value", String.valueOf(nodeData.getSize()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readNodeData(XMLStreamReader reader, NodeData nodeData, GraphStructure structure) throws XMLStreamException {
        if (reader.getAttributeValue(null, "id") != null) {
            structure.setNodeId((NodeDataImpl)nodeData, reader.getAttributeValue(null, "id"));
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (ELEMENT_NODEDATA_POSITION.equalsIgnoreCase(name)) {
                    nodeData.setX(Float.parseFloat(reader.getAttributeValue(null, "x")));
                    nodeData.setY(Float.parseFloat(reader.getAttributeValue(null, "y")));
                    nodeData.setZ(Float.parseFloat(reader.getAttributeValue(null, "z")));
                    continue;
                }
                if ("color".equalsIgnoreCase(name)) {
                    nodeData.setR(Float.parseFloat(reader.getAttributeValue(null, "r")));
                    nodeData.setG(Float.parseFloat(reader.getAttributeValue(null, "g")));
                    nodeData.setB(Float.parseFloat(reader.getAttributeValue(null, "b")));
                    nodeData.setAlpha(Float.parseFloat(reader.getAttributeValue(null, "a")));
                    continue;
                }
                if (!ELEMENT_NODEDATA_SIZE.equalsIgnoreCase(name)) continue;
                nodeData.setSize(Float.parseFloat(reader.getAttributeValue(0)));
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_NODEDATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    public void writeEdgeData(XMLStreamWriter writer, EdgeDataImpl edgeData) throws XMLStreamException {
        writer.writeStartElement(ELEMENT_EDGEDATA);
        AbstractEdge edge = edgeData.getEdge();
        writer.writeAttribute("sourcepre", String.valueOf(edge.getSource().getPre()));
        writer.writeAttribute("targetpre", String.valueOf(edge.getTarget().getPre()));
        if (edgeData.getId() != null && !edgeData.getId().equals(String.valueOf(edge.getId()))) {
            writer.writeAttribute("id", edgeData.getId());
        }
        writer.writeStartElement("color");
        writer.writeAttribute("r", String.valueOf(edgeData.r()));
        writer.writeAttribute("g", String.valueOf(edgeData.g()));
        writer.writeAttribute("b", String.valueOf(edgeData.b()));
        writer.writeAttribute("a", String.valueOf(edgeData.alpha()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readEdgeData(XMLStreamReader reader, EdgeData edgeData, GraphStructure structure) throws XMLStreamException {
        if (reader.getAttributeValue(null, "id") != null) {
            structure.setEdgeId((AbstractEdge)edgeData.getEdge(), reader.getAttributeValue(null, "id"));
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (!"color".equalsIgnoreCase(name)) continue;
                edgeData.setR(Float.parseFloat(reader.getAttributeValue(null, "r")));
                edgeData.setG(Float.parseFloat(reader.getAttributeValue(null, "g")));
                edgeData.setB(Float.parseFloat(reader.getAttributeValue(null, "b")));
                edgeData.setAlpha(Float.parseFloat(reader.getAttributeValue(null, "a")));
                continue;
            }
            if (!eventType.equals(2) || !ELEMENT_EDGEDATA.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }
}

