/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.dhns.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.gephi.graph.api.ImmutableTreeNode;
import org.gephi.graph.api.Node;
import org.gephi.graph.dhns.core.TreeStructure;
import org.gephi.graph.dhns.node.AbstractNode;
import org.gephi.graph.dhns.node.iterators.AbstractNodeIterator;
import org.gephi.utils.collection.avl.AVLItem;
import org.gephi.utils.collection.avl.SimpleAVLTree;

public class TreeNodeWrapper {
    private SimpleAVLTree nodeTree;
    private TreeStructure treeStructure;

    public TreeNodeWrapper(TreeStructure treeStructure) {
        this.treeStructure = treeStructure;
    }

    public ImmutableTreeNode wrap(AbstractNodeIterator iterator) {
        this.nodeTree = new SimpleAVLTree();
        TreeNodeImpl root = new TreeNodeImpl(this.treeStructure.getRoot());
        this.nodeTree.add(root);
        while (iterator.hasNext()) {
            AbstractNode node = iterator.next();
            TreeNodeImpl n = new TreeNodeImpl(node);
            if (node.parent != null) {
                TreeNodeImpl parent = (TreeNodeImpl)this.nodeTree.get(node.parent.getNumber());
                if (parent != null) {
                    n.parent = parent;
                    parent.children.add(n);
                } else {
                    n.parent = root;
                    root.children.add(n);
                }
            }
            this.nodeTree.add(n);
        }
        for (AVLItem item : this.nodeTree) {
            TreeNodeImpl node = (TreeNodeImpl)item;
            node.toArray();
        }
        return root;
    }

    private static class IteratorEnumeration
    implements Enumeration {
        Object[] array;
        int index = 0;

        public IteratorEnumeration(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.array.length;
        }

        public Object nextElement() {
            return this.array[this.index++];
        }
    }

    private static class TreeNodeImpl
    implements ImmutableTreeNode,
    AVLItem {
        private TreeNodeImpl parent;
        private AbstractNode node;
        private List<TreeNodeImpl> children;
        private TreeNodeImpl[] childrenArray;

        public TreeNodeImpl(AbstractNode node) {
            this.node = node;
            this.children = new ArrayList<TreeNodeImpl>();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.childrenArray[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.childrenArray.length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.childrenArray.length; ++i) {
                if (this.childrenArray[i] != node) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return this.childrenArray == null;
        }

        public Enumeration children() {
            return new IteratorEnumeration(this.childrenArray);
        }

        @Override
        public int getNumber() {
            return this.node.getNumber();
        }

        public void toArray() {
            if (!this.children.isEmpty()) {
                this.childrenArray = this.children.toArray(new TreeNodeImpl[0]);
            }
            this.children = null;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

