/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;

public class ProjectInformationImpl
implements ProjectInformation {
    private static int count = 0;
    private String name;
    private Status status = Status.CLOSED;
    private File file;
    private Project project;
    private transient List<ChangeListener> listeners;

    public ProjectInformationImpl(Project project) {
        this.project = project;
        this.name = "Project " + count++;
        this.init();
    }

    public void init() {
        this.listeners = new ArrayList<ChangeListener>();
        this.status = Status.CLOSED;
        if (this.file != null) {
            // empty if block
        }
    }

    public void open() {
        this.status = Status.OPEN;
        this.fireChangeEvent();
    }

    public void close() {
        this.status = Status.CLOSED;
        this.fireChangeEvent();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public boolean isInvalid() {
        return this.status == Status.INVALID;
    }

    @Override
    public boolean hasFile() {
        return this.file != null;
    }

    @Override
    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    public void setName(String name) {
        this.name = name;
        this.fireChangeEvent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.fireChangeEvent();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public static enum Status {
        NEW,
        OPEN,
        CLOSED,
        INVALID;

    }
}

