/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.Project;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.workspace.impl.WorkspaceImpl;

public class WorkspaceProviderImpl
implements WorkspaceProvider {
    private transient WorkspaceImpl currentWorkspace;
    private transient Project project;
    private transient List<Workspace> workspaces;

    public WorkspaceProviderImpl(Project project) {
        this.init(project);
    }

    public void init(Project project) {
        this.project = project;
        this.workspaces = new ArrayList<Workspace>();
    }

    public WorkspaceImpl newWorkspace() {
        WorkspaceImpl workspace = new WorkspaceImpl(this.project);
        this.workspaces.add(workspace);
        return workspace;
    }

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public void removeWorkspace(Workspace workspace) {
        this.workspaces.remove(workspace);
    }

    public Workspace getPrecedingWorkspace(Workspace workspace) {
        Workspace[] ws = this.getWorkspaces();
        int index = -1;
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i] != workspace) continue;
            index = i;
        }
        if (index != -1 && index >= 1) {
            return ws[index - 1];
        }
        if (index == 0 && ws.length > 1) {
            return ws[1];
        }
        return null;
    }

    @Override
    public WorkspaceImpl getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    @Override
    public Workspace[] getWorkspaces() {
        return this.workspaces.toArray(new Workspace[0]);
    }

    public void setCurrentWorkspace(Workspace currentWorkspace) {
        this.currentWorkspace = (WorkspaceImpl)currentWorkspace;
    }

    @Override
    public boolean hasCurrentWorkspace() {
        return this.currentWorkspace != null;
    }
}

