/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.gephi.project.api.Project;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectControllerImpl;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.gephi.workspace.impl.WorkspaceImpl;
import org.gephi.workspace.impl.WorkspaceInformationImpl;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public class GephiReader
implements Cancellable {
    private ProjectImpl project;
    private boolean cancel = false;
    private Map<String, WorkspacePersistenceProvider> providers = new LinkedHashMap<String, WorkspacePersistenceProvider>();
    private WorkspacePersistenceProvider currentProvider;

    public GephiReader() {
        for (WorkspacePersistenceProvider w : Lookup.getDefault().lookupAll(WorkspacePersistenceProvider.class)) {
            try {
                String id = w.getIdentifier();
                if (id == null || id.isEmpty()) continue;
                this.providers.put(w.getIdentifier(), w);
            }
            catch (Exception exception) {}
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public Project readAll(XMLStreamReader reader, Project project) throws Exception {
        ProjectInformationImpl info = (ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class);
        WorkspaceProviderImpl workspaces = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
        this.project = (ProjectImpl)project;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                Workspace workspace;
                String name = reader.getLocalName();
                if ("gephiFile".equalsIgnoreCase(name)) {
                    String version = reader.getAttributeValue(null, "version");
                    if (version != null && !version.isEmpty() && !(Double.parseDouble(version) < 0.7)) continue;
                    throw new GephiFormatException("Gephi project file version must be at least 0.7");
                }
                if ("project".equalsIgnoreCase(name)) {
                    info.setName(reader.getAttributeValue(null, "name"));
                    continue;
                }
                if (!"workspace".equalsIgnoreCase(name) || !((WorkspaceInformationImpl)(workspace = this.readWorkspace(reader)).getLookup().lookup(WorkspaceInformationImpl.class)).isOpen()) continue;
                workspaces.setCurrentWorkspace(workspace);
                continue;
            }
            if (!eventType.equals(2) || !"project".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        return project;
    }

    public Workspace readWorkspace(XMLStreamReader reader) throws Exception {
        WorkspaceImpl workspace = ((WorkspaceProviderImpl)this.project.getLookup().lookup(WorkspaceProviderImpl.class)).newWorkspace();
        WorkspaceInformationImpl info = (WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class);
        info.setName(reader.getAttributeValue(null, "name"));
        String workspaceStatus = reader.getAttributeValue(null, "status");
        if (workspaceStatus.equals("open")) {
            info.open();
        } else if (workspaceStatus.equals("closed")) {
            info.close();
        } else {
            info.invalid();
        }
        ProjectControllerImpl pc = (ProjectControllerImpl)Lookup.getDefault().lookup(ProjectControllerImpl.class);
        pc.setTemporaryOpeningWorkspace(workspace);
        this.readWorkspaceChildren(workspace, reader);
        if (this.currentProvider != null) {
            throw new GephiFormatException("The '" + this.currentProvider.getIdentifier() + "' persistence provider is not ending read.");
        }
        pc.setTemporaryOpeningWorkspace(null);
        return workspace;
    }

    public void readWorkspaceChildren(Workspace workspace, XMLStreamReader reader) throws Exception {
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                WorkspacePersistenceProvider pp = this.providers.get(name);
                if (pp == null) continue;
                this.currentProvider = pp;
                try {
                    pp.readXML(reader, workspace);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            if (!eventType.equals(2) || !"workspace".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
            this.currentProvider = null;
        }
    }
}

