/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;
import org.gephi.project.api.ProjectMetaData;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public class GephiWriter
implements Cancellable {
    private int tasks = 0;
    private Map<String, WorkspacePersistenceProvider> providers = new LinkedHashMap<String, WorkspacePersistenceProvider>();

    public GephiWriter() {
        for (WorkspacePersistenceProvider w : Lookup.getDefault().lookupAll(WorkspacePersistenceProvider.class)) {
            try {
                String id = w.getIdentifier();
                if (id == null || id.isEmpty()) continue;
                this.providers.put(w.getIdentifier(), w);
            }
            catch (Exception exception) {}
        }
    }

    public void writeAll(Project project, XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("gephiFile");
        writer.writeAttribute("version", "0.8");
        writer.writeComment("File saved from Gephi 0.8.1");
        this.writeCore(writer);
        this.writeProject(writer, project);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void writeCore(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("core");
        writer.writeAttribute("tasks", String.valueOf(this.tasks));
        writer.writeStartElement("lastModifiedDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        writer.writeCharacters(sdf.format(cal.getTime()));
        writer.writeComment("yyyy-MM-dd HH:mm:ss");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void writeProject(XMLStreamWriter writer, Project project) throws Exception {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        ProjectMetaData metaData = (ProjectMetaData)project.getLookup().lookup(ProjectMetaData.class);
        WorkspaceProviderImpl workspaces = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
        writer.writeStartElement("project");
        writer.writeAttribute("name", info.getName());
        writer.writeStartElement("metadata");
        writer.writeStartElement("title");
        writer.writeCharacters(metaData.getTitle());
        writer.writeEndElement();
        writer.writeStartElement("keywords");
        writer.writeCharacters(metaData.getKeywords());
        writer.writeEndElement();
        writer.writeStartElement("description");
        writer.writeCharacters(metaData.getDescription());
        writer.writeEndElement();
        writer.writeStartElement("author");
        writer.writeCharacters(metaData.getAuthor());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("workspaces");
        for (Workspace ws : workspaces.getWorkspaces()) {
            this.writeWorkspace(writer, ws);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void writeWorkspace(XMLStreamWriter writer, Workspace workspace) throws Exception {
        WorkspaceInformation info = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        writer.writeStartElement("workspace");
        writer.writeAttribute("name", info.getName());
        if (info.isOpen()) {
            writer.writeAttribute("status", "open");
        } else if (info.isClosed()) {
            writer.writeAttribute("status", "closed");
        } else {
            writer.writeAttribute("status", "invalid");
        }
        this.writeWorkspaceChildren(writer, workspace);
        writer.writeEndElement();
    }

    public void writeWorkspaceChildren(XMLStreamWriter writer, Workspace workspace) throws Exception {
        for (WorkspacePersistenceProvider pp : this.providers.values()) {
            try {
                writer.writeComment("Persistence from " + pp.getClass().getName());
                pp.writeXML(writer, workspace);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public boolean cancel() {
        return true;
    }
}

