/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.type.Interval;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicGraph;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.statistics.StatisticsModelImpl;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.api.StatisticsModel;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class StatisticsControllerImpl
implements StatisticsController {
    private final StatisticsBuilder[] statisticsBuilders = Lookup.getDefault().lookupAll(StatisticsBuilder.class).toArray(new StatisticsBuilder[0]);
    private StatisticsModelImpl model;

    public StatisticsControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            @Override
            public void initialize(Workspace workspace) {
                workspace.add(new StatisticsModelImpl());
            }

            @Override
            public void select(Workspace workspace) {
                StatisticsControllerImpl.this.model = (StatisticsModelImpl)workspace.getLookup().lookup(StatisticsModelImpl.class);
                if (StatisticsControllerImpl.this.model == null) {
                    StatisticsControllerImpl.this.model = new StatisticsModelImpl();
                    workspace.add(StatisticsControllerImpl.this.model);
                }
            }

            @Override
            public void unselect(Workspace workspace) {
            }

            @Override
            public void close(Workspace workspace) {
            }

            @Override
            public void disable() {
                StatisticsControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (StatisticsModelImpl)pc.getCurrentWorkspace().getLookup().lookup(StatisticsModelImpl.class);
            if (this.model == null) {
                this.model = new StatisticsModelImpl();
                pc.getCurrentWorkspace().add(this.model);
            }
        }
    }

    @Override
    public void execute(final Statistics statistics, LongTaskListener listener) {
        StatisticsBuilder builder = this.getBuilder(statistics.getClass());
        LongTaskExecutor executor = new LongTaskExecutor(true, "Statistics " + builder.getName(), 10);
        if (listener != null) {
            executor.setLongTaskListener(listener);
        }
        if (statistics instanceof DynamicStatistics) {
            final DynamicLongTask dynamicLongTask = new DynamicLongTask((DynamicStatistics)statistics);
            executor.execute(dynamicLongTask, new Runnable(){

                @Override
                public void run() {
                    StatisticsControllerImpl.this.executeDynamic((DynamicStatistics)statistics, dynamicLongTask);
                }
            }, builder.getName(), null);
        } else {
            LongTask task = statistics instanceof LongTask ? (LongTask)((Object)statistics) : null;
            executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    StatisticsControllerImpl.this.execute(statistics);
                }
            }, builder.getName(), null);
        }
    }

    @Override
    public void execute(Statistics statistics) {
        if (statistics instanceof DynamicStatistics) {
            this.executeDynamic((DynamicStatistics)statistics, null);
        } else {
            GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
            GraphModel graphModel = graphController.getModel();
            AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
            statistics.execute(graphModel, attributeModel);
            this.model.addReport(statistics);
        }
    }

    private void executeDynamic(DynamicStatistics statistics, DynamicLongTask dynamicLongTask) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getModel();
        AttributeController attributeController = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
        DynamicModel dynamicModel = dynamicController.getModel();
        AttributeModel attributeModel = attributeController.getModel();
        if (!dynamicModel.isDynamicGraph()) {
            throw new IllegalArgumentException("The current graph must be a dynamic graph");
        }
        double window = statistics.getWindow();
        double tick = statistics.getTick();
        Interval bounds = statistics.getBounds();
        if (bounds == null) {
            double high;
            TimeInterval visibleInterval = dynamicModel.getVisibleInterval();
            double low = visibleInterval.getLow();
            if (Double.isInfinite(low)) {
                low = dynamicModel.getMin();
            }
            if (Double.isInfinite(high = visibleInterval.getHigh())) {
                high = dynamicModel.getMax();
            }
            bounds = new Interval(low, high);
            statistics.setBounds(bounds);
        }
        if (dynamicLongTask != null) {
            int c = (int)((bounds.getHigh() - window - bounds.getLow()) / tick);
            dynamicLongTask.start(c);
        }
        HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
        DynamicGraph dynamicGraph = dynamicModel.createDynamicGraph(graph, bounds);
        statistics.execute(graphModel, attributeModel);
        for (double low = bounds.getLow(); low <= bounds.getHigh() - window; low += tick) {
            double high = low + window;
            Graph g = dynamicGraph.getSnapshotGraph(low, high);
            statistics.loop(g.getView(), new Interval(low, high));
            if (dynamicLongTask != null && dynamicLongTask.isCancelled()) {
                return;
            }
            if (dynamicLongTask == null) continue;
            dynamicLongTask.progress();
        }
        statistics.end();
        this.model.addReport(statistics);
    }

    @Override
    public StatisticsBuilder getBuilder(Class<? extends Statistics> statisticsClass) {
        for (StatisticsBuilder b : this.statisticsBuilders) {
            if (!b.getStatisticsClass().equals(statisticsClass)) continue;
            return b;
        }
        return null;
    }

    @Override
    public StatisticsModelImpl getModel() {
        return this.model;
    }

    @Override
    public StatisticsModel getModel(Workspace workspace) {
        StatisticsModel statModel = (StatisticsModel)workspace.getLookup().lookup(StatisticsModelImpl.class);
        if (statModel == null) {
            statModel = new StatisticsModelImpl();
            workspace.add(statModel);
        }
        return statModel;
    }

    private static class DynamicLongTask
    implements LongTask {
        private ProgressTicket progressTicket;
        private boolean cancel = false;
        private final LongTask longTask;

        public DynamicLongTask(DynamicStatistics statistics) {
            this.longTask = statistics instanceof LongTask ? (LongTask)((Object)statistics) : null;
        }

        @Override
        public boolean cancel() {
            this.cancel = true;
            if (this.longTask != null) {
                this.longTask.cancel();
            }
            return true;
        }

        @Override
        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
        }

        public void start(int iterations) {
            Progress.start(this.progressTicket, iterations);
        }

        public void progress() {
            Progress.progress(this.progressTicket);
        }

        public boolean isCancelled() {
            return this.cancel;
        }
    }
}

