/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.statistics.api.StatisticsModel;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.statistics.spi.StatisticsUI;
import org.openide.util.Lookup;

public class StatisticsModelImpl
implements StatisticsModel {
    private final Map<Class, String> reportMap = new HashMap<Class, String>();

    public void addReport(Statistics statistics) {
        this.reportMap.put(statistics.getClass(), statistics.getReport());
    }

    @Override
    public String getReport(Class<? extends Statistics> statisticsClass) {
        return this.reportMap.get(statisticsClass);
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("statisticsmodel");
        writer.writeStartElement("reports");
        for (Map.Entry<Class, String> entry : this.reportMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            writer.writeStartElement("report");
            String report = entry.getValue();
            writer.writeAttribute("class", entry.getKey().getName());
            writer.writeAttribute("value", report);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public void readXML(XMLStreamReader reader) throws XMLStreamException {
        Collection uis = Lookup.getDefault().lookupAll(StatisticsUI.class);
        Collection builders = Lookup.getDefault().lookupAll(StatisticsBuilder.class);
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!"report".equalsIgnoreCase(name)) break;
                    String classStr = reader.getAttributeValue(null, "class");
                    Class<? extends Statistics> reportClass = null;
                    for (StatisticsBuilder builder : builders) {
                        if (!builder.getStatisticsClass().getName().equals(classStr)) continue;
                        reportClass = builder.getStatisticsClass();
                    }
                    if (reportClass == null) continue block4;
                    String report = reader.getAttributeValue(null, "value");
                    report = this.unembedImages(report);
                    this.reportMap.put(reportClass, report);
                    break;
                }
                case 2: {
                    if (!"statisticsmodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    private String unembedImages(String report) {
        throw new IllegalStateException();
    }
}

