/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.collection.avl;

import java.util.Iterator;
import org.gephi.utils.collection.avl.ParamAVLNode;
import org.gephi.utils.collection.avl.ParamAVLTree;

public class BiParamAVLIterator<Item>
implements Iterator<Item> {
    private ParamAVLTree tree2;
    private ParamAVLTree currentTree;
    private ParamAVLNode<Item> next;
    private Item current;

    public BiParamAVLIterator(ParamAVLTree tree1, ParamAVLTree tree2) {
        if (tree1 == null) {
            this.currentTree = tree2;
        } else {
            this.currentTree = tree1;
            this.tree2 = tree2;
        }
        if (this.currentTree != null) {
            this.next = this.currentTree.root;
        }
        this.goToDownLeft();
    }

    private void goToDownLeft() {
        if (this.next != null) {
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            if (this.tree2 != null && this.currentTree != this.tree2) {
                this.currentTree = this.tree2;
                this.next = this.currentTree.root;
                if (this.next == null) {
                    return false;
                }
                this.goToDownLeft();
            } else {
                return false;
            }
        }
        this.current = this.next.item;
        if (this.next.right == null) {
            while (this.next.parent != null && this.next == this.next.parent.right) {
                this.next = this.next.parent;
            }
            this.next = this.next.parent;
        } else {
            this.next = this.next.right;
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        }
        return true;
    }

    @Override
    public Item next() {
        return this.current;
    }

    @Override
    public void remove() {
        this.currentTree.remove(this.current);
    }
}

