/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.collection.avl;

import java.util.Iterator;
import org.gephi.utils.collection.avl.AVLItem;
import org.gephi.utils.collection.avl.ResetableIterator;

public class MonoAVLTree
implements Iterable<AVLItem> {
    protected MonoAVLNode root;
    protected int count;
    protected MonoAVLIterator iterator = new MonoAVLIterator();

    public boolean add(AVLItem item) {
        block40: {
            MonoAVLNode p;
            block37: {
                block38: {
                    block39: {
                        p = this.root;
                        if (p != null) break block39;
                        this.root = new MonoAVLNode(item);
                        break block40;
                    }
                    while (true) {
                        int c;
                        if ((c = item.getNumber() - p.item.getNumber()) < 0) {
                            if (p.left != null) {
                                p = p.left;
                                continue;
                            }
                            p.left = new MonoAVLNode(item, p);
                            --p.balance;
                            break block37;
                        }
                        if (c <= 0) break block38;
                        if (p.right == null) break;
                        p = p.right;
                    }
                    p.right = new MonoAVLNode(item, p);
                    ++p.balance;
                    break block37;
                }
                return false;
            }
            while (p.balance != 0 && p.parent != null) {
                p.parent.balance = p.parent.left == p ? --p.parent.balance : ++p.parent.balance;
                p = p.parent;
                if (p.balance == -2) {
                    MonoAVLNode x = p.left;
                    if (x.balance == -1) {
                        x.parent = p.parent;
                        if (p.parent == null) {
                            this.root = x;
                        } else if (p.parent.left == p) {
                            p.parent.left = x;
                        } else {
                            p.parent.right = x;
                        }
                        p.left = x.right;
                        if (p.left != null) {
                            p.left.parent = p;
                        }
                        x.right = p;
                        p.parent = x;
                        x.balance = 0;
                        p.balance = 0;
                        break;
                    }
                    MonoAVLNode w = x.right;
                    w.parent = p.parent;
                    if (p.parent == null) {
                        this.root = w;
                    } else if (p.parent.left == p) {
                        p.parent.left = w;
                    } else {
                        p.parent.right = w;
                    }
                    x.right = w.left;
                    if (x.right != null) {
                        x.right.parent = x;
                    }
                    p.left = w.right;
                    if (p.left != null) {
                        p.left.parent = p;
                    }
                    w.left = x;
                    w.right = p;
                    x.parent = w;
                    p.parent = w;
                    if (w.balance == -1) {
                        x.balance = 0;
                        p.balance = 1;
                    } else if (w.balance == 0) {
                        x.balance = 0;
                        p.balance = 0;
                    } else {
                        x.balance = -1;
                        p.balance = 0;
                    }
                    w.balance = 0;
                    break;
                }
                if (p.balance != 2) continue;
                MonoAVLNode x = p.right;
                if (x.balance == 1) {
                    x.parent = p.parent;
                    if (p.parent == null) {
                        this.root = x;
                    } else if (p.parent.left == p) {
                        p.parent.left = x;
                    } else {
                        p.parent.right = x;
                    }
                    p.right = x.left;
                    if (p.right != null) {
                        p.right.parent = p;
                    }
                    x.left = p;
                    p.parent = x;
                    x.balance = 0;
                    p.balance = 0;
                    break;
                }
                MonoAVLNode w = x.left;
                w.parent = p.parent;
                if (p.parent == null) {
                    this.root = w;
                } else if (p.parent.left == p) {
                    p.parent.left = w;
                } else {
                    p.parent.right = w;
                }
                x.left = w.right;
                if (x.left != null) {
                    x.left.parent = x;
                }
                p.right = w.left;
                if (p.right != null) {
                    p.right.parent = p;
                }
                w.right = x;
                w.left = p;
                x.parent = w;
                p.parent = w;
                if (w.balance == 1) {
                    x.balance = 0;
                    p.balance = -1;
                } else if (w.balance == 0) {
                    x.balance = 0;
                    p.balance = 0;
                } else {
                    x.balance = 1;
                    p.balance = 0;
                }
                w.balance = 0;
                break;
            }
        }
        ++this.count;
        return true;
    }

    public boolean remove(AVLItem item) {
        return this.remove(item.getNumber());
    }

    public boolean remove(int number) {
        MonoAVLNode p = this.root;
        while (p != null) {
            MonoAVLNode y;
            int c = number - p.item.getNumber();
            if (c < 0) {
                p = p.left;
                continue;
            }
            if (c > 0) {
                p = p.right;
                continue;
            }
            int choice = 0;
            if (p.right == null) {
                if (p.left != null) {
                    p.left.parent = p.parent;
                }
                if (p.parent == null) {
                    this.root = p.left;
                    --this.count;
                    return true;
                }
                if (p == p.parent.left) {
                    p.parent.left = p.left;
                    y = p.parent;
                    choice = 1;
                } else {
                    p.parent.right = p.left;
                    y = p.parent;
                    choice = 2;
                }
            } else if (p.right.left == null) {
                if (p.left != null) {
                    p.left.parent = p.right;
                    p.right.left = p.left;
                }
                p.right.balance = p.balance;
                p.right.parent = p.parent;
                if (p.parent == null) {
                    this.root = p.right;
                } else if (p == p.parent.left) {
                    p.parent.left = p.right;
                } else {
                    p.parent.right = p.right;
                }
                y = p.right;
                choice = 2;
            } else {
                MonoAVLNode s = p.right.left;
                while (s.left != null) {
                    s = s.left;
                }
                if (p.left != null) {
                    p.left.parent = s;
                    s.left = p.left;
                }
                s.parent.left = s.right;
                if (s.right != null) {
                    s.right.parent = s.parent;
                }
                p.right.parent = s;
                s.right = p.right;
                y = s.parent;
                s.balance = p.balance;
                s.parent = p.parent;
                if (p.parent == null) {
                    this.root = s;
                } else if (p == p.parent.left) {
                    p.parent.left = s;
                } else {
                    p.parent.right = s;
                }
                choice = 1;
            }
            while (choice != 0) {
                MonoAVLNode w;
                MonoAVLNode x;
                if (choice == 1) {
                    ++y.balance;
                    if (y.balance == 1) {
                        choice = 0;
                    } else if (y.balance == 2) {
                        x = y.right;
                        if (x.balance == -1) {
                            w = x.left;
                            w.parent = y.parent;
                            if (y.parent == null) {
                                this.root = w;
                            } else if (y.parent.left == y) {
                                y.parent.left = w;
                            } else {
                                y.parent.right = w;
                            }
                            x.left = w.right;
                            if (x.left != null) {
                                x.left.parent = x;
                            }
                            y.right = w.left;
                            if (y.right != null) {
                                y.right.parent = y;
                            }
                            w.right = x;
                            w.left = y;
                            x.parent = w;
                            y.parent = w;
                            if (w.balance == 1) {
                                x.balance = 0;
                                y.balance = -1;
                            } else if (w.balance == 0) {
                                x.balance = 0;
                                y.balance = 0;
                            } else {
                                x.balance = 1;
                                y.balance = 0;
                            }
                            w.balance = 0;
                            y = w;
                        } else {
                            x.parent = y.parent;
                            if (y.parent != null) {
                                if (y.parent.left == y) {
                                    y.parent.left = x;
                                } else {
                                    y.parent.right = x;
                                }
                            } else {
                                this.root = x;
                            }
                            y.right = x.left;
                            if (y.right != null) {
                                y.right.parent = y;
                            }
                            x.left = y;
                            y.parent = x;
                            if (x.balance == 0) {
                                x.balance = -1;
                                y.balance = 1;
                                choice = 0;
                            } else {
                                x.balance = 0;
                                y.balance = 0;
                                y = x;
                            }
                        }
                    }
                } else if (choice == 2) {
                    --y.balance;
                    if (y.balance == -1) {
                        choice = 0;
                    } else if (y.balance == -2) {
                        x = y.left;
                        if (x.balance == 1) {
                            w = x.right;
                            w.parent = y.parent;
                            if (y.parent == null) {
                                this.root = w;
                            } else if (y.parent.left == y) {
                                y.parent.left = w;
                            } else {
                                y.parent.right = w;
                            }
                            x.right = w.left;
                            if (x.right != null) {
                                x.right.parent = x;
                            }
                            y.left = w.right;
                            if (y.left != null) {
                                y.left.parent = y;
                            }
                            w.left = x;
                            w.right = y;
                            x.parent = w;
                            y.parent = w;
                            if (w.balance == -1) {
                                x.balance = 0;
                                y.balance = 1;
                            } else if (w.balance == 0) {
                                x.balance = 0;
                                y.balance = 0;
                            } else {
                                x.balance = -1;
                                y.balance = 0;
                            }
                            w.balance = 0;
                            y = w;
                        } else {
                            x.parent = y.parent;
                            if (y.parent != null) {
                                if (y.parent.left == y) {
                                    y.parent.left = x;
                                } else {
                                    y.parent.right = x;
                                }
                            } else {
                                this.root = x;
                            }
                            y.left = x.right;
                            if (y.left != null) {
                                y.left.parent = y;
                            }
                            x.right = y;
                            y.parent = x;
                            if (x.balance == 0) {
                                x.balance = 1;
                                y.balance = -1;
                                choice = 0;
                            } else {
                                x.balance = 0;
                                y.balance = 0;
                                y = x;
                            }
                        }
                    }
                }
                if (choice == 0) {
                    --this.count;
                    return true;
                }
                if (y.parent != null) {
                    if (y == y.parent.left) {
                        y = y.parent;
                        choice = 1;
                        continue;
                    }
                    y = y.parent;
                    choice = 2;
                    continue;
                }
                --this.count;
                return true;
            }
        }
        return false;
    }

    public boolean contains(AVLItem item) {
        MonoAVLNode p = this.root;
        while (p != null) {
            int c = item.getNumber() - p.item.getNumber();
            if (c < 0) {
                p = p.left;
                continue;
            }
            if (c > 0) {
                p = p.right;
                continue;
            }
            return true;
        }
        return false;
    }

    public AVLItem get(int number) {
        MonoAVLNode p = this.root;
        while (p != null) {
            int c = number - p.item.getNumber();
            if (c < 0) {
                p = p.left;
                continue;
            }
            if (c > 0) {
                p = p.right;
                continue;
            }
            return p.item;
        }
        return null;
    }

    public void clear() {
        this.root = null;
        this.count = 0;
    }

    @Override
    public Iterator<AVLItem> iterator() {
        this.iterator.setNode(this);
        return this.iterator;
    }

    public int getCount() {
        return this.count;
    }

    private static class MonoAVLIterator
    implements Iterator<AVLItem>,
    ResetableIterator {
        private MonoAVLNode next;
        private AVLItem current;

        public MonoAVLIterator() {
        }

        public MonoAVLIterator(MonoAVLNode node) {
            this.next = node;
            this.goToDownLeft();
        }

        public MonoAVLIterator(MonoAVLTree tree) {
            this(tree.root);
        }

        public void setNode(MonoAVLTree tree) {
            this.next = tree.root;
            this.goToDownLeft();
        }

        private void goToDownLeft() {
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                return false;
            }
            this.current = this.next.item;
            if (this.next.right == null) {
                while (this.next.parent != null && this.next == this.next.parent.right) {
                    this.next = this.next.parent;
                }
                this.next = this.next.parent;
            } else {
                this.next = this.next.right;
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            return true;
        }

        @Override
        public AVLItem next() {
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MonoAVLNode {
        MonoAVLNode parent;
        MonoAVLNode left;
        MonoAVLNode right;
        int balance;
        AVLItem item;

        public MonoAVLNode(AVLItem item) {
            this.item = item;
        }

        public MonoAVLNode(AVLItem item, MonoAVLNode parent) {
            this.item = item;
            this.parent = parent;
        }
    }
}

