/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.collection.avl;

import java.util.Iterator;
import org.gephi.utils.collection.avl.ParamAVLNode;
import org.gephi.utils.collection.avl.ParamAVLTree;
import org.gephi.utils.collection.avl.ResetableIterator;

public class ParamAVLIterator<Item>
implements Iterator<Item>,
ResetableIterator {
    private ParamAVLTree tree;
    private ParamAVLNode<Item> next;
    private Item current;

    public ParamAVLIterator() {
    }

    public ParamAVLIterator(ParamAVLNode node) {
        this.next = node;
        this.goToDownLeft();
    }

    public ParamAVLIterator(ParamAVLTree tree) {
        this(tree.root);
        this.tree = tree;
    }

    public void setNode(ParamAVLTree tree) {
        this.next = tree.root;
        this.tree = tree;
        this.goToDownLeft();
    }

    private void goToDownLeft() {
        if (this.next != null) {
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            return false;
        }
        this.current = this.next.item;
        if (this.next.right == null) {
            while (this.next.parent != null && this.next == this.next.parent.right) {
                this.next = this.next.parent;
            }
            this.next = this.next.parent;
        } else {
            this.next = this.next.right;
            while (this.next.left != null) {
                this.next = this.next.left;
            }
        }
        return true;
    }

    @Override
    public Item next() {
        return this.current;
    }

    @Override
    public void remove() {
        this.tree.remove(this.current);
    }
}

