/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.workspace.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.WorkspaceInformation;
import org.openide.util.Lookup;

public class WorkspaceInformationImpl
implements WorkspaceInformation {
    private static int count = 0;
    private Project project;
    private String name;
    private Status status = Status.CLOSED;
    private String source;
    private transient List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public WorkspaceInformationImpl(Project project) {
        this(project, "Workspace " + (((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace() != null ? count : 0));
    }

    public WorkspaceInformationImpl(Project project, String name) {
        this.project = project;
        this.name = name;
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (pc.getCurrentWorkspace() == null) {
            count = 0;
        }
        ++count;
    }

    public String toString() {
        return this.name;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setName(String name) {
        this.name = name;
        this.fireChangeEvent();
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    public void open() {
        this.status = Status.OPEN;
        this.fireChangeEvent();
    }

    public void close() {
        this.status = Status.CLOSED;
        this.fireChangeEvent();
    }

    public void invalid() {
        this.status = Status.INVALID;
    }

    @Override
    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public boolean isInvalid() {
        return this.status == Status.INVALID;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public static enum Status {
        OPEN,
        CLOSED,
        INVALID;

    }
}

