# elasticsearch-bolt

A reusable Storm bolt for writing to Elasticsearch. Currently targets version 0.9 of Elasticsearch.

## Usage

Include the following in `project.clj`:

```
[elasticsearch-bolt "0.1.4"]
```

To use `elasticsearch-write` bolt in a topology:

```clojure
(topology
  {"spout" (spout-spec mock-write-spout)}
  {"bolt" (bolt-spec {"spout" elasticsearch-input-fields}
                     (elasticsearch-write "http://127.0.0.1:9200"))})
```

Input tuple:

```clojure
["meta" "index" "doctype" "docs"]
```

- `meta`: untouched to allow passing data through the bolt for further processing downstream where you will need additional information
- `index`: The name of the index to write the document to
- `doctype`: The doctype each document being written belongs to
- `docs`: Collection of hashmaps to be written to elasticsearch

Output tuple:

```
["meta" "result"]
```

- `meta`: Same as the input field `meta` untouched
- `result`: A keyword representing the result of the write `:success`

## Behavior

Documents are written in batch to Elasticsearch and acked. Emitted tuples are anchored by default. If any document fails to write the tuple will be failed. Check the Elasticsearch logs for more detailed information about the failure.

## Running tests

```
lein test
```

## Config

The `uri` argument passed to the `elasticsearch-write` bolt must have the following format:

```
http://{host}:9200/
```

## Incompatibilities with Storm v0.9.0.1

Due to the dependency on `elastisch`, there are incompatibility errors with storm distribution v0.9.0.1. The distribution includes a classpath in the `lib` directory which takes precedence over the jar submitted to the storm cluster. You will need to replace the following components in `storm-0.9.0.1/lib` on every supervisor node in the cluster.

1. Update `httpclient` and `httpcore`

On a build of a storm cluster from `storm-starter`, run the following as the `storm` user:

```
sudo wget http://repo1.maven.org/maven2/org/apache/httpcomponents/httpclient/4.3.2/httpclient-4.3.2.jar
sudo mv httpclient-4.2.5.jar httpclient-4.2.5.jar.bak
sudo wget http://repo1.maven.org/maven2/org/apache/httpcomponents/httpcore/4.3.2/httpcore-4.3.2.jar
sudo mv httpcore-4.1.jar httpcore-4.1.jar.bak
```

2. Kill all workers

Killing all the workers will force the worker processes to be restarted with the new classes in place.

```
sudo pkill -TERM -u storm -f 'backtype.storm.daemon.worker'
```
