# elasticsearch-bolt

## Changelog
* 2.2
  * Fixed connection issues, round robin now works.
  * Project is public again

* 2.1
  * Expects configuration field ELASTICSEARCH_CLUSTER_NAME, which the native drivers need to create a connection

A reusable Storm bolt for writing to Elasticsearch. Currently targets version 0.9 of Elasticsearch.

## Usage

Include the following in `project.clj`:

```
[com.shareablee/elasticsearch-bolt "0.2.1"]
```

### elasticsearch-write

To use `elasticsearch-write` bolt in a topology:

```clojure
(topology
  {"spout" (spout-spec mock-write-spout)}
  {"bolt" (bolt-spec {"spout" elasticsearch-write-input-fields}
                     (mk-es-write-bolt {"ELASTICSEARCH_HOSTS" "http://127.0.0.1:9300"}))})
```

Input tuple:

```clojure
["meta" "index" "doctype" "docs"]
```

- `meta`: untouched to allow passing data through the bolt for further processing downstream where you will need additional information
- `index`: The name of the index to write the document to
- `doctype`: The doctype each document being written belongs to
- `docs`: Collection of hashmaps to be written to elasticsearch

Output tuple:

```
["meta" "result"]
```

- `meta`: Same as the input field `meta` untouched
- `result`: A keyword representing the result of the write `:success`

Behavior:

Documents are written in batch to Elasticsearch and acked. Emitted tuples are anchored by default. If any document fails to write the tuple will be failed. Check the Elasticsearch logs for more detailed information about the failure.


Config:

The `uri` argument passed to the `mk-es-write-bolt` bolt must have the following format:

```
{"ELASTICSEARCH_HOSTS" "http://127.0.0.1:9300"}
```

### elasticsearch-update-with-script

Supports the update with script flavor of elasticsearch updates: http://www.elasticsearch.org/guide/en/elasticsearch/reference/current/docs-update.html

To use `elasticsearch-update-with-script` bolt in a topology:

```clojure
(topology
  {"spout" (spout-spec mock-write-spout)}
  {"bolt" (bolt-spec {"spout" elasticsearch-update-with-script-input-fields}
                     (mk-es-update-with-script-bolt {"ELASTICSEARCH_HOSTS" "http://127.0.0.1:9300"}))})
```

Input tuple:

```clojure
["meta" "index" "doctype" "id" "script" "params"]
```

- `meta`: untouched to allow passing data through the bolt for further processing downstream where you will need additional information
- `index`: The name of the index to write the document to
- `doctype`: The doctype of document that's getting updated
- `id`: _id in elasticsearch: http://www.elasticsearch.org/guide/en/elasticsearch/reference/current/mapping-id-field.html
- `script` - the update script in Groovy
- `params` - params that get fed to `script`

Output tuple:

```
["meta" "result"]
```

- `meta`: Same as the input field `meta` untouched
- `result`: A keyword representing the result of the update `:success`

Example:

TODO: copy paste example from links-sync when it's ready

For more on elasctisearch scripting see: http://www.elasticsearch.org/guide/en/elasticsearch/reference/current/modules-scripting.html

Behavior:

The document specified by `id` is updated with `script` and `params` and tuple is acked. Emitted tuple is anchored by default. If any update fails the tuple will be failed. Check the Elasticsearch logs for more detailed information about the failure.


Config:

The `uri` argument passed to the `mk-es-update-with-script-bolt` bolt must have the following format:

```
{"ELASTICSEARCH_HOSTS" "http://127.0.0.1:9300"}
```

### elasticsearch-update

To use `elasticsearch-update` bolt in a topology:

```clojure
(topology
  {"spout" (spout-spec mock-write-spout)}
  {"bolt" (bolt-spec {"spout" elasticsearch-update-input-fields}
                     (mk-es-update-bolt "http://127.0.0.1:9200"))})
```

Input tuple:

```clojure
["meta" "index" "doctype" "docs"]
```

- `meta`: untouched to allow passing data through the bolt for further processing downstream where you will need additional information
- `index`: The name of the index to write the document to
- `doctype`: The doctype each document being written belongs to
- `docs`: Collection of hashmaps to be written to elasticsearch

Output tuple:

```
["meta" "result"]
```

- `meta`: Same as the input field `meta` untouched
- `result`: A keyword representing the result of the write `:success`

Behavior:

If a document id already exists, the document is updated via merge. If a document does not exist it is inserted.

Config:

The `uri` argument passed to the `mk-es-update-bolt` bolt must have the following format:

```
{"ELASTICSEARCH_HOSTS" "http://127.0.0.1:9300"}
```

## Running tests

```
lein test
```
