/*
 * Decompiled with CFR 0.152.
 */
package com.shash.hbase.ds;

import com.shash.hbase.ds.AbstractRowKeyDistributor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class DistributedScanner
implements ResultScanner {
    private final AbstractRowKeyDistributor keyDistributor;
    private final ResultScanner[] scanners;
    private final List<Result>[] nextOfScanners;
    private Result next = null;

    public DistributedScanner(AbstractRowKeyDistributor keyDistributor, ResultScanner[] scanners) throws IOException {
        this.keyDistributor = keyDistributor;
        this.scanners = scanners;
        this.nextOfScanners = new List[scanners.length];
        for (int i = 0; i < this.nextOfScanners.length; ++i) {
            this.nextOfScanners[i] = new ArrayList<Result>();
        }
    }

    private boolean hasNext(int nbRows) throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.nextInternal(nbRows);
        return this.next != null;
    }

    public Result next() throws IOException {
        if (this.hasNext(1)) {
            Result toReturn = this.next;
            this.next = null;
            return toReturn;
        }
        return null;
    }

    public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[resultSets.size()]);
    }

    public void close() {
        for (int i = 0; i < this.scanners.length; ++i) {
            this.scanners[i].close();
        }
    }

    public static DistributedScanner create(Table hTable, Scan originalScan, AbstractRowKeyDistributor keyDistributor) throws IOException {
        Scan[] scans = keyDistributor.getDistributedScans(originalScan);
        ResultScanner[] rss = new ResultScanner[scans.length];
        for (int i = 0; i < scans.length; ++i) {
            rss[i] = hTable.getScanner(scans[i]);
        }
        return new DistributedScanner(keyDistributor, rss);
    }

    private Result nextInternal(int nbRows) throws IOException {
        Result result = null;
        int indexOfScannerToUse = -1;
        for (int i = 0; i < this.nextOfScanners.length; ++i) {
            if (this.nextOfScanners[i] == null) continue;
            if (this.nextOfScanners[i].size() == 0) {
                Result[] results = this.scanners[i].next(nbRows);
                if (results.length == 0) {
                    this.nextOfScanners[i] = null;
                    continue;
                }
                this.nextOfScanners[i].addAll(Arrays.asList(results));
            }
            if (result != null && Bytes.compareTo((byte[])this.keyDistributor.getOriginalKey(this.nextOfScanners[i].get(0).getRow()), (byte[])this.keyDistributor.getOriginalKey(result.getRow())) >= 0) continue;
            result = this.nextOfScanners[i].get(0);
            indexOfScannerToUse = i;
        }
        if (indexOfScannerToUse >= 0) {
            this.nextOfScanners[indexOfScannerToUse].remove(0);
        }
        return result;
    }

    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            Result next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = DistributedScanner.this.next();
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    return null;
                }
                Result temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

