(ns signal.data-platform-telemetry.tracing
  "Utilities namespace for tracing helpers
   Use  steffan-westcott.clj-otel lib directly for tracing implementation."
  (:require [steffan-westcott.clj-otel.context :as otel-context]))

(defn bind-span-context
  "Returns a function which wraps the given function, propagating the span context.
   Useful with pmap, where the actual code is ran in a separate thread so loses the span context."
  [f]
  (let [context (otel-context/current)]
    (fn [& args]
      (otel-context/with-context! context
        (apply f args)))))

(defn namespace-attributes
  "Namespaces the given attribute map with the signalai prefix
   This ensures we don't clash with other libraries' attributes

   https://github.com/open-telemetry/opentelemetry-specification/blob/ded25b221d8405e9dae4bc6aa293e9002c2aedbe/specification/common/attribute-naming.md#recommendations-for-application-developers"
  [attrs]
  (update-keys attrs
               (fn [k] (let [base-name (if (keyword? k) (name k) k)]
                         (str "signalai." base-name)))))
