# signal-logging-timbre

Logging is hard - <https://signal-ai.getoutline.com/doc/logging-oiwQo3JNFl>

This library attempts to pave a road so you have less to do.

It includes

-   [timbre](https://github.com/ptaoussanis/timbre)
-   a JSON appender for timbre
-   changes to the default console appender to support timbre context and log thread names
-   libraries to setup a bridge for JVM based logging libraries -> SLF4J -> Timbre so it can collect library logs

## Usage

[![Clojars Project](https://img.shields.io/clojars/v/com.signal-ai/logging-timbre.svg)](https://clojars.org/com.signal-ai/logging-timbre)

1. Include this libary in your project.clj

```project.clj
[com.signal-ai/logging-timbre "0.1.0"]
```

2. Exclude any transitive dependencies you might have on logging libraries by [adding these exlusions to your project.clj](https://github.com/signal-ai/signal-logging-timbre/blob/master/project.clj#L16)

3. Then when you need to log something, call out to timbre as you normally would:

```clj
(require '[taoensso.timbre :as log])
(require '[signal.logging :as logging])

(logging/init! {:namespace (logging/get-namespace-prefix)
                :json (= config/environment "production")
                :min-level :info})

(log/error (IllegalStateException. "Not logged in") "Oh No!" {:some-arg "hello" :some-other-arg "world"})

;; keyword-style arguments can also be used
(log/info "Info!" :some-arg "hello" :some-other-arg "world")

;; timbre context is fully supported
(log/with-context {:user-id "123"}
    (log/with-context+ {:extra-field "This will be added to the parent context rather than overriding it."}
    (log/info "This will contain the user-id" :some-context 1234)))
```

alternatively, to always log json but prettify it in development, call `logging/init!` with

```clojure
(logging/init! {:namespace (logging/get-namespace-prefix)
                :json {:pretty true}})
```

### Ring

The package includes some utilities for use with ring spec HTTP servers:

-   `wrap-logging` - adds logging to HTTP requests/responamespacees
-   `set-log-level-handler` - a ring handler which acceps POST requests with `level` parameters to update the service log level.

```clj
(require '[signal.logging.ring :refer [wrap-logging set-log-level-handler]])


(defroutes ring-router
  (POST "/api/loglevel" request (set-log-level-handler request))
  (ANY "*" []
    (route/not-found "Not found")))

(def ring-handler
  (-> ring-router
      wrap-logging
      (wrap-defaults ring-router api-defaults)))
```

## License

Copyright © 2021 Signal AI

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
